/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.pluginview.contextmenu;

import devplugin.ActionMenu;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import tvbrowser.ui.pluginview.Node;
import tvbrowser.ui.pluginview.PluginTree;
import tvbrowser.ui.pluginview.contextmenu.AbstractContextMenu;
import util.ui.menu.MenuUtil;

public class CustomNodeContextMenu
extends AbstractContextMenu {
    private Action mDefaultAction;
    private ActionMenu[] mActionMenus;
    private TreePath mPath;

    public CustomNodeContextMenu(PluginTree tree, TreePath path, ActionMenu[] menus) {
        super(tree);
        if (((Node)path.getLastPathComponent()).getAllowsChildren()) {
            this.mDefaultAction = this.getCollapseExpandAction(path);
        }
        this.mActionMenus = menus;
        this.mPath = path;
        if (this.mActionMenus == null) {
            this.mActionMenus = new ActionMenu[0];
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        if (this.mDefaultAction != null) {
            JMenuItem defaultMI = new JMenuItem(this.mDefaultAction);
            menu.add(defaultMI);
            defaultMI.setFont(MenuUtil.CONTEXT_MENU_BOLDFONT);
        }
        if (((Node)this.mPath.getLastPathComponent()).getAllowsChildren()) {
            menu.add(this.getExpandAllMenuItem(this.mPath));
            menu.add(this.getCollapseAllMenuItem(this.mPath));
            menu.add(this.getFilterMenuItem(this.mPath));
            menu.add(this.getExportMenu(this.mPath));
        }
        if (this.mActionMenus.length > 0) {
            if (this.mDefaultAction != null) {
                menu.addSeparator();
            }
            for (ActionMenu actionMenu : this.mActionMenus) {
                if (actionMenu.getAction() == this.mDefaultAction) continue;
                JMenuItem menuItem = MenuUtil.createMenuItem(actionMenu);
                if (menuItem == null) {
                    menu.addSeparator();
                    continue;
                }
                menu.add(menuItem);
            }
        }
        return menu;
    }

    @Override
    public Action getDefaultAction() {
        return null;
    }
}

