/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable;

import tvbrowser.ui.programtable.AbstractProgramTableLayout;
import tvbrowser.ui.programtable.ProgramTableModel;
import util.ui.ProgramPanel;

public class CompactLayout
extends AbstractProgramTableLayout {
    @Override
    public void updateLayout(ProgramTableModel model) {
        int rowCount;
        int col;
        int columnCount = model.getColumnCount();
        int[] columnStartArr = new int[columnCount];
        int[] columnHeightArr = new int[columnCount];
        int maxColHeight = 0;
        for (col = 0; col < columnCount; ++col) {
            rowCount = model.getRowCount(col);
            for (int row = 0; row < rowCount; ++row) {
                ProgramPanel panel = model.getProgramPanel(col, row);
                int n = col;
                columnHeightArr[n] = columnHeightArr[n] + panel.getPreferredHeight();
            }
            maxColHeight = Math.max(columnHeightArr[col], maxColHeight);
        }
        for (col = 0; col < columnCount; ++col) {
            rowCount = model.getRowCount(col);
            int difference = maxColHeight - columnHeightArr[col];
            for (int row = 0; row < rowCount; ++row) {
                int remainingRows = rowCount - row;
                int yPlus = difference / remainingRows;
                ProgramPanel panel = model.getProgramPanel(col, row);
                int height = panel.getPreferredHeight();
                difference -= yPlus;
                panel.setHeight(height += yPlus);
            }
        }
        this.setColumnStarts(columnStartArr);
    }
}

