/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import devplugin.Channel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.channel.ChannelJList;
import util.i18n.Localizer;
import util.ui.ChannelListCellRenderer;
import util.ui.UiUtilities;

public class ChannelListChangesDialog
extends JDialog {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ChannelListChangesDialog.class);
    private ArrayList<Channel> mAddedList;
    private ArrayList<Channel> mDeletedList;

    public ChannelListChangesDialog(JDialog owner, ArrayList<Channel> addedList, ArrayList<Channel> deletedList, boolean showSettingsLink) {
        super((Dialog)owner, true);
        this.createGui(addedList, deletedList, showSettingsLink);
    }

    public ChannelListChangesDialog(JFrame owner, ArrayList<Channel> addedList, ArrayList<Channel> deletedList, boolean showSettingsLink) {
        super((Frame)owner, true);
        this.createGui(addedList, deletedList, showSettingsLink);
    }

    private void createGui(ArrayList<Channel> addedList, ArrayList<Channel> deletedList, boolean showSettingsLink) {
        this.mAddedList = addedList;
        this.mDeletedList = deletedList;
        this.createGui(showSettingsLink);
    }

    private void createGui(boolean showSettingsLink) {
        this.setTitle(LOCALIZER.msg("title", "Channel changes"));
        this.setLocationRelativeTo(this.getParent());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridLayout(1, 2, 10, 0));
        JPanel panelAdded = new JPanel(new BorderLayout());
        panelAdded.setBorder(BorderFactory.createTitledBorder(LOCALIZER.msg("added", "New channels: {0}", this.mAddedList.size())));
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        for (int i = 0; i < this.mAddedList.size(); ++i) {
            listModel.addElement(this.mAddedList.get(i));
        }
        ChannelJList list = new ChannelJList(listModel);
        list.setCellRenderer(new ChannelListCellRenderer(true, true));
        panelAdded.add((Component)new JScrollPane(list), "Center");
        JPanel panelDeleted = new JPanel(new BorderLayout());
        panelDeleted.setBorder(BorderFactory.createTitledBorder(LOCALIZER.msg("deleted", "Removed channels: {0}", this.mDeletedList.size())));
        listModel = new DefaultListModel();
        for (int i = 0; i < this.mDeletedList.size(); ++i) {
            listModel.addElement(this.mDeletedList.get(i));
        }
        list = new ChannelJList(listModel);
        list.setCellRenderer(new ChannelListCellRenderer(true, true));
        panelDeleted.add((Component)new JScrollPane(list), "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(2));
        JButton copyToClipboard = new JButton(LOCALIZER.msg("copyToClipboard", "Copy to clipboard"));
        copyToClipboard.addActionListener(e -> {
            StringBuilder b = new StringBuilder();
            if (!this.mDeletedList.isEmpty()) {
                b.append(LOCALIZER.msg("deleted", "Removed channels: {0}", this.mDeletedList.size())).append("\n-------------------");
            }
            for (Channel ch : this.mDeletedList) {
                b.append("\n").append(ch.toString()).append(" (").append(ch.getCountriesString()).append(")");
            }
            if (!this.mAddedList.isEmpty()) {
                if (b.length() > 0) {
                    b.append("\n\n");
                }
                b.append(LOCALIZER.msg("added", "New channels: {0}", this.mAddedList.size())).append("\n---------------");
                for (Channel ch : this.mAddedList) {
                    b.append("\n").append(ch.toString()).append(" (").append(ch.getCountriesString()).append(")");
                }
            }
            try {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(b.toString()), null);
                JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("copyMessage", "Channels copied to system clipboard."), LOCALIZER.ellipsisMsg("copyTitle", "Channels copied"), 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        btnPanel.add(copyToClipboard);
        if (showSettingsLink) {
            JButton openSettings = new JButton(LOCALIZER.msg("openSettings", "Open channel settings"));
            openSettings.addActionListener(e -> {
                this.setVisible(false);
                SwingUtilities.invokeLater(() -> PluginManagerImpl.getInstance().showSettings("#channels"));
                this.dispose();
            });
            btnPanel.add(openSettings);
        }
        JButton ok = new JButton(Localizer.getLocalization("i18n_close"));
        ok.addActionListener(e -> this.dispose());
        btnPanel.add(ok);
        contentPanel.add(panelAdded);
        contentPanel.add(panelDeleted);
        JPanel pane = (JPanel)this.getContentPane();
        pane.add((Component)contentPanel, "Center");
        pane.add((Component)btnPanel, "South");
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public static void showChannelChanges(Window owner, List<Channel> channelsBefore, List<Channel> channelsAfter, boolean showSettingsLink) {
        int i;
        ArrayList<Channel> addedList = new ArrayList<Channel>();
        ArrayList<Channel> deletedList = new ArrayList<Channel>();
        for (i = 0; i < channelsAfter.size(); ++i) {
            if (channelsBefore.contains(channelsAfter.get(i))) continue;
            addedList.add(channelsAfter.get(i));
        }
        Collections.sort(addedList);
        for (i = 0; i < channelsBefore.size(); ++i) {
            if (channelsAfter.contains(channelsBefore.get(i))) continue;
            deletedList.add(channelsBefore.get(i));
        }
        Collections.sort(deletedList);
        if (addedList.isEmpty() && deletedList.isEmpty()) {
            if (!showSettingsLink) {
                JOptionPane.showMessageDialog(owner, LOCALIZER.msg("noChanges.message", "There are no changes in the list of available channels."), LOCALIZER.msg("noChanges.title", "No changes"), 1);
            }
        } else {
            ChannelListChangesDialog changesDialog = null;
            if (owner instanceof JDialog) {
                changesDialog = new ChannelListChangesDialog((JDialog)owner, addedList, deletedList, showSettingsLink);
            } else if (owner instanceof JFrame) {
                changesDialog = new ChannelListChangesDialog((JFrame)owner, addedList, deletedList, showSettingsLink);
            }
            if (changesDialog != null) {
                Settings.layoutWindow("channelListChangesDialog", changesDialog);
                changesDialog.setVisible(true);
            }
        }
    }
}

