/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ActionMenu;
import devplugin.ContextMenuIf;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.SettingsTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import tvbrowser.core.Settings;
import tvbrowser.core.contextmenu.ConfigMenuItem;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.contextmenu.LeaveFullScreenMenuItem;
import tvbrowser.core.contextmenu.SeparatorMenuItem;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.plugin.PluginStateAdapter;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.settings.util.LineButton;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.FixedSizeIcon;
import util.ui.LineComponent;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemList;
import util.ui.customizableitems.SelectableItemRendererCenterComponentIf;
import util.ui.customizableitems.SortableItemList;
import util.ui.html.HTMLTextHelper;

public class ContextmenuSettingsTab
implements SettingsTab {
    public static final String SEPARATOR_SUB_MENUS_DISABLED = "##_#_##";
    public static final String SEPARATOR_SUB_MENUS_DISABLED_IDS = ";;_#_;;";
    private SortableItemList<ContextMenuIf> mList;
    private ArrayList<ContextMenuIf> mEditableMenus;
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ContextmenuSettingsTab.class);
    private int mSelectionWidth;
    private ArrayList<ContextMenuIf> mDeactivatedItems;
    private HashMap<ContextMenuIf, HashSet<Integer>> mDisabledSubMenusMap;

    @Override
    public JPanel createSettingsPanel() {
        this.mEditableMenus = new ArrayList();
        this.mDisabledSubMenusMap = ContextMenuManager.getDisabledSubMenuMap();
        JEditorPane genericFilterLink = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("genericFilterLink", "<html><span style=\"color:red\">*</span> <a href=\"\">Highlighting filter</a> activated for context menu filtering</html>"), new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    PluginManagerImpl.getInstance().showSettings("#genericPluginFilter");
                }
            }
        });
        this.createList();
        EnhancedPanelBuilder contentPanel = new EnhancedPanelBuilder(new FormLayout("5dlu, default, 3dlu, default, fill:default:grow, 3dlu"));
        contentPanel.border(Borders.DIALOG);
        contentPanel.addSeparatorRowFull(false, LOCALIZER.msg("title", "Title"));
        contentPanel.addRowFull(UiUtilities.createHelpTextArea(LOCALIZER.msg("ItemOrder", "Item Order:")), 2);
        contentPanel.addRowFull("3dlu, fill:pref:grow", this.mList, 2);
        contentPanel.addRowFull("2dlu, default", (Component)genericFilterLink, 2);
        this.fillListbox();
        return contentPanel.getPanel();
    }

    private void showSubMenuConfigurationDialog(ContextMenuIf menuIf) {
        final JDialog d = UiUtilities.createDialog(SettingsDialog.getInstance().getDialog(), true);
        d.setTitle(LOCALIZER.msg("subMenuDialogTitle", "Shown deactivateable sub menus"));
        ActionMenu menu = menuIf.getContextMenuActions(PluginManagerImpl.getInstance().getExampleProgram());
        ActionMenu[] subItems = menu.getSubItems();
        ArrayList<ActionMenu> available = new ArrayList<ActionMenu>();
        ArrayList<ActionMenu> selected = new ArrayList<ActionMenu>();
        HashSet<Integer> disabledMenus = this.mDisabledSubMenusMap.get(menuIf);
        for (ActionMenu subItem : subItems) {
            ActionMenu[] subSubItems;
            if (subItem.getActionId() != -1) {
                available.add(subItem);
                if (disabledMenus != null && disabledMenus.contains(subItem.getActionId())) continue;
                selected.add(subItem);
                continue;
            }
            if (subItem.getSubItems() == null) continue;
            for (ActionMenu subSubItem : subSubItems = subItem.getSubItems()) {
                if (subSubItem.getActionId() == -1) continue;
                available.add(subSubItem);
                if (disabledMenus != null && disabledMenus.contains(subSubItem.getActionId())) continue;
                selected.add(subSubItem);
            }
        }
        SelectableItemList<ActionMenu> listItems = new SelectableItemList<ActionMenu>(selected.toArray(new ActionMenu[selected.size()]), available.toArray(new ActionMenu[available.size()]));
        listItems.addCenterRendererComponent(ActionMenu.class, new SelectableItemRendererCenterComponentIf<ActionMenu>(){

            @Override
            public JPanel createCenterPanel(JList<? extends SelectableItem<ActionMenu>> list, ActionMenu value, int index, boolean isSelected, boolean isEnabled, JScrollPane parentScrollPane, int leftColumnWidth) {
                JLabel label = new JLabel();
                label.setHorizontalAlignment(10);
                label.setVerticalAlignment(0);
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)label, "West");
                Object icon = value.getAction().getValue("SmallIcon");
                if (icon != null && icon instanceof Icon) {
                    label.setIcon((Icon)icon);
                }
                label.setText(HTMLTextHelper.checkTextForTextFormatingTags(value.getTitle()));
                if (isSelected && isEnabled) {
                    panel.setOpaque(true);
                    label.setForeground(list.getSelectionForeground());
                    panel.setBackground(list.getSelectionBackground());
                } else {
                    panel.setOpaque(false);
                    label.setForeground(list.getForeground());
                    panel.setBackground(list.getBackground());
                }
                return panel;
            }

            @Override
            public void calculateSize(JList<? extends SelectableItem<ActionMenu>> list, int index, JPanel contentPane) {
            }
        });
        JButton cancel = new JButton(Localizer.getLocalization("i18n_cancel"));
        cancel.addActionListener(e -> d.dispose());
        JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
        ok.addActionListener(e -> {
            HashSet<Integer> result = new HashSet<Integer>();
            List selection = listItems.getSelectionList();
            for (ActionMenu menuAction : available) {
                if (selection.contains(menuAction)) continue;
                result.add(menuAction.getActionId());
            }
            if (result.isEmpty()) {
                this.mDisabledSubMenusMap.remove(menuIf);
            } else {
                this.mDisabledSubMenusMap.put(menuIf, result);
            }
            d.dispose();
        });
        UiUtilities.registerForClosing(new WindowClosingIf(){

            @Override
            public JRootPane getRootPane() {
                return d.getRootPane();
            }

            @Override
            public void close() {
                d.dispose();
            }
        });
        JPanel content = new JPanel((LayoutManager)new FormLayout("100dlu:grow,default,5dlu,default", "fill:100dlu:grow,5dlu,default"));
        content.setBorder(Borders.DIALOG);
        content.add(listItems, CC.xyw((int)1, (int)1, (int)4));
        content.add((Component)cancel, CC.xy((int)2, (int)3));
        content.add((Component)ok, CC.xy((int)4, (int)3));
        d.setContentPane(content);
        Settings.layoutWindow("contextMenuConfigSubMenusDialog", d, new Dimension(200, 200));
        d.setVisible(true);
    }

    private void createList() {
        final JButton configSubMenus = new JButton(TVBrowserIcons.preferences(22));
        configSubMenus.setEnabled(false);
        configSubMenus.setToolTipText(LOCALIZER.msg("subMenuButtonTooltip", "Configure shown deactivateable sub menus"));
        configSubMenus.addActionListener(e -> this.showSubMenuConfigurationDialog(this.mList.getList().getSelectedValue()));
        this.mList = new SortableItemList();
        this.mList.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = ContextmenuSettingsTab.this.mList.getList().locationToIndex(e.getPoint());
                if (index != -1) {
                    ContextMenuIf item = ContextmenuSettingsTab.this.mList.getList().getModel().getElementAt(index);
                    configSubMenus.setEnabled(ContextmenuSettingsTab.this.isEditable(item));
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (configSubMenus.isEnabled() && e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    ContextmenuSettingsTab.this.showSubMenuConfigurationDialog(ContextmenuSettingsTab.this.mList.getList().getSelectedValue());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                int index;
                if (evt.getX() < ContextmenuSettingsTab.this.mSelectionWidth && (index = ContextmenuSettingsTab.this.mList.getList().locationToIndex(evt.getPoint())) != -1) {
                    ContextMenuIf item = ContextmenuSettingsTab.this.mList.getList().getModel().getElementAt(index);
                    if (!ContextmenuSettingsTab.this.mDeactivatedItems.remove(item)) {
                        ContextmenuSettingsTab.this.mDeactivatedItems.add(item);
                        configSubMenus.setEnabled(false);
                    } else {
                        configSubMenus.setEnabled(ContextmenuSettingsTab.this.isEditable(item));
                    }
                    ContextmenuSettingsTab.this.mList.repaint();
                }
            }
        });
        this.mList.setCellRenderer(new ContextMenuCellRenderer());
        PluginProxyManager.getInstance().addPluginStateListener(new PluginStateAdapter(){

            @Override
            public void pluginActivated(PluginProxy proxy) {
                ContextmenuSettingsTab.this.fillListbox();
            }

            @Override
            public void pluginDeactivated(PluginProxy proxy) {
                ContextmenuSettingsTab.this.fillListbox();
            }
        });
        this.mList.addButton(configSubMenus);
        LineButton addSeparator = new LineButton();
        addSeparator.setToolTipText(LOCALIZER.msg("separator", "Add Separator"));
        addSeparator.addActionListener(e -> {
            int pos = this.mList.getList().getSelectedIndex();
            if (pos < 0) {
                pos = this.mList.getList().getModel().getSize();
            }
            this.mList.addElement(pos, new SeparatorMenuItem());
            this.mList.getList().setSelectedIndex(pos);
            this.mList.getList().ensureIndexIsVisible(pos);
        });
        this.mList.addButton(addSeparator);
        JButton garbage = new JButton(TVBrowserIcons.delete(22));
        garbage.setToolTipText(LOCALIZER.msg("garbage", "Remove Separator"));
        garbage.addActionListener(e -> {
            List<ContextMenuIf> items = this.mList.getList().getSelectedValuesList();
            for (ContextMenuIf item : items) {
                this.mList.removeElement(item);
            }
        });
        this.mList.getList().addListSelectionListener(e -> {
            List<ContextMenuIf> items = this.mList.getList().getSelectedValuesList();
            if (items.size() == 0) {
                garbage.setEnabled(false);
                return;
            }
            for (int i = 0; i < items.size(); ++i) {
                if (items.get(i) instanceof SeparatorMenuItem) continue;
                garbage.setEnabled(false);
                return;
            }
            garbage.setEnabled(true);
        });
        garbage.setEnabled(false);
        this.mList.addButton(garbage);
    }

    private final boolean isEditable(ContextMenuIf menuIf) {
        return !(menuIf instanceof SeparatorMenuItem) && !(menuIf instanceof ConfigMenuItem) && !(menuIf instanceof LeaveFullScreenMenuItem) && !this.mDeactivatedItems.contains(menuIf) && this.mEditableMenus.contains(menuIf) && this.mList.getList().getSelectedIndices().length == 1;
    }

    private void fillListbox() {
        if (this.mList == null) {
            return;
        }
        this.mList.removeAllElements();
        ArrayList<ContextMenuIf> items = new ArrayList<ContextMenuIf>();
        this.mEditableMenus.clear();
        ContextMenuIf[] menuIfList = ContextMenuManager.getInstance().getAvailableContextMenuIfs(true, false);
        Program exampleProgram = Plugin.getPluginManager().getExampleProgram();
        block0: for (ContextMenuIf menuIf : menuIfList) {
            if (menuIf instanceof SeparatorMenuItem) {
                this.mList.addElement(menuIf);
                continue;
            }
            if (menuIf instanceof ConfigMenuItem || menuIf instanceof LeaveFullScreenMenuItem) {
                this.mList.addElement(menuIf);
                continue;
            }
            ActionMenu actionMenu = menuIf.getContextMenuActions(exampleProgram);
            if (actionMenu == null) continue;
            this.mList.addElement(menuIf);
            items.add(menuIf);
            ActionMenu[] subItems = actionMenu.getSubItems();
            if (subItems == null) continue;
            block1: for (ActionMenu item : subItems) {
                if (item.getActionId() != -1) {
                    this.mEditableMenus.add(menuIf);
                    continue block0;
                }
                ActionMenu[] subSubItems = item.getSubItems();
                if (subSubItems == null) continue;
                for (ActionMenu subItem : subSubItems) {
                    if (subItem.getActionId() == -1) continue;
                    this.mEditableMenus.add(menuIf);
                    continue block1;
                }
            }
        }
        this.mDeactivatedItems = new ArrayList<ContextMenuIf>(ContextMenuManager.getDisabledContextMenuIfs());
    }

    @Override
    public void saveSettings() {
        Object[] o = this.mList.getItems();
        ArrayList<String> pluginIDsList = new ArrayList<String>();
        String[] orderIDs = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            ContextMenuIf menuIf = (ContextMenuIf)o[i];
            orderIDs[i] = menuIf.getId();
            if (!(menuIf instanceof PluginProxy)) continue;
            pluginIDsList.add(menuIf.getId());
        }
        ArrayList<String> listDisabledSubMenus = new ArrayList<String>();
        if (!this.mDisabledSubMenusMap.isEmpty()) {
            Set<ContextMenuIf> keys = this.mDisabledSubMenusMap.keySet();
            for (ContextMenuIf key : keys) {
                HashSet<Integer> set = this.mDisabledSubMenusMap.get(key);
                if (set == null || set.isEmpty()) continue;
                StringBuilder disabledSubMenus = new StringBuilder(key.getId());
                disabledSubMenus.append(SEPARATOR_SUB_MENUS_DISABLED);
                for (Integer value : set) {
                    disabledSubMenus.append(value).append(SEPARATOR_SUB_MENUS_DISABLED_IDS);
                }
                disabledSubMenus.delete(disabledSubMenus.length() - SEPARATOR_SUB_MENUS_DISABLED_IDS.length(), disabledSubMenus.length());
                listDisabledSubMenus.add(disabledSubMenus.toString());
            }
        }
        Settings.ContextMenu.DISABLED_SUB_ITEMS.setStringArray(listDisabledSubMenus.toArray(new String[listDisabledSubMenus.size()]));
        String[] pluginIDs = new String[pluginIDsList.size()];
        pluginIDsList.toArray(pluginIDs);
        Settings.ContextMenu.MENU_ORDER.setStringArray(orderIDs);
        Settings.Plugins.PLUGIN_ORDER.setStringArray(pluginIDs);
        PluginProxyManager.getInstance().setPluginOrder(pluginIDs);
        String[] deactivated = new String[this.mDeactivatedItems.size()];
        for (int i = 0; i < this.mDeactivatedItems.size(); ++i) {
            deactivated[i] = this.mDeactivatedItems.get(i).getId();
        }
        Settings.ContextMenu.DISABLED_ITEMS.setStringArray(deactivated);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "context menu");
    }

    class ContextMenuCellRenderer
    extends DefaultListCellRenderer {
        private JCheckBox mItemSelected = new JCheckBox();
        private JLabel mItemLabel;
        private JLabel mInfoLabel;
        private JPanel mItemPanel;

        public ContextMenuCellRenderer() {
            this.mItemSelected.setOpaque(false);
            ContextmenuSettingsTab.this.mSelectionWidth = this.mItemSelected.getPreferredSize().width;
            this.mItemLabel = new JLabel();
            this.mInfoLabel = new JLabel("*");
            this.mInfoLabel.setForeground(Color.red);
            this.mInfoLabel.setVisible(false);
            this.mItemPanel = new JPanel((LayoutManager)new FormLayout("default,default,default", "default"));
            this.mItemPanel.add((Component)this.mItemSelected, CC.xy((int)1, (int)1));
            this.mItemPanel.add((Component)this.mItemLabel, CC.xy((int)2, (int)1));
            this.mItemPanel.add((Component)this.mInfoLabel, CC.xy((int)3, (int)1));
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof SeparatorMenuItem) {
                LineComponent comp = new LineComponent(label.getForeground());
                comp.setBackground(label.getBackground());
                comp.setOpaque(isSelected);
                comp.setPreferredSize(label.getPreferredSize());
                return comp;
            }
            if (value instanceof ConfigMenuItem) {
                this.mItemSelected.setSelected(!ContextmenuSettingsTab.this.mDeactivatedItems.contains(value));
                this.mItemLabel.setIcon(TVBrowserIcons.preferences(16));
                this.mItemLabel.setText(HTMLTextHelper.checkTextForTextFormatingTags(value.toString()));
                this.mItemLabel.setForeground(label.getForeground());
                this.mItemPanel.setBackground(label.getBackground());
                this.mItemPanel.setOpaque(isSelected);
                return this.mItemPanel;
            }
            if (value instanceof LeaveFullScreenMenuItem) {
                this.mItemSelected.setSelected(!ContextmenuSettingsTab.this.mDeactivatedItems.contains(value));
                this.mItemLabel.setIcon(TVBrowserIcons.fullScreen(16));
                this.mItemLabel.setText(value.toString());
                this.mItemLabel.setForeground(label.getForeground());
                this.mItemPanel.setBackground(label.getBackground());
                this.mItemPanel.setOpaque(isSelected);
                return this.mItemPanel;
            }
            if (value instanceof ContextMenuIf) {
                PluginProxy proxy;
                ContextMenuIf menuIf = (ContextMenuIf)value;
                Program exampleProgram = Plugin.getPluginManager().getExampleProgram();
                StringBuilder text = new StringBuilder();
                Icon icon = null;
                ActionMenu actionMenu = menuIf.getContextMenuActions(exampleProgram);
                if (actionMenu != null) {
                    Action action = actionMenu.getAction();
                    if (action != null) {
                        text.append((String)action.getValue("Name"));
                        icon = (Icon)action.getValue("SmallIcon");
                        if (icon != null) {
                            icon = new FixedSizeIcon(16, 16, icon);
                        }
                    } else if (menuIf instanceof PluginProxy) {
                        text.append(((PluginProxy)menuIf).getInfo().getName());
                        icon = ((PluginProxy)menuIf).getMarkIcon();
                    } else {
                        text.append("unknown");
                        icon = null;
                    }
                }
                this.mInfoLabel.setVisible((proxy = PluginProxyManager.getInstance().getActivatedPluginForId(menuIf.getId())) != null && GenericFilterMap.getInstance().getGenericPluginFilter(proxy, true) != null);
                if (cellHasFocus) {
                    this.mInfoLabel.setForeground(label.getForeground());
                } else {
                    this.mInfoLabel.setForeground(Color.red);
                }
                this.mItemLabel.setIcon(icon);
                this.mItemLabel.setText(text.toString());
                this.mItemLabel.setForeground(label.getForeground());
                this.mItemSelected.setSelected(!ContextmenuSettingsTab.this.mDeactivatedItems.contains(value));
                this.mItemPanel.setBackground(label.getBackground());
                this.mItemPanel.setOpaque(isSelected);
                return this.mItemPanel;
            }
            return label;
        }
    }
}

