/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.util.ColorButton;
import tvbrowser.ui.settings.util.ColorLabel;
import util.i18n.Localizer;
import util.i18n.PooledLocalizer;
import util.ui.DefaultMarkingPrioritySelectionPanel;
import util.ui.EnhancedPanelBuilder;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class MarkingsSettingsTab
implements SettingsTab {
    public static final Localizer LOCALIZER = PooledLocalizer.getLocalizerFor(MarkingsSettingsTab.class);
    private JCheckBox mProgramItemWithMarkingsIsShowingBorder;
    private JCheckBox mProgramPanelUsesExtraSpaceForMarkIcons;
    private JEditorPane mHelpLabel;
    private int mPriorityCount;
    private JPanel mHighlightings;
    private DefaultMarkingPrioritySelectionPanel mDefaultColors;

    @Override
    public JPanel createSettingsPanel() {
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("5dlu,default:grow,default"));
        pb.border(Borders.DIALOG);
        EnhancedPanelBuilder defaultMarkings = new EnhancedPanelBuilder(new FormLayout("default:grow"), "2dlu");
        this.mProgramPanelUsesExtraSpaceForMarkIcons = new JCheckBox(LOCALIZER.msg("panel.extraSpace", "Use additional space for the mark icons"), Settings.Markings.USES_EXTRA_SPACE_FOR_MARK_ICONS.getBoolean());
        defaultMarkings.addRow(false, (Component)this.mProgramPanelUsesExtraSpaceForMarkIcons, 1);
        this.mProgramItemWithMarkingsIsShowingBorder = new JCheckBox(LOCALIZER.msg("color.showBorder", "Show border for highlighted programs"), Settings.Markings.WITH_MARKINGS_SHOWING_BORDER.getBoolean());
        defaultMarkings.addRow(this.mProgramItemWithMarkingsIsShowingBorder, 1);
        this.mDefaultColors = DefaultMarkingPrioritySelectionPanel.createPanel(new int[]{Settings.Markings.MARK_PRIORITY_DEFAULT.getInt(), Settings.Markings.MARK_PRIORITY_FILTERS.getInt()}, new String[]{LOCALIZER.msg("color.highlightedByPlugins", "Highlighted by plugins:"), LOCALIZER.msg("color.highlightedByFilters", "Highlighted by filters:")}, false, false, false);
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("color.help", "The priority that a plugin uses for a program is used to decide which color have to be used for the marking. A higher priority color replaces a lower priority color. The setting for the default color is only for plugins that do not care about the priority. But it works like for plugins that uses the priorities, so if you select the highest priority color there, all marking of plugin which do not care about the priority will replace lower marking colors."), e -> {});
        this.mHighlightings = new JPanel();
        this.mHighlightings.setLayout(new BoxLayout(this.mHighlightings, 1));
        ActionListener delete = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HighlightPanel lastPanel = (HighlightPanel)MarkingsSettingsTab.this.mHighlightings.getComponent(MarkingsSettingsTab.this.mHighlightings.getComponentCount() - 1);
                if (!lastPanel.isDefaultColor()) {
                    MarkingsSettingsTab.this.mHighlightings.remove(lastPanel);
                    --MarkingsSettingsTab.this.mPriorityCount;
                    lastPanel = (HighlightPanel)MarkingsSettingsTab.this.mHighlightings.getComponent(MarkingsSettingsTab.this.mHighlightings.getComponentCount() - 1);
                    if (!lastPanel.isDefaultColor()) {
                        lastPanel.setDeleteEnabled(true);
                    }
                    MarkingsSettingsTab.this.mHighlightings.revalidate();
                }
            }
        };
        int[] currentColors = Settings.Markings.HIGHLIGHTING_COLORS.getIntArray();
        int[] currentDefaultColors = Settings.Markings.HIGHLIGHTING_COLORS.getDefault();
        this.mPriorityCount = 0;
        while (this.mPriorityCount < currentColors.length) {
            Color defaultColor = new Color(currentDefaultColors[this.mPriorityCount < currentDefaultColors.length ? this.mPriorityCount : 0], true);
            this.mHighlightings.add(new HighlightPanel(this.mPriorityCount + 1, new Color(currentColors[this.mPriorityCount], true), defaultColor, false, this.mPriorityCount >= 5 ? delete : null));
            ++this.mPriorityCount;
        }
        JButton addColor = new JButton(LOCALIZER.msg("color.add", "Add color/priority"));
        addColor.addActionListener(e -> {
            HighlightPanel lastPanel = (HighlightPanel)this.mHighlightings.getComponent(this.mHighlightings.getComponentCount() - 1);
            lastPanel.setDeleteEnabled(false);
            this.mHighlightings.add(new HighlightPanel(this.mPriorityCount++ + 1, new Color(currentDefaultColors[0], true), new Color(currentDefaultColors[0], true), true, delete));
            this.mHighlightings.updateUI();
        });
        HighlightPanel lastPanel = (HighlightPanel)this.mHighlightings.getComponent(this.mHighlightings.getComponentCount() - 1);
        lastPanel.setDeleteEnabled(!lastPanel.isDefaultColor());
        pb.addSeparatorRowFull(false, LOCALIZER.msg("color.programMarked", "Highlighting by plugins"));
        pb.addRowFull(defaultMarkings.getPanel(), 2);
        pb.addParagraph(LOCALIZER.msg("color.default", "Default colors"));
        pb.addRowFull(this.mDefaultColors, 2);
        pb.addParagraph(LOCALIZER.msg("color.programMarkedAdditional", "Additional colors (replacing default color)"));
        pb.addRowFull(this.mHighlightings);
        pb.addRow("fill:10dlu:grow,default", (Component)addColor, 3);
        pb.addRowFull(this.mHelpLabel, 2);
        return pb.getPanel();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Highlighting");
    }

    @Override
    public void saveSettings() {
        Settings.Markings.USES_EXTRA_SPACE_FOR_MARK_ICONS.setBoolean(this.mProgramPanelUsesExtraSpaceForMarkIcons.isSelected());
        Settings.Markings.WITH_MARKINGS_SHOWING_BORDER.setBoolean(this.mProgramItemWithMarkingsIsShowingBorder.isSelected());
        Settings.Markings.MARK_PRIORITY_DEFAULT.setInt(this.mDefaultColors.getSelectedPriority(0));
        Settings.Markings.MARK_PRIORITY_FILTERS.setInt(this.mDefaultColors.getSelectedPriority(1));
        int[] colors = new int[this.mHighlightings.getComponentCount()];
        for (int i = 0; i < colors.length; ++i) {
            HighlightPanel panel = (HighlightPanel)this.mHighlightings.getComponent(i);
            colors[i] = panel.getColor().getRGB();
        }
        Settings.Markings.HIGHLIGHTING_COLORS.setIntArray(colors);
    }

    private static final class HighlightPanel
    extends JPanel {
        private ColorLabel mColorLabel;
        private Color mDefaultColor;
        private int mPriority;
        private JButton mDelete;

        private HighlightPanel(int priortiy, Color color, Color defaultColor, boolean deleteEnabled, ActionListener delete) {
            this.mPriority = priortiy;
            this.mColorLabel = new ColorLabel(color);
            this.mDefaultColor = defaultColor;
            this.mDelete = new JButton(TVBrowserIcons.delete(16));
            this.mDelete.setToolTipText(LOCALIZER.msg("color.deleteTooltip", "Delete color/priority"));
            this.mDelete.setEnabled(deleteEnabled);
            this.mDelete.setVisible(deleteEnabled);
            this.mDelete.addActionListener(delete);
            this.createGui();
        }

        private void createGui() {
            EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("5dlu,10dlu,1dlu,default,5dlu,default,5dlu,default,5dlu:grow,default"), (JPanel)this);
            pb.addLabelRow(this.mPriority + ".", 2).setHorizontalAlignment(4);
            pb.labelAdd(LOCALIZER.msg("color.colorPriority", "Color/priority"), 4);
            pb.add(this.mColorLabel, 6);
            this.mColorLabel.setStandardColor(this.mDefaultColor);
            pb.add(new ColorButton(this.mColorLabel), 8);
            pb.add(this.mDelete, 10);
        }

        private void setDeleteEnabled(boolean enabled) {
            this.mDelete.setEnabled(enabled);
            this.mDelete.setVisible(enabled);
        }

        private Color getColor() {
            return this.mColorLabel.getColor();
        }

        private boolean isDefaultColor() {
            return this.mPriority <= 5;
        }
    }
}

