/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.update;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import devplugin.InfoIf;
import devplugin.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.text.JTextComponent;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.update.PluginSoftwareUpdateItem;
import tvbrowser.ui.update.PluginsSoftwareUpdateItem;
import tvbrowser.ui.update.SoftwareUpdateItem;
import tvbrowser.ui.update.TvbrowserSoftwareUpdateItem;
import util.browserlauncher.Launch;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.LinkButton;
import util.ui.TVBrowserIcons;
import util.ui.TextAreaIcon;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.customizableitems.ItemFilter;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemList;
import util.ui.customizableitems.SelectableItemRendererCenterComponentIf;
import util.ui.html.HTMLTextHelper;
import util.ui.progress.ProgressWindow;

public class SoftwareUpdateDlg
extends JDialog
implements ActionListener,
ListSelectionListener,
WindowClosingIf {
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(SoftwareUpdateDlg.class);
    private JButton mCloseBtn;
    private JButton mDownloadBtn;
    private String mDownloadUrl;
    private JCheckBox mAutoUpdates;
    private SelectableItemList<SoftwareUpdateItem> mSoftwareUpdateItemList;
    private int mLastIndex;
    private JButton mHelpBtn;
    private boolean mIsVersionChange;
    private Version mOldTvbVersion;
    private int mDialogType;

    public SoftwareUpdateDlg(Window parent, String downloadUrl, int dialogType, SoftwareUpdateItem[] itemArr, boolean isVersionChange, Version oldTvbVersion) {
        this(parent, downloadUrl, dialogType, itemArr, isVersionChange, oldTvbVersion, null, false);
    }

    public SoftwareUpdateDlg(Window parent, String downloadUrl, int dialogType, SoftwareUpdateItem[] itemArr, boolean isVersionChange, Version oldTvbVersion, String search, boolean select) {
        super(parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.mDialogType = dialogType;
        this.mIsVersionChange = isVersionChange;
        this.mOldTvbVersion = oldTvbVersion;
        this.createGui(downloadUrl, dialogType, itemArr, parent, search);
        if (dialogType == 3 || dialogType == 1) {
            this.mSoftwareUpdateItemList.selectAll();
            this.mDownloadBtn.setEnabled(!this.mSoftwareUpdateItemList.getSelectionList().isEmpty());
        } else if (select) {
            this.mSoftwareUpdateItemList.selectFiltered();
            this.mDownloadBtn.setEnabled(!this.mSoftwareUpdateItemList.getSelectionList().isEmpty());
        }
    }

    public SoftwareUpdateDlg(Window parent, String downloadUrl, int dialogType, SoftwareUpdateItem[] itemArr) {
        this(parent, downloadUrl, dialogType, itemArr, false, null);
    }

    public SoftwareUpdateDlg(Window parent, int dialogType, SoftwareUpdateItem[] itemArr) {
        this(parent, null, dialogType, itemArr);
        this.mDownloadBtn.setEnabled(itemArr.length > 0);
    }

    public SoftwareUpdateDlg(Window parent, int dialogType, SoftwareUpdateItem[] itemArr, boolean isVersionChange, Version oldTvbVersion) {
        this(parent, null, dialogType, itemArr, isVersionChange, oldTvbVersion);
        this.mDownloadBtn.setEnabled(this.mSoftwareUpdateItemList.getItemCount() > 0);
    }

    private void createGui(String downloadUrl, int dialogType, SoftwareUpdateItem[] itemArr, Window parent, String search) {
        JComponent name;
        Arrays.sort(itemArr, new Comparator<SoftwareUpdateItem>(){

            @Override
            public int compare(SoftwareUpdateItem item1, SoftwareUpdateItem item2) {
                return item1.getName().compareToIgnoreCase(item2.getName());
            }
        });
        this.mDownloadUrl = downloadUrl;
        this.setTitle(LOCALIZER.msg("title", "Download plugins"));
        if (this.mIsVersionChange) {
            this.setDefaultCloseOperation(0);
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(0, 10));
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 11, 11));
        this.mCloseBtn = new JButton(Localizer.getLocalization("i18n_close"));
        this.mCloseBtn.addActionListener(this);
        this.mCloseBtn.setEnabled(!this.mIsVersionChange);
        this.mDownloadBtn = new JButton(LOCALIZER.msg("download", "Download selected items"));
        this.mDownloadBtn.addActionListener(this);
        this.mHelpBtn = new JButton(LOCALIZER.msg("openWebsite", "Open website"), TVBrowserIcons.webBrowser(16));
        this.mHelpBtn.addActionListener(this);
        this.mHelpBtn.setEnabled(false);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        if (dialogType == 1 && !this.mIsVersionChange) {
            this.mAutoUpdates = new JCheckBox(LOCALIZER.msg("autoUpdates", "Find plugin updates automatically"), Settings.Plugins.AUTO_UPDATE_ENABLED.getBoolean());
            this.mAutoUpdates.addItemListener(e -> Settings.Plugins.AUTO_UPDATE_ENABLED.setBoolean(e.getStateChange() == 1));
            builder.addFixed((JComponent)this.mAutoUpdates);
            builder.addRelatedGap();
        }
        builder.addFixed((JComponent)this.mHelpBtn);
        builder.addGlue();
        builder.addFixed((JComponent)this.mDownloadBtn);
        builder.addRelatedGap();
        builder.addFixed((JComponent)this.mCloseBtn);
        int y = 1;
        FormLayout layout = new FormLayout("default,5dlu,0dlu:grow", "default");
        JPanel northPn = new JPanel((LayoutManager)layout);
        JLabel info = new JLabel(LOCALIZER.msg("header", "Here you can download new plugins and updates for it."));
        if (dialogType == 1) {
            info.setText(LOCALIZER.msg("updateHeader", "Updates for installed plugins/new matching data plugins were found."));
        } else if (dialogType == 2) {
            info.setText(LOCALIZER.msg("dataServiceHeader", "TV-Browser is based on Plugins. You will need at least one of the listed data Plugins."));
            info.setFont(info.getFont().deriveFont(1).deriveFont(14.0f));
        }
        northPn.add((Component)info, CC.xyw((int)1, (int)y, (int)3));
        JPanel southPn = new JPanel(new BorderLayout());
        southPn.add((Component)builder.getPanel(), "South");
        ArrayList<SoftwareUpdateItem> selectedItems = new ArrayList<SoftwareUpdateItem>();
        ArrayList<SoftwareUpdateItem> notSelectableItems = new ArrayList<SoftwareUpdateItem>();
        ArrayList<String> selectedDataServices = new ArrayList<String>(0);
        if (dialogType == 2 || this.mIsVersionChange) {
            String country = Locale.getDefault().getCountry();
            if (country.equals(Locale.GERMANY.getCountry()) || country.equals("ES") || country.equals("IT") || country.equals("FR") || country.equals("DK") || country.equals("CH") || country.equals("AT") || Locale.getDefault().getLanguage().toLowerCase().startsWith("de")) {
                selectedDataServices.add("TvBrowserDataService");
                if (country.equals(Locale.GERMANY.getCountry()) || country.equals("CH") || country.equals("AT") || Locale.getDefault().getLanguage().toLowerCase().startsWith("de")) {
                    selectedDataServices.add("EPGdonateData");
                    selectedDataServices.add("EPGpaidData");
                }
            } else if (country.equals(Locale.CANADA.getCountry()) || country.equals(Locale.US.getCountry())) {
                selectedDataServices.add("SchedulesDirectDataService");
                selectedDataServices.add("TvBrowserDataService");
            } else if (country.equals(Locale.UK.getCountry())) {
                selectedDataServices.add("TvBrowserDataService");
            } else if (country.equals("NO")) {
                selectedDataServices.add("TvBrowserDataService");
                selectedDataServices.add("SweDBTvDataService");
            } else if (country.equals("SE") || country.equals("AU") || country.equals("HR")) {
                selectedDataServices.add("SweDBTvDataService");
            } else {
                selectedDataServices.add("TvBrowserDataService");
                selectedDataServices.add("SchedulesDirectDataService");
                selectedDataServices.add("RadioTimesDataService");
                selectedDataServices.add("SweDBTvDataService");
            }
            selectedDataServices.add("EPGplusDataService");
        }
        ArrayList<SoftwareUpdateItem> mItemList = new ArrayList<SoftwareUpdateItem>();
        for (SoftwareUpdateItem item : itemArr) {
            if (item instanceof TvbrowserSoftwareUpdateItem || !item.isPreSelected() && (!selectedDataServices.contains(item.getClassName()) || !this.mIsVersionChange && dialogType != 2)) continue;
            if (this.mIsVersionChange) {
                mItemList.add(item);
            }
            selectedItems.add(item);
            if (!this.mIsVersionChange || item.getEssentialTvbVersion() == null || this.mOldTvbVersion == null || this.mOldTvbVersion.compareTo(item.getEssentialTvbVersion()) >= 0) continue;
            notSelectableItems.add(item);
        }
        this.mDownloadBtn.setEnabled(!selectedItems.isEmpty());
        this.mSoftwareUpdateItemList = new SelectableItemList<SoftwareUpdateItem>(selectedItems.toArray(new SoftwareUpdateItem[selectedItems.size()]), this.mIsVersionChange ? mItemList.toArray(new SoftwareUpdateItem[mItemList.size()]) : itemArr, notSelectableItems.toArray(new SoftwareUpdateItem[notSelectableItems.size()]));
        this.mSoftwareUpdateItemList.addListSelectionListener(this);
        this.mSoftwareUpdateItemList.setSelectionMode(0);
        this.mSoftwareUpdateItemList.setListUI(new MyListUI());
        this.mSoftwareUpdateItemList.setHorizontalScrollBarPolicy(31);
        this.mSoftwareUpdateItemList.addCenterRendererComponent(PluginsSoftwareUpdateItem.class, new SelectableItemRendererCenterComponentIf<SoftwareUpdateItem>(){
            private final ImageIcon NEW_VERSION_ICON = IconLoader.getInstance().getIconFromTheme("status", "software-update-available", 16);

            @Override
            public JPanel createCenterPanel(JList<? extends SelectableItem<SoftwareUpdateItem>> list, SoftwareUpdateItem value, int index, boolean isSelected, boolean isEnabled, JScrollPane parentScrollPane, int leftColumnWidth) {
                Version installedVersion;
                FormLayout lay = new FormLayout("5dlu,default,5dlu,default:grow", "2dlu,default,2dlu,fill:pref:grow,2dlu");
                EnhancedPanelBuilder pb = new EnhancedPanelBuilder(lay);
                pb.getPanel().setOpaque(false);
                SoftwareUpdateItem item = value;
                JLabel label = pb.addLabel(HTMLTextHelper.convertHtmlToText(item.getName()) + " " + item.getVersion(), CC.xy((int)2, (int)2));
                label.setFont(label.getFont().deriveFont(1, label.getFont().getSize2D() + 2.0f));
                int width = parentScrollPane.getSize().width - parentScrollPane.getVerticalScrollBar().getWidth() - leftColumnWidth - Sizes.dialogUnitXAsPixel((int)5, (Component)pb.getPanel()) * 4 - parentScrollPane.getInsets().left - parentScrollPane.getInsets().right;
                if (width <= 0) {
                    width = Settings.ProgramTable.COLUMN_WIDTH.getInt();
                }
                TextAreaIcon icon = new TextAreaIcon(HTMLTextHelper.convertHtmlToText(item.getDescription()), UIManager.getFont("Label.font"), width, 2);
                JLabel iconLabel = new JLabel(""){

                    @Override
                    protected void paintComponent(Graphics g) {
                        Graphics2D g2 = (Graphics2D)g;
                        RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        g2.setRenderingHints(rh);
                        super.paintComponent(g);
                    }
                };
                iconLabel.setIcon(icon);
                pb.add(iconLabel, CC.xyw((int)2, (int)4, (int)3));
                JLabel label3 = new JLabel();
                if (item.isAlreadyInstalled() && (installedVersion = item.getInstalledVersion()) != null && installedVersion.compareTo(item.getVersion()) < 0) {
                    label.setIcon(this.NEW_VERSION_ICON);
                    label3.setText("(" + LOCALIZER.msg("installed", "Installed version: ") + installedVersion.toString() + ")");
                    label3.setFont(label3.getFont().deriveFont(label3.getFont().getSize2D() + 2.0f));
                    pb.add(label3, CC.xy((int)4, (int)2));
                }
                if (isSelected && isEnabled) {
                    label.setForeground(list.getSelectionForeground());
                    String author = item.getProperty("author");
                    String website = item.getWebsite();
                    FormLayout authorAndWebsiteLayout = new FormLayout("default,5dlu,default", "default");
                    JPanel authorAndWebsite = new JPanel((LayoutManager)authorAndWebsiteLayout);
                    authorAndWebsite.setOpaque(false);
                    if (author != null) {
                        lay.appendRow(RowSpec.decode((String)"2dlu"));
                        lay.appendRow(RowSpec.decode((String)"default"));
                        lay.appendRow(RowSpec.decode((String)"2dlu"));
                        pb.add(authorAndWebsite, CC.xyw((int)2, (int)7, (int)3));
                        JLabel authorLabel = new JLabel(LOCALIZER.msg("author", "Author"));
                        authorLabel.setFont(authorLabel.getFont().deriveFont(1));
                        authorLabel.setForeground(list.getSelectionForeground());
                        authorLabel.setHorizontalAlignment(4);
                        JLabel authorName = new JLabel(HTMLTextHelper.convertHtmlToText(author));
                        authorName.setForeground(list.getSelectionForeground());
                        authorAndWebsite.add((Component)authorLabel, CC.xy((int)1, (int)1));
                        authorAndWebsite.add((Component)authorName, CC.xy((int)3, (int)1));
                    }
                    if (website != null) {
                        if (author == null) {
                            lay.appendRow(RowSpec.decode((String)"2dlu"));
                            lay.appendRow(RowSpec.decode((String)"default"));
                            lay.appendRow(RowSpec.decode((String)"2dlu"));
                            pb.add(authorAndWebsite, CC.xyw((int)2, (int)7, (int)3));
                        } else {
                            authorAndWebsiteLayout.appendRow(RowSpec.decode((String)"1dlu"));
                            authorAndWebsiteLayout.appendRow(RowSpec.decode((String)"default"));
                        }
                        JLabel webLabel = new JLabel(LOCALIZER.msg("website", "Website"));
                        webLabel.setFont(webLabel.getFont().deriveFont(1));
                        webLabel.setForeground(list.getSelectionForeground());
                        webLabel.setHorizontalAlignment(4);
                        LinkButton webLink = new LinkButton(HTMLTextHelper.convertHtmlToText(website));
                        webLink.setForeground(list.getSelectionForeground());
                        authorAndWebsite.add((Component)webLabel, CC.xy((int)1, (int)(author == null ? 1 : 3)));
                        authorAndWebsite.add((Component)webLink, CC.xy((int)3, (int)(author == null ? 1 : 3)));
                    }
                    icon.setMaximumLineCount(-1);
                    iconLabel.setForeground(list.getSelectionForeground());
                    label3.setForeground(list.getSelectionForeground());
                } else {
                    if (!item.isStable()) {
                        label.setForeground(new Color(200, 0, 0));
                    } else {
                        label.setForeground(list.getForeground());
                    }
                    icon.setMaximumLineCount(1);
                    iconLabel.setForeground(list.getSelectionForeground());
                    iconLabel.setForeground(list.getForeground());
                    label3.setForeground(Color.gray);
                }
                return pb.getPanel();
            }

            @Override
            public void calculateSize(JList<? extends SelectableItem<SoftwareUpdateItem>> list, int index, JPanel contPane) {
                if (list.getUI() instanceof MyListUI) {
                    ((MyListUI)list.getUI()).setCellHeight(index, contPane.getPreferredSize().height);
                }
            }
        });
        this.mSoftwareUpdateItemList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.isPopupTrigger()) {
                    SoftwareUpdateDlg.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.isPopupTrigger()) {
                    SoftwareUpdateDlg.this.showPopupMenu(e);
                }
            }
        });
        if (dialogType != 1 && dialogType != 2) {
            layout.appendRow(RowSpec.decode((String)"5dlu"));
            layout.appendRow(RowSpec.decode((String)"default"));
            layout.appendRow(RowSpec.decode((String)"default"));
            JLabel filterLabel = new JLabel(LOCALIZER.msg("filterLabel", "Show only Plugins with the following category:"));
            JLabel nameFilterLabel = new JLabel(LOCALIZER.msg("nameFilterLabel", "Show only Plugins with the following text:"));
            northPn.add((Component)filterLabel, CC.xy((int)1, (int)(y += 2)));
            ArrayList<FilterItem> filterList = new ArrayList<FilterItem>(0);
            for (SoftwareUpdateItem item : itemArr) {
                int index = 0;
                for (int i = 0; i < filterList.size(); ++i) {
                    int compareValue = ((FilterItem)filterList.get(i)).compareTo(item.getCategory());
                    if (compareValue == 0) {
                        index = -1;
                        break;
                    }
                    if (compareValue >= 0) continue;
                    index = i + 1;
                }
                if (index == -1) continue;
                filterList.add(index, new FilterItem(item.getCategory()));
            }
            filterList.add(0, new FilterItem("all"));
            JComboBox<FilterItem> filterBox = new JComboBox<FilterItem>(filterList.toArray(new FilterItem[filterList.size()]));
            this.mSoftwareUpdateItemList.setFilterComboBox(filterBox);
            name = new JTextField();
            this.mSoftwareUpdateItemList.setNameFilter(new NameFilterItem((JTextField)name));
            northPn.add(filterBox, CC.xy((int)3, (int)y++));
            northPn.add((Component)nameFilterLabel, CC.xy((int)1, (int)y));
            northPn.add((Component)name, CC.xy((int)3, (int)y));
            if (search != null && !search.isBlank()) {
                ((JTextComponent)name).setText(search);
            }
        } else {
            name = null;
        }
        contentPane.add((Component)northPn, "North");
        contentPane.add(this.mSoftwareUpdateItemList, "Center");
        contentPane.add((Component)southPn, "South");
        Settings.layoutWindow("softwareUpdateDlg", this, new Dimension(700, 600), parent);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SoftwareUpdateDlg.this.close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SoftwareUpdateDlg.this.mSoftwareUpdateItemList.setVerticalScrollBarBlockIncrement(SoftwareUpdateDlg.this.mSoftwareUpdateItemList.getSize().height - 5);
            }
        });
        UiUtilities.registerForClosing(this);
        if (name != null) {
            name.requestFocusInWindow();
        }
    }

    public boolean isEmpty() {
        return this.mSoftwareUpdateItemList.isEmpty();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent event) {
        SoftwareUpdateItem item;
        if (event.getSource() == this.mCloseBtn) {
            this.close();
        } else if (event.getSource() == this.mDownloadBtn) {
            if (this.mDownloadBtn.isEnabled()) {
                this.mDownloadBtn.setEnabled(false);
                ProgressWindow p = new ProgressWindow(this, "");
                p.setMaximum(this.mSoftwareUpdateItemList.getSelectionList().size());
                p.run(() -> {
                    Cursor cursor = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    int successfullyDownloadedItems = 0;
                    try {
                        for (SoftwareUpdateItem item : this.mSoftwareUpdateItemList.getSelectionList()) {
                            try {
                                p.setMessage(item.getName());
                                item.download(this.mDownloadUrl);
                                p.incrementValue();
                                ++successfullyDownloadedItems;
                            }
                            catch (TvBrowserException e) {
                                ErrorHandler.handle(e);
                            }
                        }
                    }
                    finally {
                        this.mDownloadBtn.setEnabled(true);
                        this.setCursor(cursor);
                    }
                    if (successfullyDownloadedItems > 0 && !this.mIsVersionChange && this.mDialogType != 2) {
                        SwingUtilities.invokeLater(() -> {
                            if (TVBrowser.restartEnabled()) {
                                Object[] options = new String[]{"", ""};
                                options[0] = LOCALIZER.msg("restartnow", "restart");
                                options[1] = LOCALIZER.msg("restartlater", "later");
                                if (JOptionPane.showOptionDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("restartplugin", "plugins has been installed.\nrestart TV-Browser?"), LOCALIZER.msg("restartdialog", "restart"), 0, 3, null, options, options[0]) == 0) {
                                    TVBrowser.addRestart();
                                    MainFrame.getInstance().quit();
                                } else {
                                    Settings.setRestartInfo("SoftwareUpdateDlg.pluginInstallation", true);
                                }
                            } else {
                                JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("restartprogram", "please restart tvbrowser before..."));
                            }
                            this.closeInternal(true);
                        });
                    } else if (this.mIsVersionChange || this.mDialogType == 2) {
                        this.closeInternal(false);
                    }
                });
            }
        } else if (event.getSource() == this.mHelpBtn && (item = this.mSoftwareUpdateItemList.getSelectedValue().getItem()) != null) {
            Launch.openURL(item.getWebsite());
        }
    }

    private void closeInternal(boolean dispose) {
        if (dispose) {
            this.dispose();
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.mDownloadBtn.setEnabled(!this.mSoftwareUpdateItemList.getSelectionList().isEmpty());
        if (this.mIsVersionChange) {
            this.mCloseBtn.setEnabled(this.mSoftwareUpdateItemList.getSelectionList().isEmpty());
        }
        if (event.getSource() instanceof JList && !event.getValueIsAdjusting()) {
            JList list = (JList)event.getSource();
            if (this.mLastIndex != -1 && list.getSelectedIndex() != this.mLastIndex && list.getModel().getSize() - 1 >= this.mLastIndex) {
                ((MyListUI)list.getUI()).setCellHeight(this.mLastIndex, list.getCellRenderer().getListCellRendererComponent(list, list.getModel().getElementAt((int)this.mLastIndex), (int)this.mLastIndex, (boolean)false, (boolean)false).getPreferredSize().height);
            }
            this.mLastIndex = list.getSelectedIndex();
            if (this.mLastIndex < 0) {
                this.mHelpBtn.setEnabled(false);
            } else {
                SoftwareUpdateItem item = this.mSoftwareUpdateItemList.getSelectedValue().getItem();
                String website = item.getWebsite();
                this.mHelpBtn.setEnabled(website != null && website.length() > 0);
            }
        }
        this.mSoftwareUpdateItemList.calculateSize();
    }

    @Override
    public void close() {
        if (!this.mIsVersionChange || this.mSoftwareUpdateItemList.getSelectionList().isEmpty()) {
            this.closeInternal(true);
        }
    }

    private void showPopupMenu(MouseEvent e) {
        Object item;
        JList list;
        Object listItem;
        if (e.getSource() instanceof JList && (listItem = (list = (JList)e.getSource()).getModel().getElementAt(list.locationToIndex(e.getPoint()))) instanceof SelectableItem && (item = ((SelectableItem)listItem).getItem()) instanceof SoftwareUpdateItem && ((SoftwareUpdateItem)item).getWebsite() != null) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(LOCALIZER.msg("openWebsite", "Open website"), TVBrowserIcons.webBrowser(16));
            menuItem.addActionListener(evt -> Launch.openURL(((SoftwareUpdateItem)item).getWebsite()));
            menu.add(menuItem);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public static class FilterItem
    implements ItemFilter {
        private String mType;

        public FilterItem(String type) {
            this.mType = type;
        }

        public String toString() {
            return LOCALIZER.msg(this.mType, this.mType);
        }

        public boolean equals(Object o) {
            if (o != null) {
                if (o instanceof FilterItem) {
                    return this.mType.equals(((FilterItem)o).mType);
                }
                if (o instanceof String) {
                    return this.mType.equals(o);
                }
            }
            return false;
        }

        public int compareTo(Object o) {
            if (o != null) {
                if (o instanceof FilterItem) {
                    return this.toString().compareToIgnoreCase(((FilterItem)o).toString());
                }
                if (o instanceof String) {
                    return this.toString().compareToIgnoreCase(LOCALIZER.msg((String)o, (String)o));
                }
            }
            return 0;
        }

        @Override
        public boolean accept(Object o) {
            if (o instanceof SoftwareUpdateItem) {
                if (this.mType.equals("all")) {
                    return true;
                }
                return this.equals(((SoftwareUpdateItem)o).getCategory());
            }
            if (o instanceof InternalPluginProxyIf) {
                if (this.mType.equals("all")) {
                    return true;
                }
                return this.equals(((InternalPluginProxyIf)o).getPluginCategory());
            }
            if (o instanceof InfoIf) {
                if (this.mType.equals("all")) {
                    return true;
                }
                return this.equals(((InfoIf)o).getPluginCategory());
            }
            return false;
        }
    }

    public static class NameFilterItem
    implements ItemFilter {
        private JTextField mTextField;

        public NameFilterItem(JTextField textField) {
            this.mTextField = textField;
        }

        @Override
        public boolean accept(Object o) {
            boolean result = true;
            if (o instanceof PluginSoftwareUpdateItem) {
                result = this.mTextField.getText().isBlank() || ((PluginSoftwareUpdateItem)o).getName().toLowerCase().contains(this.mTextField.getText().toLowerCase()) || ((PluginSoftwareUpdateItem)o).getClassName().toLowerCase().contains(this.mTextField.getText().toLowerCase());
            }
            return result;
        }

        @Override
        public void setChangeListener(ChangeListener listener) {
            this.mTextField.addCaretListener(e -> listener.stateChanged(new ChangeEvent(this.mTextField)));
        }
    }

    private static class MyListUI
    extends BasicListUI {
        private MyListUI() {
        }

        protected synchronized void setCellHeight(int row, int height) {
            this.cellHeights[row] = height;
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            int width = super.getPreferredSize((JComponent)c).width;
            int height = 0;
            Insets i = c.getInsets();
            height += i.top + i.bottom;
            for (int localCellHeight : this.cellHeights) {
                height += localCellHeight;
            }
            return new Dimension(width, height);
        }
    }
}

