/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.update;

import devplugin.Version;
import java.util.HashMap;
import java.util.Locale;
import tvbrowser.core.plugin.ButtonActionIf;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import util.exc.TvBrowserException;
import util.misc.OperatingSystem;

public abstract class SoftwareUpdateItem {
    private static final String VERSION_KEY = "version";
    private static final String STABLE_KEY = "stable";
    private static final String VERSION_NAME_KEY = "version.name";
    private static final String ONLY_UPDATE_KEY = "onlyUpdate";
    private static final String OS_NAME_KEY = "os.name";
    private static final String REQUIRES_KEY = "requires";
    private static final String MAXIMAL_VERSION_KEY = "maximalVersion";
    private static final String ESSENTIAL_KEY = "essential";
    private static final String NAME_DE_KEY = "name_de";
    private static final String NAME_EN_KEY = "name_en";
    private static final String DESCRIPTION_DE_KEY = "description";
    private static final String DESCRIPTION_EN_KEY = "description_en";
    private static final String WEBSITE_DE_KEY = "website";
    private static final String WEBSITE_EN_KEY = "website_en";
    private static final String DOWNLOAD_TYPE_KEY = "downloadtype";
    private static final String DOWNLOAD_KEY = "download";
    private static final String FILE_NAME_KEY = "filename";
    private static final String KATEGORY_KEY = "category";
    private static final String ACCESS_KEY = "access";
    private static final String DOWNLOAD_TYPE_MIRROR_VALUE = "mirrors";
    private static final String KATEGORY_UNKNOWN_VALUE = "unknown";
    private static final char WINDOWS_OS_VALUE = 'w';
    private static final char OSX_OS_VALUE = 'm';
    private static final char LINUX_OS_VALUE = 'l';
    private static final char OTHER_OS_VALUE = 'o';
    private HashMap<String, String> mPropertyMap;
    private String mClassName;
    private boolean mPreSelected;

    public SoftwareUpdateItem(String className) {
        this.mClassName = className;
        this.mPropertyMap = new HashMap();
        this.mPreSelected = false;
    }

    public void addProperty(String key, String value) {
        this.mPropertyMap.put(key, value);
    }

    public String getProperty(String key) {
        return this.mPropertyMap.get(key);
    }

    public Version getVersion() {
        int minor;
        int major;
        String v = this.getProperty(VERSION_KEY);
        if (v == null) {
            return null;
        }
        String[] s = v.split("\\.");
        if (s.length < 2) {
            return null;
        }
        int subMinor = 0;
        try {
            major = Integer.parseInt(s[0]);
            minor = Integer.parseInt(s[1]);
            if (s.length == 3) {
                subMinor = Integer.parseInt(s[2]);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        boolean stable = "true".equalsIgnoreCase(this.getProperty(STABLE_KEY));
        return new Version(major, minor, subMinor, stable, this.getProperty(VERSION_NAME_KEY));
    }

    public boolean isStable() {
        return "true".equalsIgnoreCase(this.getProperty(STABLE_KEY));
    }

    public boolean isOnlyUpdate() {
        return "true".equalsIgnoreCase(this.getProperty(ONLY_UPDATE_KEY));
    }

    public boolean isSupportingCurrentOs() {
        String prop = this.getProperty(OS_NAME_KEY);
        if (prop == null) {
            return true;
        }
        if (prop.indexOf(119) != -1 && OperatingSystem.isWindows()) {
            return true;
        }
        if (prop.indexOf(109) != -1 && OperatingSystem.isMacOs()) {
            return true;
        }
        if (prop.indexOf(108) != -1 && OperatingSystem.isLinux()) {
            return true;
        }
        return prop.indexOf(111) != -1 && OperatingSystem.isOther();
    }

    private Version getVersion(String value) {
        int minor;
        int major;
        if (value == null) {
            return null;
        }
        String[] s = value.split("\\.");
        if (s.length < 2) {
            return null;
        }
        int subMinor = 0;
        try {
            major = Integer.parseInt(s[0]);
            minor = Integer.parseInt(s[1]);
            if (s.length == 3) {
                subMinor = Integer.parseInt(s[2]);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new Version(major, minor, subMinor);
    }

    public Version getRequiredVersion() {
        return this.getVersion(this.getProperty(REQUIRES_KEY));
    }

    public Version getMaximumVersion() {
        return this.getVersion(this.getProperty(MAXIMAL_VERSION_KEY));
    }

    public Version getEssentialTvbVersion() {
        return this.getVersion(this.getProperty(ESSENTIAL_KEY));
    }

    public void setPreSelected(boolean preSelected) {
        this.mPreSelected = preSelected;
    }

    public boolean isPreSelected() {
        return this.mPreSelected;
    }

    public String getName() {
        String n = this.getProperty(NAME_DE_KEY);
        if (!this.isLocaleGerman()) {
            n = this.getProperty(NAME_EN_KEY);
        }
        if (n != null) {
            return n;
        }
        return this.getClassName();
    }

    public String getDescription() {
        String d = this.getProperty(DESCRIPTION_DE_KEY);
        if (!this.isLocaleGerman()) {
            d = this.getProperty(DESCRIPTION_EN_KEY);
        }
        if (d != null) {
            return d;
        }
        return "";
    }

    public String getWebsite() {
        String w = this.getProperty(WEBSITE_DE_KEY);
        if (!this.isLocaleGerman()) {
            w = this.getProperty(WEBSITE_EN_KEY);
        }
        return w;
    }

    private boolean isLocaleGerman() {
        return Locale.getDefault().getLanguage().equals(Locale.GERMAN.getLanguage());
    }

    public String getClassName() {
        return this.mClassName;
    }

    public boolean download(String downloadUrl) throws TvBrowserException {
        String url;
        String string = url = this.getProperty(DOWNLOAD_TYPE_KEY) == null || !this.getProperty(DOWNLOAD_TYPE_KEY).equalsIgnoreCase(DOWNLOAD_TYPE_MIRROR_VALUE) ? this.getProperty(DOWNLOAD_KEY) : downloadUrl + "/" + this.getProperty(FILE_NAME_KEY);
        if (url == null) {
            throw new TvBrowserException(SoftwareUpdateItem.class, "error.2", "No Url");
        }
        return this.downloadFrom(url);
    }

    protected abstract boolean downloadFrom(String var1) throws TvBrowserException;

    public Version getInstalledVersion() {
        for (PluginProxy pluginProxy : PluginProxyManager.getInstance().getAllPlugins()) {
            if (!pluginProxy.getInfo().getName().equalsIgnoreCase(this.getName()) && !pluginProxy.getId().endsWith(this.getClassName())) continue;
            return pluginProxy.getInfo().getVersion();
        }
        for (ButtonActionIf buttonActionIf : TvDataServiceProxyManager.getInstance().getDataServices()) {
            if (!buttonActionIf.getInfo().getName().equalsIgnoreCase(this.getName()) && !buttonActionIf.getId().endsWith(this.getClassName())) continue;
            return buttonActionIf.getInfo().getVersion();
        }
        return null;
    }

    public boolean isAlreadyInstalled() {
        return this.getInstalledVersion() != null;
    }

    public String getCategory() {
        if (this.mPropertyMap.containsKey(KATEGORY_KEY)) {
            return this.mPropertyMap.get(KATEGORY_KEY);
        }
        return KATEGORY_UNKNOWN_VALUE;
    }

    public boolean isAccessControl() {
        if (this.mPropertyMap.containsKey(ACCESS_KEY)) {
            return this.mPropertyMap.get(ACCESS_KEY).toLowerCase().equals("true");
        }
        return false;
    }
}

