/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.UiUtilities;

class CheckNetworkConnection {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(CheckNetworkConnection.class);
    private boolean mResult = false;
    private JDialog mWaitingDialog;
    private AtomicInteger mRunningCount = new AtomicInteger();
    private static final String[] CHECK_URLS = new String[]{"https://duckduckgo.com/", "http://www.google.com/", "http://www.yahoo.com/", "http://www.bing.com/"};

    CheckNetworkConnection() {
    }

    public boolean checkConnection() {
        if (!Settings.Network.INTERNET_CONNECTION_CHECK.getBoolean()) {
            return true;
        }
        this.mResult = false;
        this.mRunningCount.set(0);
        for (String url : CHECK_URLS) {
            try {
                if (!this.checkConnectionInternal(new URL(url))) continue;
                this.hideDialog();
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.hideDialog();
        return this.mResult;
    }

    public boolean checkConnection(URL url) {
        return this.checkConnection(url, Settings.Network.CHECK_TIMEOUT.getInt() / 100, true);
    }

    public boolean checkConnection(URL url, int timeout, boolean showWaitingDialog) {
        this.mResult = false;
        this.mRunningCount.set(0);
        boolean check = this.checkConnectionInternal(url, timeout, showWaitingDialog);
        this.hideDialog();
        return check;
    }

    private boolean checkConnectionInternal(URL url) {
        return this.checkConnectionInternal(url, Settings.Network.CHECK_TIMEOUT.getInt() / 100, true);
    }

    private boolean checkConnectionInternal(URL url, int timeout, boolean showWaitingDialog) {
        this.mRunningCount.incrementAndGet();
        new Thread(() -> {
            if (!this.mResult && url != null) {
                try {
                    HttpURLConnection connection2;
                    HttpsURLConnection connection1;
                    URLConnection test = url.openConnection();
                    this.mResult = test instanceof HttpsURLConnection ? (connection1 = (HttpsURLConnection)test).getResponseCode() == 200 || connection1.getResponseCode() == 303 || connection1.getResponseCode() == 202 || connection1.getResponseCode() == 201 || this.mResult : (connection2 = (HttpURLConnection)test).getResponseCode() == 200 || connection2.getResponseCode() == 303 || connection2.getResponseCode() == 202 || connection2.getResponseCode() == 201 || this.mResult;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.mRunningCount.decrementAndGet();
        }, "Check network connection").start();
        int num = 0;
        while (this.mRunningCount.get() > 0 && num < timeout) {
            if (++num == 7) {
                SwingUtilities.invokeLater(() -> {
                    if (!this.mResult && showWaitingDialog) {
                        this.showDialog();
                    }
                });
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.mResult;
    }

    private void hideDialog() {
        if (this.mWaitingDialog != null) {
            if (MainFrame.getInstance().isVisible() && UiUtilities.getLastModalChildOf(MainFrame.getInstance()).equals(this.mWaitingDialog)) {
                this.mWaitingDialog.dispose();
            } else {
                new Thread("Hide network connection dialog"){

                    @Override
                    public void run() {
                        this.setPriority(1);
                        while (!MainFrame.getInstance().isVisible() && !UiUtilities.getLastModalChildOf(MainFrame.getInstance()).equals(CheckNetworkConnection.this.mWaitingDialog)) {
                            try {
                                1.sleep(500L);
                            }
                            catch (Exception exception) {}
                        }
                        CheckNetworkConnection.this.mWaitingDialog.dispose();
                    }
                }.start();
            }
        }
    }

    private void showDialog() {
        try {
            if (MainFrame.isStarting()) {
                return;
            }
            if (!MainFrame.getInstance().isVisible() || MainFrame.getInstance().getExtendedState() == 1) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mRunningCount.get() > 0 && this.mWaitingDialog == null && !this.mResult) {
            this.mWaitingDialog = UiUtilities.createDialog(MainFrame.getInstance(), true);
            this.mWaitingDialog.setUndecorated(true);
            this.mWaitingDialog.setCursor(new Cursor(3));
            JPanel panel = (JPanel)this.mWaitingDialog.getContentPane();
            panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            panel.setLayout((LayoutManager)new FormLayout("3dlu, pref, 3dlu", "3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu"));
            CellConstraints cc = new CellConstraints();
            JLabel header = new JLabel(mLocalizer.msg("header", "Header"));
            header.setFont(header.getFont().deriveFont(1));
            panel.add((Component)header, cc.xy(2, 2));
            panel.add((Component)new JLabel(mLocalizer.msg("pleaseWait", "Checking the internet connection... This may take up to {0} seconds.", Settings.Network.CHECK_TIMEOUT.getInt() / 1000)), cc.xy(2, 4));
            this.mWaitingDialog.pack();
            if (this.mRunningCount.get() > 0 && !this.mResult) {
                UiUtilities.centerAndShow(this.mWaitingDialog);
            }
            this.mWaitingDialog.setVisible(!this.mResult && this.mRunningCount.get() > 0 && MainFrame.getInstance().isVisible() && MainFrame.getInstance().getExtendedState() != 1);
        }
    }

    public static String[] getUrls() {
        return CHECK_URLS;
    }
}

