/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import util.settings.Property;
import util.settings.PropertyManager;

public class IntProperty
extends Property {
    private int mDefaultValue;
    protected boolean mIsCacheFilled;
    private int mCachedValue;

    public IntProperty(PropertyManager manager, String key, int defaultValue) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mIsCacheFilled = false;
    }

    public int getDefault() {
        return this.mDefaultValue;
    }

    public int getInt() {
        if (!this.mIsCacheFilled) {
            String asString = this.getProperty();
            if (asString == null) {
                this.mCachedValue = this.getDefault();
            } else {
                try {
                    this.mCachedValue = Integer.parseInt(asString);
                }
                catch (Exception exc) {
                    this.mCachedValue = this.getDefault();
                }
            }
            this.mIsCacheFilled = true;
        }
        return this.mCachedValue;
    }

    public void setInt(int value) {
        if (value == this.mDefaultValue) {
            this.setProperty(null);
        } else {
            this.setProperty(Integer.toString(value));
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mIsCacheFilled = false;
    }
}

