/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang3.StringUtils;

public class AutoCompletion<E>
extends PlainDocument {
    private JComboBox<E> comboBox;
    private ComboBoxModel<E> model;
    private JTextComponent editor;
    private boolean selecting = false;
    private boolean hidePopupOnFocusLoss;
    private boolean hitBackspace = false;
    private boolean hitBackspaceOnSelection;
    private boolean firstUpper = false;
    private transient KeyListener editorKeyListener;
    private transient FocusListener editorFocusListener;

    public AutoCompletion(JComboBox<E> comboBox) {
        this(comboBox, false);
    }

    public AutoCompletion(final JComboBox<E> comboBox, boolean firstLetterUppercase) {
        this.comboBox = comboBox;
        this.firstUpper = firstLetterUppercase;
        this.model = comboBox.getModel();
        comboBox.addActionListener(e -> {
            if (!this.selecting) {
                this.highlightCompletedText(0);
            }
        });
        comboBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("editor")) {
                    AutoCompletion.this.configureEditor((ComboBoxEditor)e.getNewValue());
                }
                if (e.getPropertyName().equals("model")) {
                    AutoCompletion.this.model = (ComboBoxModel)e.getNewValue();
                }
            }
        });
        this.editorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (comboBox.isDisplayable()) {
                    comboBox.setPopupVisible(true);
                }
                AutoCompletion.this.hitBackspace = false;
                switch (e.getKeyCode()) {
                    case 8: {
                        AutoCompletion.this.hitBackspace = true;
                        AutoCompletion.this.hitBackspaceOnSelection = AutoCompletion.this.editor.getSelectionStart() != AutoCompletion.this.editor.getSelectionEnd();
                        break;
                    }
                    case 127: {
                        e.consume();
                        comboBox.getToolkit().beep();
                    }
                }
            }
        };
        this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.editorFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AutoCompletion.this.highlightCompletedText(0);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (AutoCompletion.this.hidePopupOnFocusLoss) {
                    comboBox.setPopupVisible(false);
                }
            }
        };
        this.configureEditor(comboBox.getEditor());
        Object selected = comboBox.getSelectedItem();
        if (selected != null) {
            this.setText(selected.toString());
        }
        this.highlightCompletedText(0);
    }

    void configureEditor(ComboBoxEditor newEditor) {
        if (this.editor != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
            this.editor.removeFocusListener(this.editorFocusListener);
        }
        if (newEditor != null) {
            this.editor = (JTextComponent)newEditor.getEditorComponent();
            this.editor.addKeyListener(this.editorKeyListener);
            this.editor.addFocusListener(this.editorFocusListener);
            this.editor.setDocument(this);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        if (this.hitBackspace) {
            if (offs > 0) {
                if (this.hitBackspaceOnSelection) {
                    --offs;
                }
            } else {
                this.comboBox.getToolkit().beep();
            }
            this.highlightCompletedText(offs);
        } else {
            super.remove(offs, len);
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        if (offs == 0 && this.firstUpper) {
            str = StringUtils.capitalize((String)str);
        }
        super.insertString(offs, str, a);
        Object item = this.lookupItem(this.getText(0, this.getLength()));
        boolean listContainsSelectedItem = true;
        if (item == null) {
            item = this.getText(0, this.getLength());
            listContainsSelectedItem = false;
        }
        this.setText(item.toString());
        if (listContainsSelectedItem) {
            this.highlightCompletedText(offs + str.length());
        }
    }

    private void setText(String text) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    private void highlightCompletedText(int start) {
        this.editor.setCaretPosition(this.getLength());
        this.editor.moveCaretPosition(start);
    }

    private Object lookupItem(String pattern) {
        Object selectedItem = this.model.getSelectedItem();
        if (selectedItem != null && this.startsWithIgnoreCase(selectedItem.toString(), pattern)) {
            return selectedItem;
        }
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            Object currentItem = this.model.getElementAt(i);
            if (currentItem == null || !this.startsWithIgnoreCase(currentItem.toString(), pattern)) continue;
            return currentItem;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String str1, String str2) {
        return str1.toUpperCase().startsWith(str2.toUpperCase());
    }
}

