/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import util.exc.ErrorHandler;
import util.i18n.Localizer;
import util.io.IOUtilities;
import util.ui.UiUtilities;

public class HelpDialog
implements ActionListener,
HyperlinkListener {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(HelpDialog.class);
    public static final Dimension MIN_HELP_DIALOG_SIZE = new Dimension(350, 400);
    public static final Dimension MAX_HELP_DIALOG_SIZE = new Dimension(500, 10000);
    private static HelpDialog mHelpDialogSingleton;
    private JDialog mDialog;
    private Stack<HistoryStackElement> mHistoryStack;
    private String mSourcePath;
    private Class<?> mSourceClass;
    private JEditorPane mEditorPane;
    private JScrollPane mScrollPane;
    private JButton mBackButton;
    private JButton mCloseButton;

    private HelpDialog(Component parent, String filename) {
        this.mDialog = UiUtilities.createDialog(UiUtilities.getBestDialogParent(parent), false);
        this.initUi();
    }

    public static void showHelpPage(Component parent, String filename, Class<?> clazz) {
        if (mHelpDialogSingleton == null || !HelpDialog.mHelpDialogSingleton.mDialog.isShowing()) {
            mHelpDialogSingleton = new HelpDialog(parent, filename);
        } else {
            mHelpDialogSingleton.addThisSiteToHistory();
        }
        mHelpDialogSingleton.openSite(filename, clazz);
        mHelpDialogSingleton.show();
    }

    private void initUi() {
        this.mHistoryStack = new Stack();
        this.mDialog.setTitle(Localizer.getLocalization("i18n_help"));
        JPanel main = new JPanel(new BorderLayout());
        this.mDialog.setContentPane(main);
        main.setBorder(UiUtilities.DIALOG_BORDER);
        this.mEditorPane = new JEditorPane();
        this.mEditorPane.setContentType("text/html");
        this.mEditorPane.addHyperlinkListener(this);
        this.mEditorPane.setEditable(false);
        this.mScrollPane = new JScrollPane(this.mEditorPane);
        main.add(this.mScrollPane);
        JPanel buttonPn = new JPanel(new FlowLayout(4));
        main.add((Component)buttonPn, "South");
        this.mBackButton = new JButton(Localizer.getLocalization("i18n_back"));
        buttonPn.add(this.mBackButton);
        this.mBackButton.addActionListener(this);
        this.mBackButton.setEnabled(false);
        this.mCloseButton = new JButton(Localizer.getLocalization("i18n_close"));
        buttonPn.add(this.mCloseButton);
        this.mCloseButton.addActionListener(this);
        this.mDialog.getRootPane().setDefaultButton(this.mCloseButton);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Window vaterWindow = this.mDialog.getOwner();
        Point vaterLocation = vaterWindow.getLocation();
        Dimension vaterSize = vaterWindow.getSize();
        Point hilfeLocation = new Point(vaterLocation.x + vaterSize.width, vaterLocation.y);
        Dimension hilfeSize = new Dimension(screenSize.width - hilfeLocation.x, vaterSize.height);
        if (hilfeSize.width < HelpDialog.MIN_HELP_DIALOG_SIZE.width) {
            hilfeSize.width = HelpDialog.MIN_HELP_DIALOG_SIZE.width;
            hilfeLocation.x = screenSize.width - hilfeSize.width;
            vaterLocation.x = screenSize.width - HelpDialog.MIN_HELP_DIALOG_SIZE.width - vaterSize.width;
            if (vaterLocation.x < 10) {
                vaterLocation.x = 10;
            }
            vaterWindow.setLocation(vaterLocation);
        }
        if (hilfeSize.width > HelpDialog.MAX_HELP_DIALOG_SIZE.width) {
            hilfeSize.width = HelpDialog.MAX_HELP_DIALOG_SIZE.width;
        }
        if (hilfeSize.height < HelpDialog.MIN_HELP_DIALOG_SIZE.height) {
            hilfeSize.height = HelpDialog.MIN_HELP_DIALOG_SIZE.height;
            hilfeLocation.y = (screenSize.height - hilfeSize.height) / 2;
        }
        if (hilfeSize.height > HelpDialog.MAX_HELP_DIALOG_SIZE.height) {
            hilfeSize.height = HelpDialog.MAX_HELP_DIALOG_SIZE.height;
        }
        this.mDialog.setSize(hilfeSize);
        this.mDialog.setLocation(hilfeLocation);
    }

    public void show() {
        this.mDialog.setVisible(true);
    }

    protected void setEditorText(String text, double updateScrollBarTo) {
        this.mEditorPane.setText(text);
        SwingUtilities.invokeLater(new ScrollBarUpdater(updateScrollBarTo));
    }

    protected void addThisSiteToHistory() {
        HistoryStackElement newSite = new HistoryStackElement();
        newSite.mText = this.mEditorPane.getText();
        newSite.mSourcePath = this.mSourcePath;
        newSite.mSourceClass = this.mSourceClass;
        JScrollBar scrollBar = this.mScrollPane.getVerticalScrollBar();
        newSite.mVerticalScrollBarRelValue = (double)scrollBar.getValue() / (double)scrollBar.getMaximum();
        this.mHistoryStack.push(newSite);
        this.mBackButton.setEnabled(true);
    }

    protected void popFromHistory() {
        HistoryStackElement lastSite = this.mHistoryStack.pop();
        double updateScrollBarTo = lastSite.mVerticalScrollBarRelValue;
        this.setEditorText(lastSite.mText, updateScrollBarTo);
        this.mSourcePath = lastSite.mSourcePath;
        this.mSourceClass = lastSite.mSourceClass;
        this.mScrollPane.validate();
        if (this.mHistoryStack.empty()) {
            this.mBackButton.setEnabled(false);
        }
    }

    protected void openSite(String filename, Class<?> clazz) {
        String text;
        try {
            text = new String(IOUtilities.loadFileFromJar(filename, clazz));
        }
        catch (IOException exc) {
            String msg = LOCALIZER.msg("error.1", "Can't open site \"{0}\"!", filename);
            ErrorHandler.handle(msg, exc);
            text = "";
        }
        this.setEditorText(text, 0.0);
        this.mSourcePath = HelpDialog.extractPath(filename);
        this.mSourceClass = clazz;
    }

    protected static String extractPath(String dateiname) {
        int lastSlashPos = Math.max(dateiname.lastIndexOf(47), dateiname.lastIndexOf(92));
        if (lastSlashPos == -1) {
            return null;
        }
        return dateiname.substring(0, lastSlashPos);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.mBackButton) {
            this.popFromHistory();
        } else if (evt.getSource() == this.mCloseButton) {
            this.mDialog.dispose();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (evt instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent frameEvt = (HTMLFrameHyperlinkEvent)evt;
                HTMLDocument doc = (HTMLDocument)this.mEditorPane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(frameEvt);
            } else {
                this.addThisSiteToHistory();
                Object filename = evt.getDescription();
                int anchorPos = ((String)filename).indexOf(35);
                if (anchorPos != -1) {
                    filename = ((String)filename).substring(0, anchorPos);
                }
                if (this.mSourcePath != null) {
                    filename = this.mSourcePath + "/" + (String)filename;
                }
                this.mSourcePath = HelpDialog.extractPath((String)filename);
                this.openSite((String)filename, this.mSourceClass);
            }
        }
    }

    protected static class HistoryStackElement {
        public String mSourcePath;
        public Class<?> mSourceClass;
        public String mText;
        public double mVerticalScrollBarRelValue;

        protected HistoryStackElement() {
        }
    }

    protected class ScrollBarUpdater
    implements Runnable {
        private double mUpdateScrollBarTo;

        public ScrollBarUpdater(double updateScrollBarTo) {
            this.mUpdateScrollBarTo = updateScrollBarTo;
        }

        @Override
        public void run() {
            JScrollBar bar = HelpDialog.this.mScrollPane.getVerticalScrollBar();
            bar.setValue((int)(this.mUpdateScrollBarTo * (double)bar.getMaximum()));
        }
    }
}

