/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import tvbrowser.ui.settings.SettingsDialog;
import util.i18n.Localizer;
import util.settings.PluginPictureSettings;
import util.ui.UiUtilities;

public class PluginsPictureSettingsPanel
extends JPanel {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(PluginsPictureSettingsPanel.class);
    private JRadioButton mGlobalSettings;
    private JRadioButton mPictureAndDescription;
    private JRadioButton mOnlyPictures;
    private JRadioButton mNoPictures;
    private ArrayList<ChangeListener> mChangeListenerList = new ArrayList();

    public PluginsPictureSettingsPanel(PluginPictureSettings settings, boolean showDisableButtonDontShowAllButton) {
        this.setLayout((LayoutManager)new FormLayout("14dlu,default:grow", "default," + (!showDisableButtonDontShowAllButton ? "2dlu,default,5dlu," : "") + "2dlu,default,2dlu,default"));
        ItemListener itemListener = e -> {
            if (e.getStateChange() == 1) {
                this.fireChangeEvent();
            }
        };
        this.mGlobalSettings = new JRadioButton(LOCALIZER.msg("globalSettings", "Use default settings for plugins"), settings.getType() == 0);
        this.mPictureAndDescription = new JRadioButton(LOCALIZER.msg("pictureAndDesc", "Show picture and picture description (if available)"), settings.getType() == 1);
        this.mOnlyPictures = new JRadioButton(LOCALIZER.msg("onlyPictures", "Show only pictures (if available)"), settings.getType() == 2);
        this.mGlobalSettings.addItemListener(itemListener);
        this.mPictureAndDescription.addItemListener(itemListener);
        this.mOnlyPictures.addItemListener(itemListener);
        ButtonGroup bg = new ButtonGroup();
        int y = 1;
        if (!showDisableButtonDontShowAllButton) {
            bg.add(this.mGlobalSettings);
            int n = y;
            y = (short)(y + 1);
            this.add((Component)this.mGlobalSettings, CC.xyw((int)1, (int)n, (int)2));
            JEditorPane helpLabel = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("help", "The default plugin setting can be changed in the <a href=\"#link\">picture settings</a>."), e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SettingsDialog.getInstance().showSettingsTab("#pictures");
                }
            });
            y = (short)(y + 1);
            this.add((Component)helpLabel, CC.xy((int)2, (int)y));
            y = (short)(y + 3);
        }
        bg.add(this.mPictureAndDescription);
        bg.add(this.mOnlyPictures);
        this.add((Component)this.mPictureAndDescription, CC.xyw((int)1, (int)y, (int)2));
        int n = y = (int)((short)(y + 2));
        y = (short)(y + 1);
        this.add((Component)this.mOnlyPictures, CC.xyw((int)1, (int)n, (int)2));
        if (showDisableButtonDontShowAllButton) {
            this.mNoPictures = new JRadioButton(LOCALIZER.msg("noPictures", "Don't show pictures and description"), settings.getType() == 3);
            this.mNoPictures.addItemListener(itemListener);
            bg.add(this.mNoPictures);
            y = (short)(y + 1);
            this.add((Component)this.mNoPictures, CC.xyw((int)1, (int)y, (int)2));
        }
    }

    public PluginPictureSettings getSettings() {
        int type = 0;
        if (this.mPictureAndDescription.isSelected()) {
            type = 1;
        } else if (this.mOnlyPictures.isSelected()) {
            type = 2;
        } else if (this.mNoPictures != null && this.mNoPictures.isSelected()) {
            type = 3;
        }
        return new PluginPictureSettings(type);
    }

    public static String getTitle() {
        return LOCALIZER.msg("title", "Picture setting of the program list");
    }

    public void addChangeListener(ChangeListener listener) {
        if (!this.mChangeListenerList.contains(listener)) {
            this.mChangeListenerList.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.mChangeListenerList.remove(listener);
    }

    private void fireChangeEvent() {
        if (!this.mChangeListenerList.isEmpty()) {
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener listener : this.mChangeListenerList) {
                listener.stateChanged(e);
            }
        }
    }
}

