/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.layout.FormLayout;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.PluginChooserDlg;
import util.ui.UiUtilities;

public class ProgramReceiveTargetSelectionPanel
extends JPanel {
    private static final Comparator<ProgramReceiveIf> COMPARTOR = new Comparator<ProgramReceiveIf>(){

        @Override
        public int compare(ProgramReceiveIf p1, ProgramReceiveIf p2) {
            return p1.toString().compareToIgnoreCase(p2.toString());
        }
    };
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ProgramReceiveTargetSelectionPanel.class);
    private JLabel mReceiveTargetLabel;
    private ProgramReceiveTarget[] mReceiveTargets;
    private ChangeListener[] mChangeListenerArray = new ChangeListener[0];
    private long mLastPluginSelectionHandling = 0L;

    public ProgramReceiveTargetSelectionPanel(Window parent, ProgramReceiveTarget[] receiveTargetArr, String description, ProgramReceiveIf caller, boolean withTitle, String title) {
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("5dlu,150dlu:grow,5dlu,default,5dlu"), (JPanel)this);
        this.mReceiveTargets = receiveTargetArr;
        this.mReceiveTargetLabel = new JLabel();
        this.mReceiveTargetLabel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                ProgramReceiveTargetSelectionPanel.this.handlePluginSelection();
            }
        });
        JButton selectionButton = new JButton(LOCALIZER.msg("selectionButton", "Select targets"));
        selectionButton.addActionListener(e -> {
            try {
                Window w = UiUtilities.getLastModalChildOf(parent);
                PluginChooserDlg chooser = null;
                chooser = new PluginChooserDlg(w, this.mReceiveTargets, description, caller);
                chooser.setVisible(true);
                if (chooser.getReceiveTargets() != null) {
                    this.mReceiveTargets = chooser.getReceiveTargets();
                    for (ChangeListener listener : this.mChangeListenerArray) {
                        listener.stateChanged(new ChangeEvent(this));
                    }
                }
                this.handlePluginSelection();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        });
        if (withTitle) {
            pb.addSeparatorRowFull(false, title == null ? LOCALIZER.msg("defaultTitle", "Send programs to:") : title);
            pb.addLineGap();
        }
        pb.addRow(false, (Component)this.mReceiveTargetLabel, 2);
        pb.add(selectionButton, 4);
        this.handlePluginSelection();
    }

    private void handlePluginSelection() {
        if (System.currentTimeMillis() - this.mLastPluginSelectionHandling > 10L) {
            ArrayList<ProgramReceiveIf> plugins = new ArrayList<ProgramReceiveIf>();
            if (this.mReceiveTargets != null) {
                for (ProgramReceiveTarget target : this.mReceiveTargets) {
                    if (plugins.contains(target.getReceifeIfForIdOfTarget()) || target.getReceifeIfForIdOfTarget() == null) continue;
                    plugins.add(target.getReceifeIfForIdOfTarget());
                }
                ProgramReceiveIf[] mClientPlugins = plugins.toArray(new ProgramReceiveIf[0]);
                Arrays.parallelSort(mClientPlugins, COMPARTOR);
                if (mClientPlugins.length > 0) {
                    this.mReceiveTargetLabel.setText(mClientPlugins[0].toString());
                    if (mClientPlugins.length > 1) {
                        int i = 1;
                        String others = LOCALIZER.ellipsisMsg("otherTargets", "others");
                        int otherLength = this.mReceiveTargetLabel.getFontMetrics(this.mReceiveTargetLabel.getFont()).stringWidth(others) + 30;
                        do {
                            String text = this.mReceiveTargetLabel.getText() + ", " + mClientPlugins[i];
                            int addLength = otherLength;
                            if (i == mClientPlugins.length - 1) {
                                addLength = 0;
                            }
                            if (this.mReceiveTargetLabel.getFontMetrics(this.mReceiveTargetLabel.getFont()).stringWidth(text) + addLength >= this.mReceiveTargetLabel.getWidth()) break;
                            this.mReceiveTargetLabel.setText(text);
                        } while (i++ < mClientPlugins.length - 1);
                        if (i < mClientPlugins.length) {
                            this.mReceiveTargetLabel.setText(this.mReceiveTargetLabel.getText() + " (" + (mClientPlugins.length - i) + " " + others + ")");
                        }
                    }
                } else {
                    this.mReceiveTargetLabel.setText(LOCALIZER.msg("noTargets", "No targets choosen"));
                }
            } else {
                this.mReceiveTargetLabel.setText(LOCALIZER.msg("noTargets", "No targets choosen"));
            }
            this.mLastPluginSelectionHandling = System.currentTimeMillis();
        }
    }

    public ProgramReceiveTarget[] getCurrentSelection() {
        return this.mReceiveTargets;
    }

    public void addChangeListener(ChangeListener listener) {
        ChangeListener[] newArray = new ChangeListener[this.mChangeListenerArray.length + 1];
        System.arraycopy(this.mChangeListenerArray, 0, newArray, 0, this.mChangeListenerArray.length);
        newArray[this.mChangeListenerArray.length] = listener;
        this.mChangeListenerArray = newArray;
    }
}

