/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import devplugin.Date;
import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginManagerImpl;
import util.i18n.Localizer;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.ProgramPanel;

public class ProgramTableCellRenderer
extends DefaultTableCellRenderer {
    private JPanel mMainPanel = new JPanel(new BorderLayout());
    private JLabel mHeaderLb;
    private ProgramPanel mProgramPanel;

    public ProgramTableCellRenderer() {
        this(new ProgramPanelSettings(0, -1, -1, false, true, 10));
    }

    public ProgramTableCellRenderer(PluginPictureSettings settings) {
        this(new ProgramPanelSettings(new PluginPictureSettings(0), false));
    }

    public ProgramTableCellRenderer(ProgramPanelSettings settings) {
        this.mMainPanel.setOpaque(false);
        this.mHeaderLb = new JLabel();
        this.mMainPanel.add((Component)this.mHeaderLb, "North");
        this.mProgramPanel = new ProgramPanel(settings);
        this.mMainPanel.add((Component)this.mProgramPanel, "Center");
        Settings.addFontChangeListener(e -> this.mProgramPanel.forceRepaint());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof Program) {
            Program program = (Program)value;
            this.mProgramPanel.setProgram(program);
            this.mProgramPanel.setSelectedInList(isSelected);
            program.addChangeListener(e -> table.repaint());
            this.mProgramPanel.setPaintExpiredProgramsPale(!isSelected);
            if (!Settings.ProgramTable.STYLE_BACKGROUND.getString().equals("uiColor") && !Settings.ProgramTable.STYLE_BACKGROUND.getString().equals("uiTimeBlock")) {
                this.mProgramPanel.setTextColor(Settings.ProgramPanel.COLOR_FOREGROUND.getColor());
            } else {
                this.mProgramPanel.setTextColor(UIManager.getColor("List.foreground"));
            }
            this.mProgramPanel.setBackground(label.getBackground());
            String dateString = program.getDate().equals(Date.getCurrentDate().addDays(-1)) ? Localizer.getLocalization("i18n_yesterday") : (program.getDate().equals(Date.getCurrentDate()) ? Localizer.getLocalization("i18n_today") : (program.getDate().equals(Date.getCurrentDate().addDays(1)) ? Localizer.getLocalization("i18n_tomorrow") : program.getDate().toString()));
            this.mHeaderLb.setText(dateString + " - " + program.getChannel().getName());
            if (program.isExpired() && !isSelected) {
                this.mHeaderLb.setForeground(Color.gray);
            } else {
                this.mHeaderLb.setForeground(this.mProgramPanel.getTextColor());
            }
            if (isSelected) {
                this.mHeaderLb.setOpaque(true);
                this.mHeaderLb.setBackground(Settings.ProgramPanel.COLOR_KEYBOARD_SELECTED.getColor());
            } else {
                this.mHeaderLb.setOpaque(false);
            }
            this.mMainPanel.setEnabled(label.isEnabled());
            if (table.getRowHeight(row) != this.mMainPanel.getPreferredSize().height && !PluginManagerImpl.getInstance().getExampleProgram().equals((Program)value)) {
                table.setRowHeight(row, this.mMainPanel.getPreferredSize().height);
            }
            return this.mMainPanel;
        }
        return label;
    }
}

