/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import devplugin.Channel;
import devplugin.Plugin;
import devplugin.ProgramFieldType;
import devplugin.ProgramSearcher;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import util.exc.TvBrowserException;
import util.ui.SearchForm;

public class SearchFormSettings {
    public static final int SEARCH_IN_TITLE = 1;
    public static final int SEARCH_IN_ALL = 2;
    public static final int SEARCH_IN_USER_DEFINED = 3;
    private String mSearchText;
    private int mSearchIn;
    private ProgramFieldType[] mUserDefinedFieldTypes;
    private ProgramFieldType[] mUserDefaultFieldTypes;
    private int mSearcherType;
    private boolean mCaseSensitive;
    private int mNrDays;
    private Channel[] mChannels = null;
    private ProgramSearcher mSearcher;

    public SearchFormSettings(String searchText) {
        this.mSearchText = searchText;
        this.mSearchIn = 1;
        this.mSearcherType = 2;
        this.mCaseSensitive = false;
        this.mNrDays = 14;
    }

    public SearchFormSettings(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.mSearchText = (String)in.readObject();
        this.mSearchIn = in.readInt();
        this.mSearcherType = in.readInt();
        this.mCaseSensitive = in.readBoolean();
        int fieldTypeCount = in.readInt();
        if (fieldTypeCount > 0) {
            this.mUserDefinedFieldTypes = new ProgramFieldType[fieldTypeCount];
            for (int i = 0; i < this.mUserDefinedFieldTypes.length; ++i) {
                int typeId = in.readInt();
                this.mUserDefinedFieldTypes[i] = ProgramFieldType.getTypeForId(typeId);
            }
        } else {
            this.mUserDefinedFieldTypes = null;
        }
        if (version >= 2) {
            this.mNrDays = in.readInt();
        }
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(2);
        out.writeObject(this.mSearchText);
        out.writeInt(this.mSearchIn);
        out.writeInt(this.mSearcherType);
        out.writeBoolean(this.mCaseSensitive);
        if (this.mSearchIn == 3 && this.mUserDefinedFieldTypes != null) {
            out.writeInt(this.mUserDefinedFieldTypes.length);
            for (ProgramFieldType mUserDefinedFieldType : this.mUserDefinedFieldTypes) {
                out.writeInt(mUserDefinedFieldType.getTypeId());
            }
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.mNrDays);
    }

    public String toString() {
        return this.mSearchText;
    }

    public String getSearchText() {
        return this.mSearchText;
    }

    public void setSearchText(String searchText) {
        this.mSearchText = searchText;
        this.mSearcher = null;
    }

    public ProgramSearcher createSearcher() throws TvBrowserException {
        if (this.mSearcher == null) {
            this.mSearcher = Plugin.getPluginManager().createProgramSearcher(this.mSearcherType, this.mSearchText, this.mCaseSensitive);
        }
        return this.mSearcher;
    }

    public ProgramSearcher createSearcher(String text) throws TvBrowserException {
        return Plugin.getPluginManager().createProgramSearcher(this.mSearcherType, text, this.mCaseSensitive);
    }

    public ProgramFieldType[] getFieldTypes() {
        switch (this.mSearchIn) {
            case 1: {
                return new ProgramFieldType[]{ProgramFieldType.TITLE_TYPE};
            }
            case 2: {
                return SearchForm.getSearchableFieldTypes();
            }
        }
        if (this.mUserDefinedFieldTypes != null) {
            return this.mUserDefinedFieldTypes;
        }
        return SearchForm.getSearchableFieldTypes();
    }

    public ProgramFieldType[] getUserDefaultFieldTypes() {
        return this.mUserDefaultFieldTypes;
    }

    public ProgramFieldType[] getUserDefinedFieldTypes() {
        return this.mUserDefinedFieldTypes;
    }

    public void setUserDefinedFieldTypes(ProgramFieldType[] typeArr) {
        this.mUserDefinedFieldTypes = typeArr;
        this.mSearcher = null;
    }

    public void setUserDefaultFieldTypes(ProgramFieldType[] typeArr) {
        this.mUserDefaultFieldTypes = typeArr;
    }

    public int getSearchIn() {
        return this.mSearchIn;
    }

    public void setSearchIn(int searchIn) {
        this.mSearchIn = searchIn;
        this.mSearcher = null;
    }

    public int getSearcherType() {
        return this.mSearcherType;
    }

    public void setSearcherType(int searcherType) {
        this.mSearcherType = searcherType;
        this.mSearcher = null;
    }

    public boolean getCaseSensitive() {
        return this.mCaseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.mCaseSensitive = caseSensitive;
        this.mSearcher = null;
    }

    public int getNrDays() {
        return this.mNrDays;
    }

    public void setNrDays(int nr) {
        this.mNrDays = nr;
        this.mSearcher = null;
    }

    public Channel[] getChannels() {
        return this.mChannels;
    }

    public void setChannels(Channel[] channel) {
        this.mChannels = channel;
        this.mSearcher = null;
    }
}

