/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Date;
import devplugin.Program;
import devplugin.ProgramFilter;
import devplugin.ProgramSearcher;
import devplugin.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.extras.searchplugin.SearchDialog;
import tvbrowser.ui.mainframe.MainFrame;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.EnhancedPanelBuilder;
import util.ui.ProgramList;
import util.ui.SearchFormSettings;
import util.ui.SendToPluginDialog;
import util.ui.TVBrowserIcons;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class SearchHelper {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(SearchHelper.class);
    private static SearchHelper mInstance;
    private DefaultListModel<Program> mListModel = null;
    private ProgressMonitor mProgressMonitor;
    private JProgressBar mProgressBar;
    private ProgramList mProgramList;
    private JDialog mDialog = null;
    private JScrollPane mProgramListScrollPane;
    private JComboBox<ProgramFilter> mFilterSelection;
    private ProgramSearcher mSearcher;

    private SearchHelper() {
    }

    public static void search(Component comp, SearchFormSettings settings, ProgramPanelSettings pictureSettings) {
        SearchHelper.search(comp, settings, pictureSettings, false);
    }

    public static void search(Component comp, SearchFormSettings settings, ProgramPanelSettings pictureSettings, boolean showDialog) {
        if (mInstance == null) {
            mInstance = new SearchHelper();
        }
        if (pictureSettings == null) {
            pictureSettings = new ProgramPanelSettings(new PluginPictureSettings(0), false);
        }
        mInstance.doSearch(comp, settings, pictureSettings, showDialog);
    }

    public static void search(Component comp, PluginPictureSettings pictureSettings, SearchFormSettings settings, boolean showDialog) {
        SearchHelper.search(comp, settings, new ProgramPanelSettings(pictureSettings, false), showDialog);
    }

    public static void search(Component comp, PluginPictureSettings pictureSettings, SearchFormSettings settings) {
        SearchHelper.search(comp, settings, new ProgramPanelSettings(pictureSettings, false));
    }

    public static void search(Component comp, SearchFormSettings settings) {
        SearchHelper.search(comp, settings, null);
    }

    private void doSearch(Component comp, SearchFormSettings searcherSettings, ProgramPanelSettings pictureSettings, boolean showDialog) {
        if (showDialog) {
            this.mDialog = this.createHitsDialog(comp, new Program[0], LOCALIZER.msg("search", "Search"), searcherSettings, pictureSettings);
        }
        new Thread(() -> {
            block6: {
                Date startDate = new Date();
                Cursor cursor = comp.getCursor();
                try {
                    comp.setCursor(Cursor.getPredefinedCursor(3));
                    this.mSearcher = searcherSettings.createSearcher();
                    ProgressMonitor progressMonitor = null;
                    if (this.mProgressMonitor == null && !TvDataUpdater.getInstance().isDownloading()) {
                        progressMonitor = MainFrame.getInstance().getStatusBar().createProgressMonitor();
                        progressMonitor.setMessage(LOCALIZER.msg("searching", "Searching"));
                    }
                    Program[] programArr = this.mSearcher.search(searcherSettings.getFieldTypes(), startDate, searcherSettings.getNrDays(), searcherSettings.getChannels(), true, this.mListModel, this.mProgressMonitor != null ? this.mProgressMonitor : progressMonitor);
                    comp.setCursor(cursor);
                    if (programArr.length == 0) {
                        UIThreadRunner.invokeLater(() -> {
                            String msg = LOCALIZER.msg("nothingFound", "No programs found with {0}!", searcherSettings.getSearchText());
                            JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), msg);
                            if (this.mDialog != null) {
                                this.mDialog.setVisible(false);
                                this.mDialog = null;
                            }
                        });
                        break block6;
                    }
                    this.mFilterSelection.setEnabled(true);
                    if (!showDialog) {
                        String title = LOCALIZER.msg("hitsTitle", "Programs with {0}", searcherSettings.getSearchText());
                        this.createHitsDialog(comp, programArr, title, searcherSettings, pictureSettings).setVisible(true);
                        this.mDialog = null;
                        break block6;
                    }
                    if (this.mProgressBar == null) break block6;
                    this.mProgressBar.setVisible(false);
                    UIThreadRunner.invokeLater(() -> this.mProgramList.updateUI());
                    if (this.mProgramList.getSelectedIndex() != -1 || this.mProgramListScrollPane.getVerticalScrollBar().getValue() != 0) break block6;
                    for (int i = 0; i < this.mProgramList.getModel().getSize(); ++i) {
                        Object value = this.mProgramList.getModel().getElementAt(i);
                        if (!(value instanceof Program) || ((Program)value).isExpired()) continue;
                        int scrollIndex = i;
                        SwingUtilities.invokeLater(() -> {
                            this.mProgramListScrollPane.getVerticalScrollBar().setValue(0);
                            this.mProgramListScrollPane.getHorizontalScrollBar().setValue(0);
                            if (scrollIndex != -1) {
                                Rectangle cellBounds = this.mProgramList.getCellBounds(scrollIndex, scrollIndex);
                                cellBounds.setLocation(cellBounds.x, cellBounds.y - this.mProgramListScrollPane.getBorder().getBorderInsets((Component)this.mProgramListScrollPane).top - this.mProgramListScrollPane.getInsets().top + this.mProgramListScrollPane.getHeight() - cellBounds.height);
                                this.mProgramList.scrollRectToVisible(cellBounds);
                            }
                        });
                        break;
                    }
                }
                catch (TvBrowserException exc) {
                    comp.setCursor(cursor);
                    ErrorHandler.handle(exc);
                }
            }
        }, "Search programs").start();
        if (this.mDialog != null) {
            UiUtilities.centerAndShow(this.mDialog);
            this.mDialog = null;
        }
    }

    private JDialog createHitsDialog(Component comp, Program[] programArr, String title, SearchFormSettings searchSettings, ProgramPanelSettings pictureSettings) {
        Window parentWindow = UiUtilities.getBestDialogParent(comp);
        final JDialog dlg = new JDialog(parentWindow, title, Dialog.ModalityType.DOCUMENT_MODAL);
        UiUtilities.registerForClosing(new WindowClosingIf(){

            @Override
            public void close() {
                dlg.dispose();
            }

            @Override
            public JRootPane getRootPane() {
                return dlg.getRootPane();
            }
        });
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder("default:grow");
        pb.border(Borders.DIALOG);
        dlg.setLayout(new BorderLayout());
        dlg.add((Component)pb.getPanel(), "Center");
        int curPos = -1;
        for (int i = 0; i < programArr.length && curPos == -1; ++i) {
            if (programArr[i].isExpired()) continue;
            curPos = i;
        }
        this.mListModel = new DefaultListModel();
        for (Program program : programArr) {
            this.mListModel.addElement(program);
        }
        if (programArr.length == 0) {
            this.mProgressBar = new JProgressBar();
            this.mProgressMonitor = new ProgressMonitor(){

                @Override
                public void setMaximum(int maximum) {
                    UIThreadRunner.invokeLater(() -> SearchHelper.this.mProgressBar.setMaximum(maximum));
                }

                @Override
                public void setMessage(String msg) {
                }

                @Override
                public void setValue(int value) {
                    UIThreadRunner.invokeLater(() -> SearchHelper.this.mProgressBar.setValue(value));
                }
            };
            pb.addRowFull(this.mProgressBar);
        }
        this.mFilterSelection = new JComboBox<ProgramFilter>(FilterManagerImpl.getInstance().getAvailableFilters());
        this.mFilterSelection.setSelectedItem(FilterManagerImpl.getInstance().getAllFilter());
        this.mFilterSelection.setEnabled(false);
        this.mFilterSelection.addItemListener(new ItemListener(){
            private Program[] mPrograms;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (this.mPrograms == null) {
                        this.mPrograms = new Program[SearchHelper.this.mListModel.size()];
                        SearchHelper.this.mListModel.copyInto(this.mPrograms);
                    }
                    SearchHelper.this.mListModel.clear();
                    ProgramFilter progFilter = (ProgramFilter)e.getItem();
                    for (Program p : this.mPrograms) {
                        if (!progFilter.accept(p)) continue;
                        SearchHelper.this.mListModel.addElement(p);
                    }
                }
            }
        });
        JPanel filter = new JPanel((LayoutManager)new FormLayout("default,3dlu,default:grow", "default"));
        filter.add((Component)new JLabel("Filter:"), CC.xy((int)1, (int)1));
        filter.add(this.mFilterSelection, CC.xy((int)3, (int)1));
        pb.addRowFull(false, (Component)filter);
        this.mProgramList = new ProgramList(this.mListModel, pictureSettings);
        this.mProgramList.addMouseAndKeyListeners(null);
        this.mProgramListScrollPane = new JScrollPane(this.mProgramList);
        pb.addGrowingRowFull(this.mProgramListScrollPane);
        if (curPos >= 0) {
            this.mProgramList.setSelectedValue(programArr[curPos], true);
        }
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.setLeftToRight(true);
        builder.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        ImageIcon icon = TVBrowserIcons.copy(16);
        final JButton sendBt = new JButton(icon);
        sendBt.setEnabled(false);
        sendBt.setToolTipText(LOCALIZER.msg("send", "Send Programs to another Plugin"));
        sendBt.addActionListener(evt -> {
            Program[] program = this.mProgramList.getSelectedPrograms();
            if (program == null) {
                program = new Program[this.mListModel.size()];
                for (int programIndex = 0; programIndex < this.mListModel.size(); ++programIndex) {
                    program[programIndex] = this.mListModel.getElementAt(programIndex);
                }
            }
            SendToPluginDialog send = new SendToPluginDialog(null, MainFrame.getInstance(), program);
            send.setVisible(true);
        });
        builder.addFixed((JComponent)sendBt);
        this.mListModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                sendBt.setEnabled(true);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        if (!(comp instanceof SearchDialog)) {
            icon = TVBrowserIcons.edit(16);
            JButton changeBt = new JButton(icon);
            changeBt.setToolTipText(LOCALIZER.msg("edit", "Change search parameters"));
            changeBt.addActionListener(evt -> {
                dlg.dispose();
                SearchDialog searchDialog = new SearchDialog(parentWindow);
                searchDialog.setSearchSettings(searchSettings);
                UiUtilities.centerAndShow(searchDialog);
            });
            builder.addRelatedGap();
            builder.addFixed((JComponent)changeBt);
        }
        JButton closeBt = new JButton(Localizer.getLocalization("i18n_close"));
        closeBt.addActionListener(evt -> {
            SearchHelper.stopSearch();
            dlg.dispose();
        });
        builder.addGlue();
        builder.addFixed((JComponent)closeBt);
        pb.addRowFull(builder.getPanel());
        dlg.getRootPane().setDefaultButton(closeBt);
        Settings.layoutWindow("searchDlg", dlg, new Dimension(400, 400));
        return dlg;
    }

    public static void stopSearch() {
        if (mInstance != null && SearchHelper.mInstance.mSearcher != null) {
            SearchHelper.mInstance.mSearcher.stopSearch();
        }
    }
}

