/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import util.i18n.Localizer;
import util.misc.TextUtilities;
import util.ui.LineNumberHeader;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class SearchableTextAreaPanel
extends JPanel {
    private static final Color NOT_FOUND = new Color(255, 100, 100);
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(SearchableTextAreaPanel.class);
    private JTextArea mContent;

    public SearchableTextAreaPanel(String text) {
        this(text, true);
    }

    public SearchableTextAreaPanel(String text, boolean caseSensitiveSearch) {
        this(text, null, caseSensitiveSearch);
    }

    public SearchableTextAreaPanel(String text, String lineSeparator, boolean caseSensitiveSearch) {
        if (lineSeparator != null) {
            text = text.replace(lineSeparator, "\n");
        }
        this.mContent = new JTextArea(text);
        JScrollPane scroll = new JScrollPane(this.mContent);
        scroll.setRowHeaderView(new LineNumberHeader(this.mContent));
        final JButton search = new JButton(TVBrowserIcons.search(22));
        JLabel searchLabel = new JLabel(LOCALIZER.msg("search", "Search in list:"));
        JTextField searchField = new JTextField(){

            @Override
            public void paste() {
                super.paste();
                SearchableTextAreaPanel.this.mContent.select(-1, -1);
                search.setEnabled(!this.getText().trim().isEmpty());
                search.doClick();
            }

            @Override
            public void cut() {
                super.cut();
                search.setEnabled(false);
                SearchableTextAreaPanel.this.mContent.select(-1, -1);
            }
        };
        Color backgroundDefault = searchField.getBackground();
        Color foregroundDefault = searchField.getForeground();
        search.setEnabled(false);
        search.addActionListener(ee -> {
            int pos;
            int startIndex = this.mContent.getSelectionEnd();
            this.mContent.select(-1, -1);
            int n = pos = caseSensitiveSearch ? this.mContent.getText().indexOf(searchField.getText().trim(), startIndex) : this.mContent.getText().toLowerCase().indexOf(searchField.getText().toLowerCase().trim(), startIndex);
            if (startIndex > 0 && pos == -1) {
                int n2 = pos = caseSensitiveSearch ? this.mContent.getText().indexOf(searchField.getText().trim()) : this.mContent.getText().toLowerCase().indexOf(searchField.getText().toLowerCase().trim());
            }
            if (pos != -1) {
                this.mContent.getCaret().setSelectionVisible(true);
                try {
                    Rectangle bounds = this.mContent.modelToView2D(pos).getBounds();
                    this.mContent.scrollRectToVisible(bounds);
                    this.mContent.moveCaretPosition(pos + searchField.getText().trim().length());
                    this.mContent.select(pos, pos + searchField.getText().trim().length());
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            } else if (UiUtilities.isGTKLookAndFeel()) {
                searchField.setForeground(NOT_FOUND);
            } else {
                searchField.setBackground(NOT_FOUND);
            }
        });
        searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    search.doClick();
                    e.consume();
                }
            }
        });
        searchField.addCaretListener(ee -> {
            searchField.setBackground(backgroundDefault);
            searchField.setForeground(foregroundDefault);
            search.setEnabled(searchField.getText().trim().length() > 0 && this.mContent.getText().length() > 0);
            this.mContent.select(-1, -1);
        });
        this.setLayout((LayoutManager)new FormLayout("default,2dlu,default:grow,2dlu,default", "fill:40dlu:grow,2dlu,default"));
        this.add((Component)searchLabel, CC.xy((int)1, (int)3));
        this.add((Component)searchField, CC.xy((int)3, (int)3));
        this.add((Component)search, CC.xy((int)5, (int)3));
        this.add((Component)scroll, CC.xyw((int)1, (int)1, (int)5));
    }

    public JTextArea getTextArea() {
        return this.mContent;
    }

    public String getText() {
        return this.mContent.getText();
    }

    public void setText(String text) {
        this.mContent.setText(text);
    }

    public void setText(String lineSeparator, String text) {
        this.setText(text.replaceAll(lineSeparator, "\n"));
    }

    public String getText(String lineSeparator) {
        return TextUtilities.removeDoubletLines(this.getText(), "\\n+", lineSeparator);
    }
}

