/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.randomnumbers;

import java.lang.reflect.Constructor;
import org.jquantlib.lang.reflect.TypeToken;
import org.jquantlib.math.randomnumbers.InverseCumulative;
import org.jquantlib.math.randomnumbers.InverseCumulativeRsg;
import org.jquantlib.math.randomnumbers.RandomNumberGenerator;
import org.jquantlib.math.randomnumbers.RandomSequenceGenerator;

public abstract class GenericPseudoRandom<RNG extends RandomNumberGenerator, IC extends InverseCumulative> {
    private static final boolean allowsErrorEstimate = true;
    private static final GenericPseudoRandom icInstance = null;

    protected InverseCumulativeRsg<RandomSequenceGenerator<RNG>, IC> makeSequenceGenerator(int dimension, long seed) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        try {
            InverseCumulative ic;
            RandomSequenceGenerator rsg;
            RandomNumberGenerator rng;
            try {
                Class<?> rngClass = TypeToken.getClazz(GenericPseudoRandom.class, 0);
                Constructor<?> c = rngClass.getConstructor(Long.TYPE);
                rng = (RandomNumberGenerator)c.newInstance(seed);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                Class<?> rsgClass = TypeToken.getClazz(rng.getClass());
                Constructor<?> c = rsgClass.getConstructor(Integer.TYPE, rng.getClass());
                rsg = (RandomSequenceGenerator)c.newInstance(dimension, rng);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                Class<?> icClass = TypeToken.getClazz(GenericPseudoRandom.class, 1);
                if (icInstance != null) {
                    Constructor<?> c = icClass.getConstructor(rsg.getClass(), icClass.getClass());
                    ic = (InverseCumulative)c.newInstance(rsg, icInstance);
                } else {
                    Constructor<?> c = icClass.getConstructor(rsg.getClass());
                    ic = (InverseCumulative)c.newInstance(rsg);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return (InverseCumulativeRsg)((Object)ic);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

