/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import org.jquantlib.lang.reflect.TypeToken;
import org.jquantlib.methods.finitedifferences.Pde;
import org.jquantlib.methods.finitedifferences.PdeSecondOrderParabolic;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public abstract class PdeConstantCoeff<T extends Pde>
extends PdeSecondOrderParabolic {
    private double diffusion;
    private double drift;
    private double discount;

    public PdeConstantCoeff(GeneralizedBlackScholesProcess process, double t, double x) {
        Class<?> clazz = TypeToken.getClazz(this.getClass());
        Object pde = this.getInstance(clazz, process);
        this.diffusion = pde.diffusion(t, x);
        this.drift = pde.drift(t, x);
        this.discount = pde.discount(t, x);
    }

    @Override
    public double diffusion(double t, double x) {
        return this.diffusion;
    }

    @Override
    public double discount(double t, double x) {
        return this.discount;
    }

    @Override
    public double drift(double t, double x) {
        return this.drift;
    }

    protected T getInstance(Class<T> clazz, GeneralizedBlackScholesProcess process) {
        try {
            return (T)((Pde)clazz.getConstructor(GeneralizedBlackScholesProcess.class).newInstance(process));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

