/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseEventSink;
import org.apache.cxf.common.logging.LogUtils;

public class SseEventSinkImpl
implements SseEventSink {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final Logger LOG = LogUtils.getL7dLogger(SseEventSinkImpl.class);
    private static final int BUFFER_SIZE = 10000;
    private final AsyncContext ctx;
    private final MessageBodyWriter<OutboundSseEvent> writer;
    private final Queue<QueuedEvent> buffer;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean dispatching = new AtomicBoolean(false);

    public SseEventSinkImpl(MessageBodyWriter<OutboundSseEvent> writer, AsyncResponse async, AsyncContext ctx) {
        this.writer = writer;
        this.buffer = new ArrayBlockingQueue<QueuedEvent>(10000);
        this.ctx = ctx;
        if (ctx == null) {
            throw new IllegalStateException("Unable to retrieve the AsyncContext for this request. Is the Servlet configured properly?");
        }
        ctx.getResponse().setContentType("text/event-stream");
    }

    public AsyncContext getAsyncContext() {
        return this.ctx;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (!this.awaitQueueToDrain(5, TimeUnit.SECONDS)) {
                LOG.warning("There are still SSE events the queue which may not be delivered (closing now)");
            }
            try {
                this.ctx.complete();
            }
            catch (IllegalStateException ex) {
                LOG.warning("Failed to close the AsyncContext cleanly: " + ex.getMessage());
            }
        }
    }

    private boolean awaitQueueToDrain(int timeout, TimeUnit unit) {
        long parkTime = unit.toNanos(timeout) / 20L;
        int attempt = 0;
        while (this.dispatching.get() && ++attempt < 20) {
            LockSupport.parkNanos(parkTime);
        }
        return this.buffer.isEmpty();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public CompletionStage<?> send(OutboundSseEvent event) {
        CompletableFuture future = new CompletableFuture();
        if (!this.closed.get() && this.writer != null) {
            if (this.buffer.offer(new QueuedEvent(event, future))) {
                if (this.dispatching.compareAndSet(false, true)) {
                    this.ctx.start(this::dequeue);
                }
            } else {
                future.completeExceptionally(new IllegalStateException("The buffer is full (10000), unable to queue SSE event for send"));
            }
        } else {
            future.completeExceptionally(new IllegalStateException("The sink is already closed, unable to queue SSE event for send"));
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dequeue() {
        block8: {
            block5: while (true) {
                while (true) {
                    QueuedEvent qeuedEvent;
                    if ((qeuedEvent = this.buffer.poll()) == null) {
                        break block8;
                    }
                    OutboundSseEvent event = qeuedEvent.event;
                    CompletableFuture future = qeuedEvent.completion;
                    try {
                        this.writer.writeTo((Object)event, event.getClass(), event.getGenericType(), EMPTY_ANNOTATIONS, event.getMediaType(), null, (OutputStream)this.ctx.getResponse().getOutputStream());
                        this.ctx.getResponse().flushBuffer();
                        future.complete(null);
                        continue block5;
                    }
                    catch (Exception ex) {
                        future.completeExceptionally(ex);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.dispatching.set(false);
            }
        }
    }

    private static class QueuedEvent {
        private final OutboundSseEvent event;
        private final CompletableFuture<?> completion;

        QueuedEvent(OutboundSseEvent event, CompletableFuture<?> completion) {
            this.event = event;
            this.completion = completion;
        }
    }
}

