/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.TermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.calendars.NullCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.TypedVisitor;
import org.jquantlib.util.Visitor;

public abstract class BlackVarianceTermStructure
extends BlackVolTermStructure {
    public BlackVarianceTermStructure() {
        this(Actual365Fixed.getDayCounter());
    }

    public BlackVarianceTermStructure(DayCounter dc) {
        super(dc);
    }

    public BlackVarianceTermStructure(Date referenceDate) {
        this(referenceDate, (Calendar)new NullCalendar());
    }

    public BlackVarianceTermStructure(Date referenceDate, Calendar cal) {
        this(referenceDate, cal, (DayCounter)Actual365Fixed.getDayCounter());
    }

    public BlackVarianceTermStructure(Date referenceDate, Calendar cal, DayCounter dc) {
        super(referenceDate, cal, dc);
    }

    public BlackVarianceTermStructure(int settlementDays, Calendar cal) {
        super(settlementDays, cal, (DayCounter)Actual365Fixed.getDayCounter());
    }

    public BlackVarianceTermStructure(int settlementDays, Calendar cal, DayCounter dc) {
        super(settlementDays, cal, dc);
    }

    @Override
    protected final double blackVolImpl(double maturity, double strike) {
        double m = maturity;
        double nonZeroMaturity = m == 0.0 ? 1.0E-5 : m;
        double var = this.blackVarianceImpl(nonZeroMaturity, strike);
        return Math.sqrt(var / nonZeroMaturity);
    }

    @Override
    public void accept(TypedVisitor<TermStructure> v) {
        Visitor<TermStructure> v1;
        Visitor<TermStructure> visitor = v1 = v != null ? v.getVisitor(this.getClass()) : null;
        if (v1 != null) {
            v1.visit(this);
        } else {
            super.accept(v);
        }
    }
}

