/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time;

import cern.colt.Sorting;
import cern.colt.function.DoubleComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joda.primitives.list.impl.ArrayDoubleList;
import org.jquantlib.lang.annotation.NonNegative;
import org.jquantlib.lang.annotation.Time;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.DoubleComparatorImpl;
import org.jquantlib.util.stdlibc.DoubleForwardIterator;
import org.jquantlib.util.stdlibc.DoubleReverseIterator;
import org.jquantlib.util.stdlibc.Std;

public class TimeGrid {
    private final double[] times;
    private final double[] dt;
    private final double[] mandatoryTimes;

    public TimeGrid(@Time @NonNegative double end, @NonNegative int steps) {
        int i;
        if (end <= 0.0) {
            throw new IllegalArgumentException("negative times not allowed");
        }
        double dt = end / (double)steps;
        this.times = new double[steps + 1];
        for (i = 0; i <= steps; ++i) {
            this.times[i] = dt * (double)i;
        }
        this.mandatoryTimes = new double[1];
        this.mandatoryTimes[0] = end;
        this.dt = new double[steps];
        for (i = 0; i < steps; ++i) {
            this.dt[i] = dt;
        }
    }

    public TimeGrid(@Time @NonNegative double[] array) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("This constructor is not available yet");
        }
        this.mandatoryTimes = Arrays.copyOf(array, array.length);
        Sorting.quickSort((double[])this.mandatoryTimes, (int)0, (int)this.mandatoryTimes.length, (DoubleComparator)new DoubleComparatorImpl());
        if (this.mandatoryTimes[0] < 0.0) {
            throw new ArithmeticException("negative times not allowed");
        }
        ArrayDoubleList e = new ArrayDoubleList(this.mandatoryTimes);
        double prev = this.mandatoryTimes[0];
        e.add(prev);
        for (int i = 1; i < this.mandatoryTimes.length; ++i) {
            double curr = this.mandatoryTimes[i];
            if (!Closeness.isCloseEnough(prev, curr)) {
                e.add(curr);
            }
            prev = curr;
        }
        ArrayDoubleList tmp = new ArrayDoubleList();
        if (this.mandatoryTimes[0] > 0.0) {
            tmp.add(0.0);
            tmp.addAll(1, this.mandatoryTimes);
        } else {
            tmp.addAll(0, this.mandatoryTimes);
        }
        this.times = tmp.toDoubleArray();
        this.dt = null;
    }

    public TimeGrid(@Time double[] array, int steps) {
        double dtMax;
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("This constructor is not available yet");
        }
        this.mandatoryTimes = Arrays.copyOf(array, array.length);
        Sorting.quickSort((double[])this.mandatoryTimes, (int)0, (int)array.length, null);
        if (this.mandatoryTimes[0] < 0.0) {
            throw new ArithmeticException("negative times not allowed");
        }
        double last = this.mandatoryTimes[this.mandatoryTimes.length - 1];
        if (steps == 0) {
            ArrayList<Double> diff = new ArrayList<Double>();
            List<Double> templist = Arrays.asList(new double[][]{this.mandatoryTimes});
            Std.adjacent_difference(templist, 1, diff);
            if ((Double)diff.get(0) == 0.0) {
                diff.remove(0.0);
            }
            dtMax = Std.min_element(0, diff.size() - 1, diff);
        } else {
            dtMax = last / (double)steps;
        }
        double periodBegin = 0.0;
        ArrayDoubleList temp_times_ = new ArrayDoubleList();
        temp_times_.add(periodBegin);
        for (double periodEnd : this.mandatoryTimes) {
            if (periodEnd != 0.0) {
                int nSteps = (int)Math.round((periodBegin - periodEnd) / dtMax + 0.5);
                nSteps = nSteps != 0 ? nSteps : 1;
                double dt = (periodEnd - periodBegin) / (double)nSteps;
                for (int n = 1; n <= nSteps; ++n) {
                    temp_times_.add(periodBegin + (double)n * dt);
                }
            }
            periodBegin = periodEnd;
        }
        this.times = temp_times_.toDoubleArray();
        this.dt = null;
    }

    @NonNegative
    public int index(@Time @NonNegative double t) {
        int k;
        int j;
        int i = this.closestIndex(t);
        if (Closeness.isCloseEnough(t, this.times[i])) {
            return i;
        }
        if (t < this.front()) {
            throw new IllegalArgumentException("using inadequate time grid: all nodes are later than the required time t = " + t + " (earliest node is t1 = " + this.times[0] + ")");
        }
        if (t > this.back()) {
            throw new IllegalArgumentException("using inadequate time grid: all nodes are earlier than the required time t = " + t + " (latest node is t1 = " + this.back() + ")");
        }
        if (t > this.times[i]) {
            j = i;
            k = i + 1;
        } else {
            j = i - 1;
            k = i;
        }
        throw new IllegalArgumentException("using inadequate time grid: the nodes closest to the required time t = " + t + " are t1 = " + this.times[j] + " and t2 = " + this.times[k]);
    }

    @NonNegative
    public int closestIndex(@Time @NonNegative double t) {
        int size = this.times.length;
        int result = Std.lower_bound(this.times, t);
        if (result == 0) {
            return 0;
        }
        if (result == size) {
            return size - 1;
        }
        double dt1 = this.times[result] - t;
        double dt2 = t - this.times[result - 1];
        if (dt1 < dt2) {
            return result;
        }
        return result - 1;
    }

    @Time
    public double closestTime(@Time @NonNegative double t) {
        return this.times[this.closestIndex(t)];
    }

    public final double[] mandatoryTimes() {
        return this.mandatoryTimes;
    }

    public double dt(int i) {
        return this.dt[i];
    }

    public double get(int i) {
        return this.times[i];
    }

    public double at(int i) {
        return this.times[i];
    }

    public int size() {
        return this.times.length;
    }

    public boolean empty() {
        return this.times.length == 0;
    }

    public double begin() {
        return this.times[0];
    }

    public double end() {
        return this.times[this.times.length - 1];
    }

    public DoubleForwardIterator forwardIterator() {
        return Std.forwardIterator(this.times);
    }

    public DoubleReverseIterator reverseIterator() {
        return Std.reverseIterator(this.times);
    }

    public double front() {
        return this.times[0];
    }

    public double back() {
        return this.times[this.times.length - 1];
    }
}

