/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.async.impl;

import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.aries.async.impl.FireAndForgetWork;
import org.apache.aries.async.impl.Work;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.async.delegate.AsyncDelegate;
import org.osgi.service.log.LogService;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Promises;
import org.osgi.util.tracker.ServiceTracker;

public class MethodCall {
    private final Bundle clientBundle;
    private final ServiceTracker<LogService, LogService> logServiceTracker;
    private final ServiceReference<?> reference;
    private final Object service;
    final Method method;
    final Object[] arguments;

    public MethodCall(Bundle clientBundle, ServiceTracker<LogService, LogService> logServiceTracker, ServiceReference<?> reference, Object service, Method method, Object[] arguments) {
        this.clientBundle = clientBundle;
        this.logServiceTracker = logServiceTracker;
        this.reference = reference;
        this.service = service;
        this.method = method;
        this.arguments = arguments;
    }

    Object getService() {
        if (this.reference != null) {
            BundleContext bc = this.clientBundle.getBundleContext();
            if (bc != null) {
                try {
                    Object svc = bc.getService(this.reference);
                    if (svc == null) {
                        throw new ServiceException("Unable to retrieve the mediated service because it has been unregistered", 7);
                    }
                    return svc;
                }
                catch (Exception e) {
                    throw new ServiceException("Unable to retrieve the mediated service", 7, (Throwable)e);
                }
            }
            throw new ServiceException("Unable to retrieve the mediated service because the client bundle has been stopped", 7);
        }
        return this.service;
    }

    void releaseService() {
        BundleContext bc;
        if (this.reference != null && (bc = this.clientBundle.getBundleContext()) != null) {
            bc.ungetService(this.reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Promise<V> invokeAsynchronously(Bundle clientBundle, ExecutorService executor) {
        Deferred deferred;
        block13: {
            Object svc;
            deferred = new Deferred();
            try {
                svc = this.getService();
            }
            catch (Exception e) {
                deferred.fail(e);
                return deferred.getPromise();
            }
            if (svc instanceof AsyncDelegate) {
                Promise<?> p = ((AsyncDelegate)svc).async(this.method, this.arguments);
                if (p == null) break block13;
                try {
                    deferred.resolveWith(p);
                    Promise promise = deferred.getPromise();
                    this.releaseService();
                    return promise;
                }
                catch (Throwable throwable) {
                    try {
                        this.releaseService();
                        throw throwable;
                    }
                    catch (Exception e) {
                        try {
                            deferred.fail(e);
                            Promise promise = deferred.getPromise();
                            return promise;
                        }
                        finally {
                            this.releaseService();
                        }
                    }
                }
            }
        }
        try {
            executor.execute(new Work(this, deferred));
        }
        catch (RejectedExecutionException ree) {
            deferred.fail((Throwable)new ServiceException("The Async service is unable to accept new requests", 7, (Throwable)ree));
        }
        Promise promise = deferred.getPromise();
        promise.onResolve(new Runnable(){

            @Override
            public void run() {
                MethodCall.this.releaseService();
            }
        });
        return promise;
    }

    public Promise<Void> fireAndForget(Bundle clientBundle, ExecutorService executor) {
        Object svc;
        try {
            svc = this.getService();
        }
        catch (Exception e) {
            this.logError("Unable to obtain the service object", e);
            return Promises.failed(e);
        }
        if (svc instanceof AsyncDelegate) {
            try {
                if (((AsyncDelegate)svc).execute(this.method, this.arguments)) {
                    this.releaseService();
                    return Promises.resolved(null);
                }
            }
            catch (Exception e) {
                this.releaseService();
                this.logError("The AsyncDelegate rejected the fire-and-forget invocation with an exception", e);
                return Promises.failed(e);
            }
        }
        Deferred<Void> cleanup = new Deferred<Void>();
        Deferred<Void> started = new Deferred<Void>();
        try {
            executor.execute(new FireAndForgetWork(this, cleanup, started));
            cleanup.getPromise().onResolve(new Runnable(){

                @Override
                public void run() {
                    MethodCall.this.releaseService();
                }
            }).then(null, new Failure(){

                @Override
                public void fail(Promise<?> resolved) throws Exception {
                    MethodCall.this.logError("The fire-and-forget invocation failed", resolved.getFailure());
                }
            });
            return started.getPromise();
        }
        catch (RejectedExecutionException ree) {
            this.logError("The Async Service threadpool rejected the fire-and-forget invocation", ree);
            return Promises.failed((Throwable)new ServiceException("Unable to enqueue the fire-and forget task", 7, (Throwable)ree));
        }
    }

    void logError(String message, Throwable e) {
        for (LogService log : (LogService[])this.logServiceTracker.getServices((Object[])new LogService[0])) {
            if (this.reference == null) {
                log.log(1, message, e);
                continue;
            }
            log.log(this.reference, 1, message, e);
        }
    }
}

