/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.FailedPromisesException;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Success;

public class Promises {
    public static <T> Promise<T> resolved(T value) {
        Deferred<T> def = new Deferred<T>();
        def.resolve(value);
        return def.getPromise();
    }

    public static <T> Promise<T> failed(Throwable failure) {
        if (failure == null) {
            throw new NullPointerException();
        }
        Deferred def = new Deferred();
        def.fail(failure);
        return def.getPromise();
    }

    public static <T, S> Promise<List<T>> all(final Collection<Promise<S>> promises) {
        if (promises == null) {
            throw new NullPointerException();
        }
        final Deferred result = new Deferred();
        final ArrayList failedPromises = new ArrayList();
        final ArrayList resolvedValues = new ArrayList();
        if (promises.size() == 0) {
            result.resolve(resolvedValues);
        }
        for (Promise<S> promise : promises) {
            promise.then(new Success<S, T>(){

                @Override
                public Promise<T> call(Promise<S> resolved) throws Exception {
                    Object value = resolved.getValue();
                    resolvedValues.add(value);
                    if (resolvedValues.size() == promises.size()) {
                        result.resolve(resolvedValues);
                    } else if (failedPromises.size() + resolvedValues.size() == promises.size()) {
                        result.fail(new FailedPromisesException(failedPromises));
                    }
                    return null;
                }
            }, new Failure(){

                @Override
                public void fail(Promise<?> resolved) throws Exception {
                    failedPromises.add(resolved);
                    if (failedPromises.size() + resolvedValues.size() == promises.size()) {
                        result.fail(new FailedPromisesException(failedPromises));
                    }
                }
            });
        }
        return result.getPromise();
    }

    public static <T> Promise<List<T>> all(Promise<? extends T> ... promises) {
        if (promises == null) {
            throw new NullPointerException();
        }
        ArrayList list = new ArrayList();
        Promise<? extends T>[] arr$ = promises;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Promise<? extends T> promise;
            Promise<? extends T> pt = promise = arr$[i$];
            list.add(pt);
        }
        return Promises.all(list);
    }
}

