/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.bnd;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.RepositoryListenerPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.tool.Tool;
import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import aQute.lib.converter.Converter;
import aQute.lib.io.IO;
import aQute.libg.cryptography.SHA1;
import aQute.libg.glob.Glob;
import aQute.maven.bnd.LocalRepoWatcher;
import aQute.maven.bnd.ReleaseDTO;
import aQute.maven.repo.api.Archive;
import aQute.maven.repo.api.IMavenRepo;
import aQute.maven.repo.api.POM;
import aQute.maven.repo.api.Program;
import aQute.maven.repo.api.Release;
import aQute.maven.repo.api.Revision;
import aQute.maven.repo.provider.MavenStorage;
import aQute.maven.repo.provider.RemoteRepo;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Success;

@BndPlugin(name="MavenBndRepository")
public class MavenBndRepository
implements RepositoryPlugin,
RegistryPlugin,
Plugin,
Closeable,
Refreshable {
    private Configuration configuration;
    private Registry registry;
    private File localRepo;
    private Reporter reporter;
    private IMavenRepo storage;
    private boolean inited;
    private boolean ok = true;
    private LocalRepoWatcher repoWatcher;

    public RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        this.init();
        File binaryFile = File.createTempFile("put", ".jar");
        File pomFile = File.createTempFile("pom", ".xml");
        try {
            RepositoryPlugin.PutResult result;
            block53: {
                byte[] digest;
                result = new RepositoryPlugin.PutResult();
                if (options == null) {
                    options = new RepositoryPlugin.PutOptions();
                }
                IO.copy((InputStream)stream, (File)binaryFile);
                if (options.digest != null && !Arrays.equals(options.digest, digest = SHA1.digest((File)binaryFile).digest())) {
                    throw new IllegalArgumentException("The given sha-1 does not match the contents sha-1");
                }
                Throwable throwable = null;
                Object var7_8 = null;
                try (Jar binary = new Jar(binaryFile);){
                    Resource pomResource = this.getPomResource(binary);
                    if (pomResource == null) {
                        throw new IllegalArgumentException("No POM resource in META-INF/maven/... The Maven Bnd Repository requires this pom.");
                    }
                    IO.copy((InputStream)pomResource.openInputStream(), (File)pomFile);
                    POM pom = new POM(pomFile);
                    Throwable throwable2 = null;
                    Object var12_15 = null;
                    try (Release releaser = this.storage.release(pom.getRevision());){
                        ReleaseDTO instructions = this.getReleaseDTO(options.context);
                        if (this.isLocal(instructions)) {
                            releaser.setLocalOnly();
                        }
                        Archive binaryArchive = pom.binaryArchive();
                        releaser.add(pom.getRevision().pomArchive(), pomFile);
                        releaser.add(binaryArchive, binaryFile);
                        URI uRI = result.artifact = this.isLocal(instructions) ? this.storage.toLocalFile(binaryArchive).toURI() : this.storage.toRemoteURI(binaryArchive);
                        if (this.isLocal(instructions)) break block53;
                        Throwable throwable3 = null;
                        Object var17_22 = null;
                        try (Tool tool = new Tool(options.context, binary);){
                            Jar jar;
                            Object var20_28;
                            Throwable throwable4;
                            if (instructions.javadoc != null) {
                                throwable4 = null;
                                var20_28 = null;
                                try {
                                    jar = this.getJavadoc(tool, options.context, instructions.javadoc.path, instructions.javadoc.options);
                                    try {
                                        this.save(releaser, pom.getRevision(), jar, "javadoc");
                                    }
                                    finally {
                                        if (jar != null) {
                                            jar.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable5) {
                                    if (throwable4 == null) {
                                        throwable4 = throwable5;
                                    } else if (throwable4 != throwable5) {
                                        throwable4.addSuppressed(throwable5);
                                    }
                                    throw throwable4;
                                }
                            }
                            if (instructions.sources == null) break block53;
                            throwable4 = null;
                            var20_28 = null;
                            try {
                                jar = this.getSource(tool, options.context, instructions.javadoc.path);
                                try {
                                    this.save(releaser, pom.getRevision(), jar, "sources");
                                }
                                finally {
                                    if (jar != null) {
                                        jar.close();
                                    }
                                }
                            }
                            catch (Throwable throwable6) {
                                if (throwable4 == null) {
                                    throwable4 = throwable6;
                                } else if (throwable4 != throwable6) {
                                    throwable4.addSuppressed(throwable6);
                                }
                                throw throwable4;
                            }
                        }
                        catch (Throwable throwable7) {
                            if (throwable3 == null) {
                                throwable3 = throwable7;
                            } else if (throwable3 != throwable7) {
                                throwable3.addSuppressed(throwable7);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable8) {
                        if (throwable2 == null) {
                            throwable2 = throwable8;
                        } else if (throwable2 != throwable8) {
                            throwable2.addSuppressed(throwable8);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable9) {
                    if (throwable == null) {
                        throwable = throwable9;
                    } else if (throwable != throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    throw throwable;
                }
            }
            RepositoryPlugin.PutResult putResult = result;
            return putResult;
        }
        finally {
            binaryFile.delete();
            pomFile.delete();
        }
    }

    boolean isLocal(ReleaseDTO instructions) {
        return instructions.type == ReleaseDTO.ReleaseType.LOCAL;
    }

    private Jar getSource(Tool tool, Processor context, String path) throws Exception {
        Jar jar = this.toJar(context, path);
        if (jar != null) {
            return jar;
        }
        return tool.doSource();
    }

    private Jar getJavadoc(Tool tool, Processor context, String path, Map<String, String> options) throws Exception {
        Jar jar = this.toJar(context, path);
        if (jar != null) {
            return jar;
        }
        return tool.doJavadoc(options);
    }

    private Jar toJar(Processor context, String path) {
        if (path == null) {
            return null;
        }
        File f = context.getFile(path);
        if (f.exists()) {
            return new Jar(path);
        }
        return null;
    }

    private void save(Release releaser, Revision revision, Jar jar, String classifier) throws Exception {
        String extension = IO.getExtension((String)jar.getName(), (String)"jar");
        File tmp = File.createTempFile(classifier, extension);
        try {
            jar.write(tmp);
            releaser.add(revision.archive(extension, classifier), tmp);
        }
        finally {
            tmp.delete();
        }
    }

    private ReleaseDTO getReleaseDTO(Processor context) {
        Attrs pom;
        Attrs sources;
        ReleaseDTO release = new ReleaseDTO();
        if (context == null) {
            return release;
        }
        Parameters p = new Parameters(context.getProperty("-maven-release"));
        if (p.containsKey("local")) {
            release.type = ReleaseDTO.ReleaseType.LOCAL;
        } else if (p.containsKey("remote")) {
            release.type = ReleaseDTO.ReleaseType.REMOTE;
        }
        p.remove("local");
        p.remove("remote");
        Attrs javadoc = p.remove("javadoc");
        if (javadoc != null) {
            release.javadoc.path = javadoc.get("path");
            release.javadoc.options = javadoc;
        }
        if ((sources = p.remove("sources")) != null) {
            release.sources.path = sources.get("path");
        }
        if ((pom = p.remove("pom")) != null) {
            release.pom.path = pom.get("path");
        }
        if (!p.isEmpty()) {
            this.reporter.warning("The -maven-release instruction contains unrecognized options: ", new Object[]{p});
        }
        return release;
    }

    private Resource getPomResource(Jar jar) {
        for (Map.Entry e : jar.getResources().entrySet()) {
            String path = (String)e.getKey();
            if (!path.startsWith("META-INF/maven/") || !path.endsWith("/pom.xml")) continue;
            return (Resource)e.getValue();
        }
        return null;
    }

    public File get(String bsn, Version version, Map<String, String> properties, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        this.init();
        Archive archive = this.getArchive(bsn, version);
        if (archive != null) {
            File file = this.storage.toLocalFile(archive);
            Promise<File> promise = this.storage.get(archive);
            promise = this.ensurePom(archive, promise);
            if (listeners.length == 0) {
                return (File)promise.getValue();
            }
            promise.onResolve(this.getResolveable(file, promise, listeners));
            return file;
        }
        return null;
    }

    private Promise<File> ensurePom(final Archive archive, Promise<File> promise) throws Exception {
        File pomFile;
        if (!archive.isPom() && !(pomFile = this.storage.toLocalFile(archive.getPomArchive())).exists()) {
            return promise.then((Success)new Success<File, File>(){

                public Promise<File> call(Promise<File> resolved) throws Exception {
                    return MavenBndRepository.this.storage.get(archive.getPomArchive());
                }
            }, new Failure(){

                public void fail(Promise<?> resolved) throws Exception {
                    resolved.getFailure().printStackTrace();
                }
            });
        }
        return promise;
    }

    public boolean canWrite() {
        return !this.configuration.readOnly();
    }

    public List<String> list(String pattern) throws Exception {
        this.init();
        Glob g = pattern == null ? null : new Glob(pattern);
        ArrayList<String> bsns = new ArrayList<String>();
        for (Program p : this.repoWatcher.getLocalPrograms()) {
            String ga = p.getCoordinate();
            if (g != null && !g.matcher((CharSequence)ga).matches()) continue;
            bsns.add(ga);
        }
        return bsns;
    }

    public SortedSet<Version> versions(String bsn) throws Exception {
        this.init();
        TreeSet<Version> versions = new TreeSet<Version>();
        Program program = Program.valueOf(bsn);
        if (program == null) {
            return versions;
        }
        for (Revision revision : this.storage.getRevisions(program)) {
            MavenVersion v = revision.version;
            Version osgi = v.getOSGiVersion();
            versions.add(osgi);
        }
        return versions;
    }

    public String getName() {
        this.init();
        return this.configuration.name(this.getLocation());
    }

    private synchronized void init() {
        try {
            if (this.inited) {
                return;
            }
            this.inited = true;
            this.localRepo = IO.getFile((String)this.configuration.local());
            HttpClient client = (HttpClient)this.registry.getPlugin(HttpClient.class);
            Executor executor = (Executor)this.registry.getPlugin(Executor.class);
            RemoteRepo release = this.configuration.releaseUrl() != null ? new RemoteRepo(this.localRepo, client, this.clean(this.configuration.releaseUrl())) : null;
            RemoteRepo snapshot = this.configuration.snapshotUrl() != null ? new RemoteRepo(this.localRepo, client, this.clean(this.configuration.snapshotUrl())) : null;
            this.storage = new MavenStorage(this.localRepo, this.getName(), release, snapshot, executor, this.reporter, this.getRefreshCallback());
            this.repoWatcher = new LocalRepoWatcher(this.localRepo.toPath(), new LocalRepoWatcher.ProgramsChanged(){

                @Override
                public boolean changed(Set<Program> added, Set<Program> removed) throws Exception {
                    return false;
                }
            }, this.reporter, Processor.getScheduledExecutor(), 5000L);
            this.repoWatcher.open();
        }
        catch (Exception e) {
            this.reporter.exception((Throwable)e, "Init for maven repo failed %s", new Object[]{this.configuration});
            throw new RuntimeException(e);
        }
    }

    private String clean(String url) {
        if (url.endsWith("/")) {
            return url;
        }
        return String.valueOf(url) + "/";
    }

    public String getLocation() {
        return this.configuration.releaseUrl() == null ? this.configuration.local() : this.configuration.releaseUrl();
    }

    public void setProperties(Map<String, String> map) throws Exception {
        this.configuration = (Configuration)Converter.cnv(Configuration.class, map);
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public void close() throws IOException {
        this.storage.close();
        if (this.repoWatcher != null) {
            this.repoWatcher.close();
        }
    }

    private Runnable getResolveable(final File file, final Promise<File> promise, final RepositoryPlugin.DownloadListener ... listeners) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (promise.getFailure() == null) {
                        this.doSuccess((Promise<File>)promise, listeners);
                    } else {
                        this.doFailure(file, (Promise<File>)promise, listeners);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            void doFailure(File file2, Promise<File> promise2, RepositoryPlugin.DownloadListener ... listeners2) {
                RepositoryPlugin.DownloadListener[] downloadListenerArray = listeners2;
                int n = listeners2.length;
                int n2 = 0;
                while (n2 < n) {
                    RepositoryPlugin.DownloadListener dl = downloadListenerArray[n2];
                    try {
                        dl.failure(file2, promise2.getFailure().getMessage());
                    }
                    catch (Exception e) {
                        MavenBndRepository.this.reporter.exception((Throwable)e, "Download listener failed in failure callback %s", new Object[]{dl});
                    }
                    ++n2;
                }
            }

            void doSuccess(Promise<File> promise2, RepositoryPlugin.DownloadListener ... listeners2) throws InvocationTargetException, InterruptedException {
                File file2 = (File)promise2.getValue();
                RepositoryPlugin.DownloadListener[] downloadListenerArray = listeners2;
                int n = listeners2.length;
                int n2 = 0;
                while (n2 < n) {
                    RepositoryPlugin.DownloadListener dl = downloadListenerArray[n2];
                    try {
                        dl.success(file2);
                    }
                    catch (Exception e) {
                        MavenBndRepository.this.reporter.exception((Throwable)e, "Download listener failed in success callback %s ", new Object[]{dl});
                    }
                    ++n2;
                }
            }
        };
    }

    private Archive getArchive(String bsn, Version version) throws Exception {
        String[] parts = bsn.split(":");
        if (parts.length == 2) {
            Program program = Program.valueOf(bsn);
            MavenVersion mavenVersion = this.matchVersions(program, version);
            if (mavenVersion == null) {
                return null;
            }
            bsn = String.valueOf(bsn) + ":" + mavenVersion;
        }
        return this.storage.getArchive(bsn);
    }

    private MavenVersion matchVersions(Program program, Version version) throws Exception {
        List<Revision> revisions = this.storage.getRevisions(program);
        for (Revision r : revisions) {
            if (!r.version.getOSGiVersion().equals((Object)version)) continue;
            return r.version;
        }
        return null;
    }

    private Callable<Boolean> getRefreshCallback() {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                for (RepositoryListenerPlugin rp : MavenBndRepository.this.registry.getPlugins(RepositoryListenerPlugin.class)) {
                    try {
                        rp.repositoryRefreshed((RepositoryPlugin)MavenBndRepository.this);
                    }
                    catch (Exception e) {
                        MavenBndRepository.this.reporter.exception((Throwable)e, "Updating listener plugin %s", new Object[]{rp});
                    }
                }
                return MavenBndRepository.this.ok;
            }
        };
    }

    public boolean refresh() throws Exception {
        this.repoWatcher.refresh();
        return true;
    }

    public File getRoot() throws Exception {
        return this.localRepo;
    }

    public static enum Classifiers {
        SOURCE,
        JAVADOC;

    }

    public static interface Configuration {
        public String releaseUrl();

        public String snapshotUrl();

        public String local();

        public Set<Classifiers> generate();

        public boolean readOnly();

        public String name(String var1);
    }
}

