/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.cashflow.AbstractDividend;
import org.jquantlib.util.Date;

public class FractionalDividend
extends AbstractDividend {
    protected double rate;
    protected double nominal;

    public FractionalDividend(double rate, Date date) {
        super(date);
        this.rate = rate;
    }

    public FractionalDividend(double rate, double nominal, Date date) {
        super(date);
        this.rate = rate;
        this.nominal = nominal;
    }

    @Override
    public double getAmount(double underlying) {
        return this.rate * underlying;
    }

    @Override
    public double getAmount() {
        if (this.nominal == 0.0) {
            throw new IllegalStateException("No nominal given!");
        }
        return this.rate * this.nominal;
    }
}

