/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import java.util.List;
import org.jquantlib.indexes.IndexManager;
import org.jquantlib.math.Closeness;
import org.jquantlib.time.Calendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;
import org.jquantlib.util.TimeSeriesDouble;

public abstract class Index
implements Observable {
    private Observable delegatedObservable = new DefaultObservable(this);

    public abstract String getName();

    public abstract Calendar getFixingCalendar();

    public abstract boolean isValidFixingDate(Date var1);

    public abstract double fixing(Date var1, boolean var2);

    public TimeSeriesDouble timeSeries() {
        return (TimeSeriesDouble)IndexManager.getInstance().get(this.getName());
    }

    public void addFixing(Date fixingDate, double fixing, boolean forceOverwrite) {
        this.addFixings(new Date[]{fixingDate}, new double[]{fixing}, forceOverwrite);
    }

    public void addFixings(TimeSeriesDouble t, boolean forceOverwrite) {
        this.addFixings(t.dates(), t.values(), forceOverwrite);
    }

    public void addFixings(Date[] dates, double[] values, boolean forceOverwrite) {
        String tag = this.getName();
        TimeSeriesDouble h = (TimeSeriesDouble)IndexManager.getInstance().get(tag);
        boolean noInvalidFixing = true;
        boolean noDuplicatedFixing = true;
        Date invalidDate = null;
        Date duplicatedDate = null;
        double nullValue = 0.0;
        double invalidValue = Double.NaN;
        double duplicatedValue = Double.NaN;
        for (int i = 0; i < dates.length; ++i) {
            boolean missingFixing;
            Date date = dates[i];
            Double value = values[i];
            boolean validFixing = this.isValidFixingDate(date);
            double currentValue = h.find(date);
            boolean bl = missingFixing = forceOverwrite || Closeness.isClose(currentValue, 0.0);
            if (validFixing) {
                if (missingFixing) {
                    h.add(date, value);
                    continue;
                }
                if (Closeness.isClose(currentValue, value)) continue;
                noDuplicatedFixing = false;
                duplicatedDate = date;
                duplicatedValue = value;
                continue;
            }
            noInvalidFixing = false;
            invalidDate = date;
            invalidValue = value;
        }
        IndexManager.getInstance().put(tag, h);
        if (!noInvalidFixing) {
            throw new IllegalStateException("At least one invalid fixing provided: " + invalidDate + ", " + invalidValue);
        }
        if (!noDuplicatedFixing) {
            throw new IllegalStateException("At least one duplicated fixing provided: " + duplicatedDate + ", " + duplicatedValue);
        }
    }

    public void clearFixings() {
        IndexManager.getInstance().clearHistory(this.getName());
    }

    @Override
    public void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }
}

