/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.math.interpolations.AbstractInterpolation2D;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.Interpolation2D;
import org.jquantlib.math.interpolations.Interpolator2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BicubicSplineInterpolation
extends AbstractInterpolation2D {
    private static final Logger logger = LoggerFactory.getLogger(BicubicSplineInterpolation.class);
    private final List<Interpolation> splines = new ArrayList<Interpolation>();

    private BicubicSplineInterpolation() {
    }

    public static Interpolator2D getInterpolator() {
        BicubicSplineInterpolation bicubicSplineInterpolation = new BicubicSplineInterpolation();
        return new BicubicSplineInterpolationImpl(bicubicSplineInterpolation);
    }

    @Override
    public void calculate() {
    }

    @Override
    public double evaluateImpl(double x, double y) {
        double[] section = new double[this.splines.size()];
        for (int i = 0; i < this.splines.size(); ++i) {
            section[i] = this.splines.get(i).evaluate(x, true);
        }
        return 1.0;
    }

    private static class BicubicSplineInterpolationImpl
    implements Interpolator2D {
        private BicubicSplineInterpolation delegate;

        public BicubicSplineInterpolationImpl(BicubicSplineInterpolation delegate) {
            this.delegate = delegate;
        }

        @Override
        public Interpolation2D interpolate(double[] x, double[] y, double[][] z) {
            this.delegate.vx = x;
            this.delegate.vy = y;
            this.delegate.mz = z;
            this.delegate.reload();
            return this.delegate;
        }
    }
}

