/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.lattices;

import org.jquantlib.lang.annotation.NonNegative;
import org.jquantlib.lang.annotation.Price;
import org.jquantlib.lang.annotation.Time;
import org.jquantlib.methods.lattices.BinomialTree;
import org.jquantlib.processes.StochasticProcess1D;

public class LeisenReimer
extends BinomialTree {
    protected double up;
    protected double down;
    protected double pu;
    protected double pd;

    public LeisenReimer(StochasticProcess1D process, @Time double end, @NonNegative int steps, @Price double strike) {
        super(process, end, steps);
        if (strike <= 0.0) {
            throw new IllegalArgumentException("strike must be positive");
        }
        int oddSteps = steps % 2 > 0 ? steps : steps + 1;
        double variance = process.variance(0.0, this.x0, end);
        double ermqdt = Math.exp(this.driftPerStep + 0.5 * variance / (double)oddSteps);
        double d2 = (Math.log(this.x0 / strike) + this.driftPerStep * (double)oddSteps) / Math.sqrt(variance);
        this.pu = this.PeizerPrattMethod2Inversion(d2, oddSteps);
        this.pd = 1.0 - this.pu;
        double pdash = this.PeizerPrattMethod2Inversion(d2 + Math.sqrt(variance), oddSteps);
        this.up = ermqdt * pdash / this.pu;
        this.down = (ermqdt - this.pu * this.up) / (1.0 - this.pu);
    }

    @Override
    public double underlying(int i, int index) {
        long j = (long)i - (long)index;
        double d = j;
        return this.x0 * Math.pow(this.down, d) * Math.pow(this.up, index);
    }

    @Override
    public double probability(int n, int m, int branch) {
        return branch == 1 ? this.pu : this.pd;
    }

    private double PeizerPrattMethod2Inversion(double z, int n) {
        if (n % 2 == 0) {
            throw new IllegalArgumentException("n must be an odd number");
        }
        double result = z / ((double)n + 0.3333333333333333 + 0.1 / ((double)n + 1.0));
        result *= result;
        result = Math.exp(-result * ((double)n + 0.16666666666666666));
        result = 0.5 + (double)(z > 0.0 ? 1 : -1) * Math.sqrt(0.25 * (1.0 - result));
        return result;
    }
}

