/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time;

import java.util.Formatter;
import java.util.Locale;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.TimeUnit;

public class Period {
    public static final Period ONE_YEAR_FORWARD = new Period(1, TimeUnit.YEARS);
    public static final Period ONE_YEAR_BACKWARD = new Period(-1, TimeUnit.YEARS);
    public static final Period ONE_MONTH_FORWARD = new Period(1, TimeUnit.MONTHS);
    public static final Period ONE_MONTH_BACKWARD = new Period(-1, TimeUnit.MONTHS);
    public static final Period ONE_DAY_FORWARD = new Period(1, TimeUnit.DAYS);
    public static final Period ONE_DAY_BACKWARD = new Period(-1, TimeUnit.DAYS);
    private int length;
    private TimeUnit units;

    public Period() {
        this.length = 0;
        this.units = TimeUnit.DAYS;
    }

    public Period(int length, TimeUnit units) {
        this.length = length;
        this.units = units;
    }

    public Period(Frequency f) {
        switch (f) {
            case ONCE: 
            case NO_FREQUENCY: {
                this.units = TimeUnit.DAYS;
                this.length = 0;
                break;
            }
            case ANNUAL: {
                this.units = TimeUnit.YEARS;
                this.length = 1;
                break;
            }
            case SEMI_ANNUAL: 
            case EVERY_FOURTH_DAY: 
            case QUARTERLY: 
            case BI_MONTHLY: 
            case MONTHLY: {
                this.units = TimeUnit.MONTHS;
                this.length = 12 / f.toInteger();
                break;
            }
            case BI_WEEKLY: 
            case WEEKLY: {
                this.units = TimeUnit.WEEKS;
                this.length = 52 / f.toInteger();
                break;
            }
            case DAILY: {
                this.units = TimeUnit.DAYS;
                this.length = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown frequency (" + f.toInteger());
            }
        }
    }

    public final int length() {
        return this.length;
    }

    public final TimeUnit units() {
        return this.units;
    }

    public final Frequency frequency() {
        int length = Math.abs(this.length);
        if (length == 0) {
            return Frequency.NO_FREQUENCY;
        }
        switch (this.units) {
            case YEARS: {
                if (length != 1) {
                    throw new IllegalArgumentException("cannot instantiate a Frequency from " + this);
                }
                return Frequency.ANNUAL;
            }
            case MONTHS: {
                if (12 % length != 0 || length > 12) {
                    throw new IllegalArgumentException("cannot instantiate a Frequency from " + this);
                }
                return Frequency.valueOf(12 / length);
            }
            case WEEKS: {
                if (length == 1) {
                    return Frequency.WEEKLY;
                }
                if (length == 2) {
                    return Frequency.BI_WEEKLY;
                }
                throw new IllegalArgumentException("cannot instantiate a Frequency from " + this);
            }
            case DAYS: {
                if (length != 1) {
                    throw new IllegalArgumentException("cannot instantiate a Frequency from " + this);
                }
                return Frequency.DAILY;
            }
        }
        throw new IllegalArgumentException("unknown time unit (" + (Object)((Object)this.units));
    }

    public Period minus() {
        return new Period(-this.length, this.units);
    }

    public Period times(int n) {
        return new Period(n * this.length, this.units);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + (this.units == null ? 0 : this.units.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Period other = (Period)obj;
        if (this.length != other.length) {
            return false;
        }
        return !(this.units == null ? other.units != null : !this.units.equals((Object)other.units));
    }

    public boolean eq(Period anotherPeriod) {
        return this.equals(anotherPeriod);
    }

    public boolean neq(Period anotherPeriod) {
        return !this.equals(anotherPeriod);
    }

    public boolean gt(Period anotherPeriod) {
        return anotherPeriod.lt(this);
    }

    public boolean le(Period anotherPeriod) {
        return !anotherPeriod.lt(this);
    }

    public boolean ge(Period anotherPeriod) {
        return !this.le(anotherPeriod);
    }

    public boolean lt(Period p2) {
        if (this.length == 0) {
            return p2.length > 0;
        }
        if (p2.length == 0) {
            return this.length < 0;
        }
        switch (this.units) {
            case DAYS: {
                switch (p2.units) {
                    case DAYS: {
                        return this.length < p2.length;
                    }
                    case WEEKS: {
                        return this.length < p2.length * 7;
                    }
                    case MONTHS: {
                        if (this.length < p2.length * 28) {
                            return true;
                        }
                        throw new IllegalArgumentException("undecidable comparison between periods");
                    }
                    case YEARS: {
                        return this.length < p2.length * 365;
                    }
                }
                throw new IllegalArgumentException("unknown units");
            }
            case WEEKS: {
                switch (p2.units) {
                    case DAYS: {
                        return this.length * 7 < p2.length;
                    }
                    case WEEKS: {
                        return this.length < p2.length;
                    }
                    case MONTHS: {
                        if (this.length * 7 < p2.length * 28) {
                            return true;
                        }
                        throw new IllegalArgumentException("undecidable comparison between periods");
                    }
                    case YEARS: {
                        if (this.length * 7 < p2.length * 365) {
                            return true;
                        }
                        throw new IllegalArgumentException("undecidable comparison between periods");
                    }
                }
                throw new IllegalArgumentException("unknown units");
            }
            case MONTHS: {
                switch (p2.units) {
                    case DAYS: {
                        if (this.length * 31 < p2.length) {
                            return true;
                        }
                        if (this.length != 0 && p2.length < 28) {
                            return false;
                        }
                        throw new IllegalArgumentException("undecidable comparison between periods");
                    }
                    case WEEKS: {
                        if (this.length * 31 < p2.length * 7) {
                            return true;
                        }
                        throw new IllegalArgumentException("undecidable comparison between periods");
                    }
                    case MONTHS: {
                        return this.length < p2.length;
                    }
                    case YEARS: {
                        return this.length < p2.length * 12;
                    }
                }
                throw new IllegalArgumentException("unknown units");
            }
            case YEARS: {
                switch (p2.units) {
                    case DAYS: {
                        if (this.length * 366 < p2.length) {
                            return true;
                        }
                        if (this.length != 0 && p2.length < 365) {
                            return false;
                        }
                        throw new IllegalArgumentException("undecidable comparison between periods");
                    }
                    case WEEKS: {
                        if (this.length * 366 < p2.length * 7) {
                            return true;
                        }
                        throw new IllegalArgumentException("undecidable comparison between periods");
                    }
                    case MONTHS: {
                        return this.length * 12 < p2.length;
                    }
                    case YEARS: {
                        return this.length < p2.length;
                    }
                }
                throw new IllegalArgumentException("unknown units");
            }
        }
        throw new IllegalArgumentException("unknown units");
    }

    public String toString() {
        return this.getLongFormat();
    }

    public String getLongFormat() {
        return this.getInternalLongFormat();
    }

    public String getShortFormat() {
        return this.getInternalShortFormat();
    }

    private String getInternalLongFormat() {
        String suffix = this.length == 1 ? "" : "s";
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%d %s%s", this.length, this.units.getLongFormat(), suffix);
        return sb.toString();
    }

    private String getInternalShortFormat() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%d%s", this.length, this.units.getShortFormat());
        return sb.toString();
    }
}

