/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.URL;
import netscape.application.AWTCompatibility;
import netscape.application.Application;
import netscape.application.BitmapObserver;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.Rect;
import netscape.application.SystemImages;
import netscape.application.Target;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class Bitmap
extends Image {
    java.awt.Image awtImage;
    BitmapObserver bitmapObserver;
    Target updateTarget;
    Rect updateRect;
    String name;
    String updateCommand;
    int imageNumber = Bitmap.application().nextBitmapNumber();
    boolean loaded = false;
    boolean valid = true;
    boolean transparent = true;
    boolean loadIncrementally;
    boolean added;
    boolean useStaticTracker = false;
    MediaTracker mediaTracker;
    static final int WIDTH = 0;
    static final int HEIGHT = 1;
    private static Class bitmapClass;
    static final String NAME_KEY = "name";
    static final String UPDATE_TARGET_KEY = "updateTarget";
    static final String UPDATE_COMMAND_KEY = "updateCommand";
    static final String TRANSPARENT_KEY = "transparent";
    static final String LOAD_INCREMENTALLY_KEY = "loadIncrementally";

    public static synchronized Bitmap bitmapNamed(String string, boolean bl, boolean bl2) {
        if (string == null || string.equals("")) {
            return null;
        }
        Application application = Bitmap.application();
        Bitmap bitmap = (Bitmap)application.bitmapByName.get(string);
        if (bitmap != null) {
            return bitmap;
        }
        bitmap = Bitmap.systemBitmapNamed(string);
        if (bitmap != null) {
            if (bl2) {
                application.bitmapByName.put(string, bitmap);
                bitmap.useStaticTracker = true;
            }
            bitmap.name = string;
            return bitmap;
        }
        URL uRL = application._appResources.urlForBitmapNamed(string);
        bitmap = Bitmap.bitmapFromURL(uRL);
        if (bitmap == null) {
            return null;
        }
        if (bl2) {
            application.bitmapByName.put(string, bitmap);
            bitmap.useStaticTracker = true;
        }
        bitmap.name = string;
        if (bl) {
            bitmap.startLoadingData();
        }
        return bitmap;
    }

    public static Bitmap bitmapNamed(String string, boolean bl) {
        return Bitmap.bitmapNamed(string, bl, true);
    }

    public static Bitmap bitmapNamed(String string) {
        return Bitmap.bitmapNamed(string, true, true);
    }

    public static Bitmap bitmapFromURL(URL uRL) {
        java.awt.Image image = AWTCompatibility.awtApplet().getImage(uRL);
        if (image == null) {
            return null;
        }
        Bitmap bitmap = new Bitmap(image);
        return bitmap;
    }

    public Graphics createGraphics() {
        return Graphics.newGraphics(this);
    }

    public Bitmap() {
    }

    public Bitmap(int n, int n2) {
        this();
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Invalid bitmap size: " + n + "x" + n2);
        }
        this.awtImage = AWTCompatibility.awtApplet().createImage(n, n2);
        this.setLoaded(true);
    }

    Bitmap(java.awt.Image image) {
        this();
        this.awtImage = image;
    }

    public Bitmap(int[] nArray, int n, int n2) {
        this(nArray, n, n2, 0, n);
    }

    public Bitmap(int[] nArray, int n, int n2, int n3, int n4) {
        this();
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray, n3, n4);
        this.awtImage = AWTCompatibility.awtApplet().createImage(memoryImageSource);
        this.setLoaded(true);
    }

    public boolean grabPixels(int[] nArray) {
        return this.grabPixels(nArray, 0, 0, this.width(), this.height(), 0, this.width());
    }

    public boolean grabPixels(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl;
        java.awt.Image image = AWTCompatibility.awtImageForBitmap(this);
        PixelGrabber pixelGrabber = new PixelGrabber(image, n, n2, n3, n4, nArray, n5, n6);
        try {
            bl = pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            bl = false;
        }
        return bl;
    }

    public String name() {
        return this.name;
    }

    BitmapObserver bitmapObserver() {
        if (this.bitmapObserver == null) {
            this.bitmapObserver = this.updateTarget != null ? new BitmapObserver(Bitmap.application(), this) : new BitmapObserver(null, this);
        }
        return this.bitmapObserver;
    }

    int getWidthOrHeight(int n) {
        BitmapObserver bitmapObserver;
        int n2 = -1;
        boolean bl = false;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid dimension request: " + n);
        }
        if (this.hasLoadedData()) {
            if (n == 0) {
                return this.awtImage.getWidth(null);
            }
            return this.awtImage.getHeight(null);
        }
        BitmapObserver bitmapObserver2 = bitmapObserver = this.bitmapObserver();
        synchronized (bitmapObserver2) {
            while (!bl) {
                if (n == 0) {
                    n2 = this.awtImage.getWidth(bitmapObserver);
                    n2 = this.awtImage.getWidth(bitmapObserver);
                } else {
                    n2 = this.awtImage.getHeight(bitmapObserver);
                    n2 = this.awtImage.getHeight(bitmapObserver);
                }
                if (n2 != -1 || !this.isValid()) break;
                if ((bitmapObserver.lastInfo & 0x40) != 0 || (bitmapObserver.lastInfo & 0x80) != 0) {
                    this.valid = false;
                    this.reportWhyInvalid();
                    this.setLoaded(true);
                    continue;
                }
                try {
                    bitmapObserver.wait();
                }
                catch (InterruptedException interruptedException) {}
                if ((bitmapObserver.lastInfo & 0x40) == 0 && (bitmapObserver.lastInfo & 0x80) == 0) continue;
                this.valid = false;
                this.reportWhyInvalid();
                this.setLoaded(true);
            }
        }
        return n2;
    }

    public int width() {
        return this.getWidthOrHeight(0);
    }

    public int height() {
        return this.getWidthOrHeight(1);
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void drawAt(Graphics graphics, int n, int n2) {
        graphics.drawBitmapAt(this, n, n2);
    }

    public void drawScaled(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawBitmapScaled(this, n, n2, n3, n4);
    }

    public void drawTiled(Graphics graphics, int n, int n2, int n3, int n4) {
        if (!this.isValid()) {
            System.err.println("Graphics.drawBitmapTiled() - Invalid bitmap: " + this.name());
            return;
        }
        super.drawTiled(graphics, n, n2, n3, n4);
    }

    boolean createScaledVersion(int n, int n2) {
        if (!this.isValid()) {
            return false;
        }
        Application application = Bitmap.application();
        BitmapObserver bitmapObserver = this.bitmapObserver();
        while (!application.applet.prepareImage(this.awtImage, n, n2, bitmapObserver)) {
            if (this.loadsIncrementally()) {
                return true;
            }
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    boolean createScaledVersion(float f, float f2) {
        return this.createScaledVersion((int)(f * (float)this.width()), (int)(f2 * (float)this.height()));
    }

    void startLoadingData() {
        MediaTracker mediaTracker = this.tracker();
        if (!this.added) {
            mediaTracker.addImage(this.awtImage, this.imageNumber);
            this.added = true;
        }
        mediaTracker.checkID(this.imageNumber, true);
    }

    public void loadData() {
        if (this.loaded) {
            return;
        }
        MediaTracker mediaTracker = this.tracker();
        while (!this.loaded) {
            try {
                this.startLoadingData();
                if (this.loadIncrementally) break;
                mediaTracker.waitForID(this.imageNumber);
                this.setLoaded(true);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Bitmap.loadData() - " + interruptedException);
            }
        }
        if (this.valid) {
            boolean bl = this.valid = !mediaTracker.isErrorID(this.imageNumber);
        }
        if (!this.valid) {
            this.reportWhyInvalid();
            this.setLoaded(true);
        }
    }

    void setLoaded(boolean bl) {
        this.loaded = bl;
        this.mediaTracker = null;
        this.bitmapObserver = null;
    }

    public boolean hasLoadedData() {
        return this.loaded;
    }

    public void setLoadsIncrementally(boolean bl) {
        this.loadIncrementally = bl;
    }

    public boolean loadsIncrementally() {
        return this.loadIncrementally;
    }

    public synchronized Rect updateRect() {
        Rect rect;
        if (this.updateRect == null) {
            rect = new Rect();
        } else {
            rect = this.updateRect;
            this.updateRect = null;
        }
        return rect;
    }

    public synchronized void setUpdateTarget(Target target) {
        this.updateTarget = target;
    }

    public synchronized Target updateTarget() {
        return this.updateTarget;
    }

    public synchronized void setUpdateCommand(String string) {
        this.updateCommand = string;
    }

    public synchronized String updateCommand() {
        return this.updateCommand;
    }

    void reportWhyInvalid() {
        String string = "";
        int n = this.tracker().statusID(this.imageNumber, false);
        if ((n & 2) != 0) {
            string = string + " ABORTED";
        } else if ((n & 8) != 0) {
            string = string + " COMPLETE";
        } else if ((n & 4) != 0) {
            string = string + " ERRORED";
        } else if ((n & 1) != 0) {
            string = string + " LOADING";
        }
        System.err.println("Invalid bitmap: " + this.name() + string);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void flush() {
        this.awtImage.flush();
    }

    public String toString() {
        if (this.name != null) {
            return "Bitmap(" + this.name + ")";
        }
        return super.toString();
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.Bitmap", 1);
        classInfo.addField(NAME_KEY, (byte)16);
        classInfo.addField(UPDATE_TARGET_KEY, (byte)18);
        classInfo.addField(UPDATE_COMMAND_KEY, (byte)16);
        classInfo.addField(TRANSPARENT_KEY, (byte)0);
        classInfo.addField(LOAD_INCREMENTALLY_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        if (this.name == null) {
            throw new CodingException("encoded Bitmaps must have a name");
        }
        encoder.encodeString(NAME_KEY, this.name);
        encoder.encodeObject(UPDATE_TARGET_KEY, (Codable)((Object)this.updateTarget));
        encoder.encodeString(UPDATE_COMMAND_KEY, this.updateCommand);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
        encoder.encodeBoolean(LOAD_INCREMENTALLY_KEY, this.loadIncrementally);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.name = decoder.decodeString(NAME_KEY);
        if (this.name == null) {
            throw new CodingException("encoded Bitmaps must have a name");
        }
        this.updateTarget = (Target)decoder.decodeObject(UPDATE_TARGET_KEY);
        this.updateCommand = decoder.decodeString(UPDATE_COMMAND_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
        this.loadIncrementally = decoder.decodeBoolean(LOAD_INCREMENTALLY_KEY);
        Bitmap bitmap = Bitmap.bitmapNamed(this.name);
        if (bitmap == null) {
            throw new CodingException("unable to find bitmap named: " + this.name);
        }
        if (this.getClass() == Bitmap.bitmapClass()) {
            decoder.replaceObject(bitmap);
            return;
        }
        this.awtImage = bitmap.awtImage;
    }

    private static Class bitmapClass() {
        if (bitmapClass == null) {
            bitmapClass = new Bitmap().getClass();
        }
        return bitmapClass;
    }

    private static Application application() {
        return Application.application();
    }

    private static Bitmap systemBitmapNamed(String string) {
        Bitmap bitmap = null;
        if (string == null) {
            return null;
        }
        if (!string.startsWith("netscape/application/")) {
            return null;
        }
        String string2 = string.substring("netscape/application/".length());
        if (string2.equals("RedGrad.gif")) {
            bitmap = SystemImages.redGrad();
        } else if (string2.equals("GreenGrad.gif")) {
            bitmap = SystemImages.greenGrad();
        } else if (string2.equals("BlueGrad.gif")) {
            bitmap = SystemImages.blueGrad();
        } else if (string2.equals("CheckMark.gif")) {
            bitmap = SystemImages.checkMark();
        } else if (string2.equals("CloseButton.gif")) {
            bitmap = SystemImages.closeButton();
        } else if (string2.equals("CloseButtonActive.gif")) {
            bitmap = SystemImages.closeButtonActive();
        } else if (string2.equals("ColorScrollKnob.gif")) {
            bitmap = SystemImages.colorScrollKnob();
        } else if (string2.equals("PopupKnob.gif")) {
            bitmap = SystemImages.popupKnob();
        } else if (string2.equals("PopupKnobH.gif")) {
            bitmap = SystemImages.popupKnobH();
        } else if (string2.equals("RadioButtonOff.gif")) {
            bitmap = SystemImages.radioButtonOff();
        } else if (string2.equals("RadioButtonOn.gif")) {
            bitmap = SystemImages.radioButtonOn();
        } else if (string2.equals("ResizeLeft.gif")) {
            bitmap = SystemImages.resizeLeft();
        } else if (string2.equals("ResizeRight.gif")) {
            bitmap = SystemImages.resizeRight();
        } else if (string2.equals("ScrollDownArrow.gif")) {
            bitmap = SystemImages.scrollDownArrow();
        } else if (string2.equals("ScrollDownArrowActive.gif")) {
            bitmap = SystemImages.scrollDownArrowActive();
        } else if (string2.equals("ScrollKnobH.gif")) {
            bitmap = SystemImages.scrollKnobH();
        } else if (string2.equals("ScrollKnobV.gif")) {
            bitmap = SystemImages.scrollKnobV();
        } else if (string2.equals("ScrollLeftArrow.gif")) {
            bitmap = SystemImages.scrollLeftArrow();
        } else if (string2.equals("ScrollLeftArrowActive.gif")) {
            bitmap = SystemImages.scrollLeftArrowActive();
        } else if (string2.equals("ScrollRightArrow.gif")) {
            bitmap = SystemImages.scrollRightArrow();
        } else if (string2.equals("ScrollRightArrowActive.gif")) {
            bitmap = SystemImages.scrollRightArrowActive();
        } else if (string2.equals("ScrollTrayBottom.gif")) {
            bitmap = SystemImages.scrollTrayBottom();
        } else if (string2.equals("ScrollTrayLeft.gif")) {
            bitmap = SystemImages.scrollTrayLeft();
        } else if (string2.equals("ScrollTrayRight.gif")) {
            bitmap = SystemImages.scrollTrayRight();
        } else if (string2.equals("ScrollTrayTop.gif")) {
            bitmap = SystemImages.scrollTrayTop();
        } else if (string2.equals("ScrollUpArrow.gif")) {
            bitmap = SystemImages.scrollUpArrow();
        } else if (string2.equals("ScrollUpArrowActive.gif")) {
            bitmap = SystemImages.scrollUpArrowActive();
        } else if (string2.equals("TitleBarLeft.gif")) {
            bitmap = SystemImages.titleBarLeft();
        } else if (string2.equals("TitleBarRight.gif")) {
            bitmap = SystemImages.titleBarRight();
        } else if (string2.equals("alertNotification.gif")) {
            bitmap = SystemImages.alertNotification();
        } else if (string2.equals("alertQuestion.gif")) {
            bitmap = SystemImages.alertQuestion();
        } else if (string2.equals("alertWarning.gif")) {
            bitmap = SystemImages.alertWarning();
        } else if (string2.equals("topLeftArrow.gif")) {
            bitmap = SystemImages.topLeftArrow();
        } else if (string2.equals("topRightArrow.gif")) {
            bitmap = SystemImages.topRightArrow();
        } else if (string2.equals("bottomRightArrow.gif")) {
            bitmap = SystemImages.bottomRightArrow();
        } else if (string2.equals("bottomLeftArrow.gif")) {
            bitmap = SystemImages.bottomLeftArrow();
        }
        return bitmap;
    }

    public Image imageWithName(String string) {
        return Bitmap.bitmapNamed(string);
    }

    synchronized void unionWithUpdateRect(int n, int n2, int n3, int n4) {
        if (this.updateRect == null) {
            this.updateRect = new Rect(n, n2, n3, n4);
            return;
        }
        this.updateRect.unionWith(n, n2, n3, n4);
    }

    private MediaTracker tracker() {
        if (this.mediaTracker == null) {
            this.mediaTracker = this.useStaticTracker ? Application.application().mediaTracker() : new MediaTracker(AWTCompatibility.awtApplet());
        }
        return this.mediaTracker;
    }
}

