/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import netscape.application.AWTCompatibility;
import netscape.application.Application;
import netscape.application.ApplicationObserver;
import netscape.application.Event;
import netscape.application.EventLoop;
import netscape.application.FoundationDialog;
import netscape.application.FoundationFrame;
import netscape.application.FoundationPanel;
import netscape.application.FoundationWindow;
import netscape.application.Menu;
import netscape.application.MenuView;
import netscape.application.ModalDialogManager;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Size;
import netscape.application.View;
import netscape.application.Window;
import netscape.application.WindowInvalidationAgent;
import netscape.application.WindowOwner;
import netscape.util.InconsistencyException;

public class ExternalWindow
implements Window,
ApplicationObserver {
    java.awt.Window awtWindow;
    private FoundationPanel panel;
    private WindowOwner owner;
    private int type;
    private Size minimumSize;
    private String title;
    private Rect bounds;
    private boolean resizable = true;
    private boolean visible = false;
    private boolean hideOnPause = true;
    private boolean showOnResume = false;
    private boolean containsDocument = false;
    private boolean waitingForInvalidation = false;
    Menu menu;
    MenuView menuView;
    static final String AWTWINDOW_KEY = "awtWindow";
    static final String PANEL_KEY = "panel";
    static final String OWNER_KEY = "owner";
    static final String TYPE_KEY = "type";
    static final String MINSIZE_KEY = "minimumSize";
    static final String MENU_KEY = "menu";
    static final String HIDEONPAUSE_KEY = "hideOnPause";
    static final String CONTAINS_DOCUMENT_KEY = "containsDocument";

    public ExternalWindow() {
        this(1);
    }

    private Frame firstRootViewParentFrame() {
        RootView rootView;
        Application application = Application.application();
        if (application != null && (rootView = application.firstRootView()) != null) {
            FoundationPanel foundationPanel = rootView.panel();
            Container container = foundationPanel.getParent();
            while (container != null && !(container instanceof Frame)) {
                container = container.getParent();
            }
            if (container != null) {
                return (Frame)container;
            }
        }
        return this.appletParentFrame();
    }

    private Frame appletParentFrame() {
        Container container;
        Applet applet = AWTCompatibility.awtApplet();
        if (applet != null) {
            container = applet.getParent();
            while (container != null && !(container instanceof Frame)) {
                container = container.getParent();
            }
        } else {
            return null;
        }
        return (Frame)container;
    }

    private synchronized void validateAWTWindow(int n, boolean bl) {
        if (this.waitingForInvalidation) {
            this.waitingForInvalidation = false;
        }
        if (this.awtWindow == null) {
            Application.application();
            this.panel.rootView();
            if (bl) {
                FoundationDialog foundationDialog = this.createDialog();
                foundationDialog.setExternalWindow(this);
                this.awtWindow = foundationDialog;
            } else if (n == 1) {
                FoundationFrame foundationFrame = this.createFrame();
                foundationFrame.setExternalWindow(this);
                this.awtWindow = foundationFrame;
            } else {
                FoundationWindow foundationWindow = this.createWindow();
                foundationWindow.setExternalWindow(this);
                this.awtWindow = foundationWindow;
            }
            if (this.awtWindow instanceof Dialog) {
                ((Dialog)this.awtWindow).setResizable(this.resizable);
            } else if (this.awtWindow instanceof FoundationFrame) {
                ((FoundationFrame)this.awtWindow).setResizable(this.resizable);
            }
            this.awtWindow.addNotify();
            this.awtWindow.add(this.panel);
            ((Component)this.awtWindow).reshape(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            this.awtWindow.layout();
            if (n == 1) {
                if (this.awtWindow instanceof Dialog) {
                    ((Dialog)this.awtWindow).setTitle(this.title);
                } else {
                    ((FoundationFrame)this.awtWindow).setTitle(this.title);
                }
            }
            if (this.menu != null) {
                ((FoundationFrame)this.awtWindow).setMenuBar(this.menu.awtMenuBar());
            }
        }
    }

    synchronized void invalidateAWTWindow() {
        if (this.waitingForInvalidation) {
            this._invalidateAWTWindow();
        }
        this.waitingForInvalidation = false;
    }

    void _invalidateAWTWindow() {
        if (this.awtWindow != null) {
            this.bounds = this.bounds();
            this.awtWindow.remove(this.panel);
            this.awtWindow.dispose();
            this.awtWindow = null;
        }
    }

    public ExternalWindow(int n) {
        Application.application();
        this.title = "";
        this.type = n;
        this.panel = this.createPanel();
        this.bounds = new Rect(0, 0, 0, 0);
        this.setBounds(0, 0, 150, 150);
        Application.application().addObserver(this);
    }

    public void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        this.title = string;
        if (this.awtWindow != null && this.type == 1) {
            if (this.awtWindow instanceof Dialog) {
                ((Dialog)this.awtWindow).setTitle(this.title);
                return;
            }
            ((FoundationFrame)this.awtWindow).setTitle(this.title);
        }
    }

    public String title() {
        return this.title;
    }

    public void show() {
        this.validateAWTWindow(this.type, false);
        if (this.owner == null || this.owner.windowWillShow(this)) {
            this.awtWindow.show();
            this.panel.rootView.setVisible(true);
            this.visible = true;
            this.showOnResume = false;
            this.awtWindow.toFront();
            if (this.owner != null) {
                this.owner.windowDidShow(this);
            }
        }
    }

    public void showModally() {
        Application application = Application.application();
        EventLoop eventLoop = Application.application().eventLoop();
        if (this.type == 0) {
            throw new InconsistencyException("Cannot run blank windows modally");
        }
        if (this.owner == null || this.owner.windowWillShow(this)) {
            this.validateAWTWindow(this.type, true);
            ModalDialogManager modalDialogManager = new ModalDialogManager((Dialog)this.awtWindow);
            modalDialogManager.show();
            this.showOnResume = false;
            this.panel.rootView.setVisible(true);
            this.visible = true;
            if (this.owner != null) {
                this.owner.windowDidShow(this);
            }
            application.beginModalSessionForView(this.rootView());
            application.drawAllDirtyViews();
            while (this.isVisible()) {
                Event event = eventLoop.getNextEvent();
                try {
                    eventLoop.processEvent(event);
                }
                catch (Exception exception) {
                    System.err.println("Uncaught Exception.");
                    exception.printStackTrace(System.err);
                    System.err.println("Restarting modal EventLoop.");
                }
            }
            application.endModalSessionForView(this.rootView());
        }
    }

    public void hide() {
        if (this.awtWindow == null) {
            return;
        }
        if (this.owner == null || this.owner.windowWillHide(this)) {
            if (this.containsDocument() && this.isCurrentDocument()) {
                Application.application().chooseNextCurrentDocumentWindow(this);
            }
            ((Component)this.awtWindow).hide();
            this.visible = false;
            this.panel.rootView.setVisible(false);
            this.showOnResume = false;
            if (this.owner != null) {
                this.owner.windowDidHide(this);
            }
            WindowInvalidationAgent windowInvalidationAgent = new WindowInvalidationAgent(this);
            this.waitingForInvalidation = true;
            windowInvalidationAgent.run();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void dispose() {
        RootView rootView = this.rootView();
        Application application = rootView.application();
        if (this.containsDocument() && this.isCurrentDocument()) {
            application.chooseNextCurrentDocumentWindow(this);
        }
        this.visible = false;
        this._invalidateAWTWindow();
        application.removeObserver(this);
        application.removeRootView(rootView);
        this.panel.rootView.setVisible(false);
        this.panel.rootView = null;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
        if (!this.menu.isTopLevel()) {
            throw new InconsistencyException("menu must be main menu");
        }
        this.menu.setApplication(this.rootView().application());
        MenuBar menuBar = this.menu.awtMenuBar();
        if (this.awtWindow != null) {
            ((FoundationFrame)this.awtWindow).setMenuBar(menuBar);
        }
    }

    public Menu menu() {
        return this.menu;
    }

    public void setMenuView(MenuView menuView) {
        if (menuView != null && menuView == this.menuView) {
            return;
        }
        if (this.menuView != null) {
            this.menuView.removeFromSuperview();
        }
        this.menuView = menuView;
        int n = this.rootView().bounds.x;
        int n2 = this.rootView().bounds.y;
        int n3 = this.rootView().bounds.width;
        int n4 = this.menuView.height();
        this.menuView.setBounds(n, n2, n3, n4);
        this.addSubview(this.menuView);
    }

    public MenuView menuView() {
        return this.menuView;
    }

    public RootView rootView() {
        return this.panel.rootView;
    }

    Application application() {
        return Application.application();
    }

    public void setOwner(WindowOwner windowOwner) {
        this.owner = windowOwner;
    }

    public WindowOwner owner() {
        return this.owner;
    }

    void didBecomeMain() {
        if (this.owner != null) {
            this.owner.windowDidBecomeMain(this);
        }
        if (this.containsDocument()) {
            Application.application().makeCurrentDocumentWindow(this);
        }
    }

    void didResignMain() {
        if (this.owner != null) {
            this.owner.windowDidResignMain(this);
        }
    }

    public Size contentSize() {
        RootView rootView = this.rootView();
        if (rootView == null) {
            return null;
        }
        return new Size(rootView.bounds.width, rootView.bounds.height);
    }

    public void addSubview(View view) {
        RootView rootView = this.rootView();
        if (rootView != null) {
            rootView.addSubview(view);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (this.owner != null && (this.bounds.width != n3 || this.bounds.height != n4)) {
            Size size = new Size(n3 - this.bounds.width, n4 - this.bounds.height);
            this.owner.windowWillSizeBy(this, size);
            n3 = this.bounds.width + size.width;
            n4 = this.bounds.height + size.height;
        }
        if (this.bounds.x != n || this.bounds.y != n2 || this.bounds.width != n3 || this.bounds.height != n4) {
            if (this.bounds.width != n3 || this.bounds.height != n4) {
                bl = true;
            }
            this.bounds.setBounds(n, n2, n3, n4);
            if (this.awtWindow != null) {
                ((Component)this.awtWindow).reshape(n, n2, n3, n4);
                Rectangle rectangle = this.awtWindow.bounds();
                this.bounds.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.awtWindow.layout();
            }
        }
        if (bl && this.awtWindow == null) {
            this.validateAWTWindow(this.type, false);
            this._invalidateAWTWindow();
        }
    }

    void validateBounds() {
        if (this.awtWindow != null) {
            Point point = this.awtWindow.location();
            Dimension dimension = this.awtWindow.size();
            Rect rect = new Rect(point.x, point.y, dimension.width, dimension.height);
            if (!rect.equals(this.bounds)) {
                Size size = new Size(rect.width - this.bounds.width, rect.height - this.bounds.height);
                if (this.owner != null) {
                    this.owner.windowWillSizeBy(this, size);
                }
                this.bounds.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    public void setBounds(Rect rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void sizeTo(int n, int n2) {
        this.setBounds(this.bounds.x, this.bounds.y, n, n2);
    }

    public void sizeBy(int n, int n2) {
        this.setBounds(this.bounds.x, this.bounds.y, this.bounds.width + n, this.bounds.height + n2);
    }

    public void moveBy(int n, int n2) {
        this.setBounds(this.bounds.x + n, this.bounds.y + n2, this.bounds.width, this.bounds.height);
    }

    public void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rect rect = new Rect(this.bounds());
        rect.x = (int)Math.floor((double)(dimension.width - rect.width) / 2.0);
        rect.y = (int)Math.floor((double)(dimension.height - rect.height) / 2.0);
        this.setBounds(rect);
    }

    public void moveTo(int n, int n2) {
        this.setBounds(n, n2, this.bounds.width, this.bounds.height);
    }

    public Size windowSizeForContentSize(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = this.awtWindow != null;
        if (!bl) {
            this.validateAWTWindow(this.type, false);
        }
        Insets insets = this.awtWindow.insets();
        if (!bl) {
            this._invalidateAWTWindow();
        }
        return new Size(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    public View viewForMouse(int n, int n2) {
        return this.rootView().viewForMouse(n, n2);
    }

    public void setMinSize(int n, int n2) {
        this.minimumSize = new Size(n, n2);
    }

    public Size minSize() {
        return this.minimumSize;
    }

    public Rect bounds() {
        if (this.awtWindow != null) {
            Point point = this.awtWindow.location();
            Dimension dimension = this.awtWindow.size();
            return new Rect(point.x, point.y, dimension.width, dimension.height);
        }
        return new Rect(this.bounds);
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
        if (this.awtWindow != null) {
            throw new InconsistencyException("Cannot call setResizable on a visible external window");
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public FoundationPanel panel() {
        return this.panel;
    }

    public void setContainsDocument(boolean bl) {
        this.containsDocument = bl;
        if (!bl && Application.application().currentDocumentWindow() == this) {
            Application.application().chooseNextCurrentDocumentWindow(this);
            return;
        }
        if (bl && Application.application().firstRootView() == this.rootView()) {
            Application.application().makeCurrentDocumentWindow(this);
        }
    }

    public boolean containsDocument() {
        return this.containsDocument;
    }

    public void didBecomeCurrentDocument() {
    }

    public void didResignCurrentDocument() {
    }

    public boolean isCurrentDocument() {
        return Application.application().currentDocumentWindow() == this;
    }

    protected FoundationDialog createDialog() {
        return new FoundationDialog(this.firstRootViewParentFrame(), true);
    }

    protected FoundationFrame createFrame() {
        return new FoundationFrame();
    }

    protected FoundationWindow createWindow() {
        return new FoundationWindow(this.appletParentFrame());
    }

    protected FoundationPanel createPanel() {
        return new FoundationPanel();
    }

    public void applicationDidStart(Application application) {
    }

    public void applicationDidStop(Application application) {
        this.dispose();
    }

    public void focusDidChange(Application application, View view) {
    }

    public void currentDocumentDidChange(Application application, Window window) {
    }

    public void applicationDidPause(Application application) {
        if (this.hideOnPause && this.visible) {
            this.hide();
            this.showOnResume = true;
        }
    }

    public void applicationDidResume(Application application) {
        if (this.showOnResume) {
            this.show();
        }
    }

    public void setHidesWhenPaused(boolean bl) {
        this.hideOnPause = bl;
    }

    public boolean hidesWhenPaused() {
        return this.hideOnPause;
    }

    public void performCommand(String string, Object object) {
        if ("show".equals(string)) {
            this.show();
            return;
        }
        if ("hide".equals(string)) {
            this.hide();
            return;
        }
        throw new NoSuchMethodError("unknown command: " + string);
    }

    public void moveToFront() {
        if (!this.isVisible()) {
            return;
        }
        this.awtWindow.toFront();
    }

    public void moveToBack() {
        if (!this.isVisible()) {
            return;
        }
        this.awtWindow.toBack();
    }
}

