/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import netscape.application.Application;
import netscape.application.FastStringBuffer;
import netscape.application.FoundationApplet;
import netscape.application.HTMLElement;
import netscape.application.HTMLParsingException;
import netscape.application.HTMLParsingRules;
import netscape.application.HTMLTokenGenerator;
import netscape.util.Hashtable;
import netscape.util.Vector;

public class HTMLParser
extends FilterInputStream {
    private static final String[] specialChars = new String[]{"lt", "<", "gt", ">", "amp", "&", "quot", "\"", "nbsp", "\u00a0", "iexcl", "\u00a1", "cent", "\u00a2", "pound", "\u00a3", "curren", "\u00a4", "yen", "\u00a5", "brvbar", "\u00a6", "sect", "\u00a7", "uml", "\u00a8", "copy", "\u00a9", "ordf", "\u00aa", "laquo", "\u00ab", "not", "\u00ac", "shy", "\u00ad", "reg", "\u00ae", "macr", "\u00af", "deg", "\u00b0", "plusmn", "\u00b1", "sup2", "\u00b2", "sup3", "\u00b3", "acute", "\u00b4", "micro", "\u00b5", "para", "\u00b6", "middot", "\u00b7", "cedil", "\u00b8", "sup1", "\u00b9", "ordm", "\u00ba", "raquo", "\u00bb", "frac14", "\u00bc", "frac12", "\u00bd", "frac34", "\u00be", "iquest", "\u00bf", "Agrave", "\u00c0", "Aacute", "\u00c1", "Acirc", "\u00c2", "Atilde", "\u00c3", "Auml", "\u00c4", "Aring", "\u00c5", "AElig", "\u00c6", "Ccedil", "\u00c7", "Egrave", "\u00c8", "Eacute", "\u00c9", "Ecirc", "\u00ca", "Euml", "\u00cb", "Igrave", "\u00cc", "Iacute", "\u00cd", "Icirc", "\u00ce", "Iuml", "\u00cf", "ETH", "\u00d0", "Ntilde", "\u00d1", "Ograve", "\u00d2", "Oacute", "\u00d3", "Ocirc", "\u00d4", "Otilde", "\u00d5", "Ouml", "\u00d6", "times", "\u00d7", "Oslash", "\u00d8", "Ugrave", "\u00d9", "Uacute", "\u00da", "Ucirc", "\u00db", "Uuml", "\u00dc", "Yacute", "\u00dd", "THORN", "\u00de", "szlig", "\u00df", "agrave", "\u00e0", "aacute", "\u00e1", "acirc", "\u00e2", "atilde", "\u00e3", "auml", "\u00e4", "aring", "\u00e5", "aelig", "\u00e6", "ccedil", "\u00e7", "egrave", "\u00e8", "eacute", "\u00e9", "ecirc", "\u00ea", "euml", "\u00eb", "igrave", "\u00ec", "iacute", "\u00ed", "icirc", "\u00ee", "iuml", "\u00ef", "eth", "\u00f0", "ntilde", "\u00f1", "ograve", "\u00f2", "oacute", "\u00f3", "ocirc", "\u00f4", "otilde", "\u00f5", "ouml", "\u00f6", "divide", "\u00f7", "oslash", "\u00f8", "ugrave", "\u00f9", "uacute", "\u00fa", "ucirc", "\u00fb", "uuml", "\u00fc", "yacute", "\u00fd", "thorn", "\u00fe", "yuml", "\u00ff", "ensp", " ", "emsp", " ", "endash", "-", "emdash", "-"};
    private HTMLTokenGenerator tokenGenerator;
    private HTMLParsingRules rules;
    private Class defaultContainerClass;
    private Class defaultMarkerClass;
    private boolean throwsException = false;
    private FoundationApplet applet;

    public HTMLParser(InputStream inputStream) {
        this(inputStream, new HTMLParsingRules());
    }

    public HTMLParser(InputStream inputStream, HTMLParsingRules hTMLParsingRules) {
        super(inputStream);
        this.rules = hTMLParsingRules;
        this.tokenGenerator = new HTMLTokenGenerator(inputStream);
    }

    public void setThrowsExceptionOnHTMLError(boolean bl) {
        this.throwsException = bl;
    }

    public boolean throwsExceptionOnHTMLError() {
        return this.throwsException;
    }

    public HTMLElement nextHTMLElement() throws IOException, HTMLParsingException, InstantiationException, IllegalAccessException {
        while (this.tokenGenerator.hasMoreTokens()) {
            HTMLElement hTMLElement = this.parseNextHTMLElement(true, true, null);
            if (hTMLElement == null) continue;
            return hTMLElement;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Hashtable hashtableForAttributeString(String var0) throws HTMLParsingException {
        var1_1 = new Hashtable();
        var6_2 = new FastStringBuffer();
        if (var0 == null) {
            return var1_1;
        }
        var3_3 = var0.length();
        var2_4 = 0;
        ** GOTO lbl33
        {
            ++var2_4;
            do {
                if (var2_4 < var3_3 && HTMLParser.isSpace(var0.charAt(var2_4))) continue block0;
                if (var2_4 == var3_3) break block0;
                var6_2.truncateToLength(0);
                var7_7 = HTMLParser.parseKeyOrValue(var0, var2_4, var6_2);
                if (var7_7 == 0) {
                    throw new HTMLParsingException("Error while parsing attributes " + var0, 0);
                }
                var4_5 = HTMLParser.filterKeyOrValue(var6_2);
                var4_5 = var4_5.toUpperCase();
                var2_4 += var7_7;
                if (!var4_5.equals("")) ** GOTO lbl22
                continue;
lbl-1000:
                // 1 sources

                {
                    ++var2_4;
lbl22:
                    // 2 sources

                    ** while (var2_4 < var3_3 && HTMLParser.isSpace((char)var0.charAt((int)var2_4)))
                }
lbl23:
                // 1 sources

                if (var2_4 < var3_3 && var0.charAt(var2_4) == '=') {
                    var6_2.truncateToLength(0);
                    var7_7 = HTMLParser.parseKeyOrValue(var0, ++var2_4, var6_2);
                    var5_6 = HTMLParser.filterKeyOrValue(var6_2);
                    var2_4 += var7_7;
                    var1_1.put(var4_5, var5_6);
                    continue;
                }
                var1_1.put(var4_5, "");
lbl33:
                // 4 sources

            } while (var2_4 < var3_3);
        }
        return var1_1;
    }

    public void reportSyntaxError(String string) throws HTMLParsingException {
        if (this.throwsException) {
            throw new HTMLParsingException(string, this.tokenGenerator.lineForLastToken());
        }
    }

    public void setClassForMarker(Class clazz, String string) {
        this.rules.setClassNameForMarker(clazz.getName(), string);
    }

    private final char unicodeCharForBytes(String string) {
        String string2 = string;
        if (string2.length() > 0 && string2.charAt(0) == '#') {
            return (char)Integer.parseInt(string2.substring(1, string2.length()));
        }
        int n = 0;
        int n2 = specialChars.length;
        while (n < n2) {
            if (specialChars[n].equals(string2)) {
                return specialChars[n + 1].charAt(0);
            }
            n += 2;
        }
        return '\u0000';
    }

    private final int convertSpecialCharacter(String string, int n, FastStringBuffer fastStringBuffer) {
        int n2 = string.length();
        if (n + 1 < n2) {
            int n3;
            int n4 = n3 = n + 1;
            char c = string.charAt(n4);
            while (n4 < n2 && c != ';' && c != ' ' && c != '\n' && c != '\t') {
                c = ++n4 < n2 ? string.charAt(n4) : (char)'\u0000';
            }
            if (n4 > n3) {
                String string2 = string.substring(n3, n3 + (n4 - n3));
                char c2 = this.unicodeCharForBytes(string2);
                if (c2 != '\u0000' && c2 != '\b') {
                    fastStringBuffer.append(c2);
                }
                if (n4 < n2 && string.charAt(n4) == ';') {
                    return string2.length() + 2;
                }
                return string2.length() + 1;
            }
        }
        return 0;
    }

    private final String filterHTMLString(String string, boolean bl, boolean bl2) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (bl && (c == ' ' || c == '\t' || c == '\n')) {
                if ((bl4 || (!bl2 || c != '\t' && c != '\n') && (bl2 || c != '\t' && c != '\n' && c != ' ')) && !bl3) {
                    bl3 = true;
                    fastStringBuffer.append(' ');
                }
            } else if (c == '&') {
                int n3 = this.convertSpecialCharacter(string, n, fastStringBuffer);
                if (n3 > 0) {
                    n += n3 - 1;
                }
                bl3 = false;
                bl4 = true;
            } else if (c == '\n' || c == '\t' || c >= ' ' && c <= '~') {
                bl3 = false;
                bl4 = true;
                fastStringBuffer.append(c);
            }
            ++n;
        }
        if (fastStringBuffer.length() > 0) {
            return fastStringBuffer.toString();
        }
        return null;
    }

    private Class classForMarker(String string) {
        String string2 = this.rules.classNameForMarker(string);
        if (string2 != null) {
            Class clazz;
            try {
                Application application = Application.application();
                clazz = application != null ? application.classForName(string2) : Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("" + classNotFoundException);
                clazz = null;
            }
            return clazz;
        }
        return null;
    }

    private final HTMLElement parseNextHTMLElement(boolean bl, boolean bl2, String string) throws IOException, HTMLParsingException, InstantiationException, IllegalAccessException {
        HTMLElement hTMLElement = null;
        int n = this.tokenGenerator.nextToken();
        switch (n) {
            case 1: {
                Class clazz = this.classForMarker("IFCSTRING");
                if (clazz == null) break;
                String string2 = this.tokenGenerator.stringForLastToken();
                if ((string2 = this.filterHTMLString(string2, bl, bl2)) == null) break;
                hTMLElement = (HTMLElement)clazz.newInstance();
                hTMLElement.setMarker("IFCSTRING");
                hTMLElement.setString(string2);
                return hTMLElement;
            }
            case 2: {
                String string3 = this.tokenGenerator.stringForLastToken();
                Hashtable hashtable = this.rules.rulesForMarker(string3);
                Class clazz = this.classForMarker(string3);
                if (clazz == null) break;
                if (this.rules.isContainer(hashtable)) {
                    Vector vector = null;
                    Vector vector2 = null;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    hTMLElement = (HTMLElement)clazz.newInstance();
                    hTMLElement.setMarker(string3);
                    hTMLElement.setAttributes(this.tokenGenerator.attributesForLastToken());
                    Object[] objectArray = new Object[2];
                    int n2 = 0;
                    if (hashtable != null) {
                        vector = (Vector)hashtable.get("BeginTermination");
                        vector2 = (Vector)hashtable.get("EndTermination");
                    }
                    while (this.tokenGenerator.hasMoreTokens()) {
                        Object[] objectArray2;
                        n = this.tokenGenerator.peekNextToken();
                        if (n == 3) {
                            objectArray2 = this.tokenGenerator.stringForLastToken();
                            if (string3.equals(objectArray2)) {
                                this.tokenGenerator.nextToken();
                                bl3 = true;
                                break;
                            }
                            if (vector2 != null && vector2.indexOf(objectArray2) != -1) {
                                bl3 = true;
                                break;
                            }
                            if (this.classForMarker((String)objectArray2) != null) {
                                this.reportSyntaxError("Unexcpected closing " + (String)objectArray2 + " while parsing contents for " + string3);
                                bl3 = true;
                                break;
                            }
                        } else if (n == 2 && vector != null && vector.indexOf(this.tokenGenerator.stringForLastToken()) != -1) {
                            bl3 = true;
                            break;
                        }
                        HTMLElement hTMLElement2 = this.rules.shouldFilterStringsForChildren(hashtable) && bl ? this.parseNextHTMLElement(true, bl4, string3) : this.parseNextHTMLElement(false, bl4, string3);
                        bl4 = true;
                        if (hTMLElement2 == null) {
                            if (this.tokenGenerator.hasMoreTokens()) continue;
                            this.reportSyntaxError("Unterminated marker " + string3);
                            break;
                        }
                        objectArray[n2++] = hTMLElement2;
                        if (n2 != objectArray.length) continue;
                        objectArray2 = new Object[objectArray.length * 2];
                        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
                        objectArray = objectArray2;
                    }
                    if (n2 > 0) {
                        Object[] objectArray3 = new Object[n2];
                        System.arraycopy(objectArray, 0, objectArray3, 0, n2);
                        hTMLElement.setChildren(objectArray3);
                    } else {
                        hTMLElement.setChildren(null);
                    }
                    if (!bl3) {
                        this.reportSyntaxError("No end found for marker " + string3);
                    }
                    return hTMLElement;
                }
                hTMLElement = (HTMLElement)clazz.newInstance();
                hTMLElement.setMarker(string3);
                hTMLElement.setAttributes(this.tokenGenerator.attributesForLastToken());
                return hTMLElement;
            }
            case 4: {
                Class clazz = this.classForMarker("IFCCOMMENT");
                if (clazz == null) break;
                String string4 = this.tokenGenerator.stringForLastToken();
                hTMLElement = (HTMLElement)clazz.newInstance();
                hTMLElement.setMarker("IFCCOMMENT");
                hTMLElement.setString(string4);
                return hTMLElement;
            }
            case 3: {
                String string5 = this.tokenGenerator.stringForLastToken();
                Class clazz = this.classForMarker(string5);
                if (clazz == null || this.rules.shouldIgnoreEnd(this.rules.rulesForMarker(string5))) break;
                this.reportSyntaxError("Unexpected closing " + string5 + " while parsing contents for marker " + string);
                break;
            }
            default: {
                this.reportSyntaxError("Unexpected statement");
            }
        }
        return null;
    }

    private static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    private static int parseKeyOrValue(String string, int n, FastStringBuffer fastStringBuffer) {
        int n2 = n;
        int n3 = string.length();
        char c = '\u0000';
        while (n2 < n3 && HTMLParser.isSpace(string.charAt(n2))) {
            ++n2;
        }
        if (n2 == n3) {
            return 0;
        }
        int n4 = n2;
        if (string.charAt(n4) == '\'' || string.charAt(n4) == '\"') {
            c = string.charAt(n4);
        }
        do {
            fastStringBuffer.append(string.charAt(n4));
        } while (++n4 < n3 && (c == '\u0000' && !HTMLParser.isSpace(string.charAt(n4)) && string.charAt(n4) != '=' || c != '\u0000' && string.charAt(n4) != c));
        if (n4 < n3 && string.charAt(n4) == c) {
            fastStringBuffer.append(string.charAt(n4));
            ++n4;
        }
        return n4 - n2;
    }

    private static String filterKeyOrValue(FastStringBuffer fastStringBuffer) {
        int n = fastStringBuffer.length();
        if (n == 0) {
            return "";
        }
        if (fastStringBuffer.charAt(0) == '\'' || fastStringBuffer.charAt(0) == '\"') {
            if (n <= 2) {
                return "";
            }
            return fastStringBuffer.toString().substring(1, n - 1);
        }
        return fastStringBuffer.toString();
    }
}

