/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.AWTCompatibility;
import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.Event;
import netscape.application.EventProcessor;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.FoundationCheckMenuItem;
import netscape.application.FoundationMenuItem;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.JDK11AirLock;
import netscape.application.Menu;
import netscape.application.Rect;
import netscape.application.Target;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;

public class MenuItem
implements Codable,
Cloneable,
EventProcessor {
    Menu submenu;
    Menu supermenu;
    java.awt.MenuItem foundationMenuItem;
    String command;
    String title;
    Target target;
    char commandKey;
    Font font;
    Image checkedImage;
    Image uncheckedImage;
    Image image;
    Image selectedImage;
    Color selectedColor;
    Color selectedTextColor;
    Color textColor;
    Color disabledColor;
    boolean selected;
    boolean separator;
    boolean state;
    boolean enabled;
    Object data;
    static final String SUBMENU_KEY = "submenu";
    static final String SUPERMENU_KEY = "supermenu";
    static final String COMMAND_KEY = "command";
    static final String TITLE_KEY = "title";
    static final String TARGET_KEY = "target";
    static final String COMMANDKEY_KEY = "commandKey";
    static final String FONT_KEY = "font";
    static final String CHECKEDIMAGE_KEY = "checkedImage";
    static final String UNCHECKEDIMAGE_KEY = "uncheckedImage";
    static final String IMAGE_KEY = "image";
    static final String SELECTEDIMAGE_KEY = "selectedImage";
    static final String SELECTEDCOLOR_KEY = "selectedColor";
    static final String SELECTEDTEXTCOLOR_KEY = "selectedTextColor";
    static final String TEXTCOLOR_KEY = "textColor";
    static final String DISABLEDCOLOR_KEY = "disabledColor";
    static final String SEPARATOR_KEY = "separator";
    static final String STATE_KEY = "state";
    static final String ENABLED_KEY = "enabled";
    static final String DATA_KEY = "data";

    public MenuItem() {
        this("", '\u0000', null, null, false);
    }

    public MenuItem(String string, String string2, Target target) {
        this(string, '\u0000', string2, target, false);
    }

    public MenuItem(String string, char c, String string2, Target target) {
        this(string, c, string2, target, false);
    }

    public MenuItem(String string, String string2, Target target, boolean bl) {
        this(string, '\u0000', string2, target, bl);
    }

    public MenuItem(String string, char c, String string2, Target target, boolean bl) {
        this.commandKey = Character.toUpperCase(c);
        if (!bl) {
            this.foundationMenuItem = new FoundationMenuItem(string, this);
        } else {
            this.foundationMenuItem = new FoundationCheckMenuItem(string, this);
            this.setUncheckedImage(Bitmap.bitmapNamed("netscape/application/RadioButtonOff.gif"));
            this.setCheckedImage(Bitmap.bitmapNamed("netscape/application/RadioButtonOn.gif"));
            this.setImage(this.uncheckedImage);
            this.setSelectedImage(this.uncheckedImage);
        }
        this.setEnabled(true);
        this.setFont(new Font("Helvetica", 0, 12));
        this.setTitle(string);
        this.setTarget(target);
        this.setCommand(string2);
        this.selectedColor = Color.white;
        this.textColor = Color.black;
        this.selectedTextColor = Color.black;
        this.disabledColor = Color.gray;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InconsistencyException(this + ": clone() not supported :" + cloneNotSupportedException);
        }
    }

    java.awt.MenuItem foundationMenuItem() {
        return this.foundationMenuItem;
    }

    public void setSeparator(boolean bl) {
        this.separator = bl;
        if (bl) {
            this.setEnabled(true);
        }
    }

    public boolean isSeparator() {
        return this.separator;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public Object data() {
        return this.data;
    }

    public void setSubmenu(Menu menu) {
        this.submenu = menu;
        if (this.submenu != null) {
            this.submenu.setSuperitem(this);
        }
    }

    public Menu submenu() {
        return this.submenu;
    }

    public boolean hasSubmenu() {
        return this.submenu != null;
    }

    public void setSupermenu(Menu menu) {
        this.supermenu = menu;
    }

    public Menu supermenu() {
        return this.supermenu;
    }

    public void setCommandKey(char c) {
        this.commandKey = Character.toUpperCase(c);
        this.setTitle(this.title);
    }

    public char commandKey() {
        return this.commandKey;
    }

    public void setState(boolean bl) {
        this.state = bl;
        if (this.foundationMenuItem instanceof FoundationCheckMenuItem) {
            ((FoundationCheckMenuItem)this.foundationMenuItem).setState(this.state);
            if (this.state) {
                this.setImage(this.checkedImage());
                this.setSelectedImage(this.checkedImage());
                return;
            }
            this.setImage(this.uncheckedImage());
            this.setSelectedImage(this.uncheckedImage());
        }
    }

    public boolean state() {
        if (this.foundationMenuItem instanceof FoundationCheckMenuItem) {
            return this.state;
        }
        return false;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image image() {
        return this.image;
    }

    public void setSelectedImage(Image image) {
        this.selectedImage = image;
    }

    public Image selectedImage() {
        return this.selectedImage;
    }

    public void setCheckedImage(Image image) {
        this.checkedImage = image;
        if (this.foundationMenuItem instanceof FoundationCheckMenuItem && this.state()) {
            this.setImage(this.checkedImage);
            this.setSelectedImage(this.checkedImage);
        }
    }

    public Image checkedImage() {
        return this.checkedImage;
    }

    public void setUncheckedImage(Image image) {
        this.uncheckedImage = image;
        if (this.foundationMenuItem instanceof FoundationCheckMenuItem && !this.state()) {
            this.setImage(this.uncheckedImage);
            this.setSelectedImage(this.uncheckedImage);
        }
    }

    public Image uncheckedImage() {
        return this.uncheckedImage;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
    }

    public Color selectedColor() {
        return this.selectedColor;
    }

    public void setSelectedTextColor(Color color) {
        this.selectedTextColor = color;
    }

    public Color selectedTextColor() {
        return this.selectedTextColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Color textColor() {
        return this.textColor;
    }

    public void setDisabledColor(Color color) {
        this.disabledColor = color;
    }

    public Color disabledColor() {
        return this.disabledColor;
    }

    public void setSelected(boolean bl) {
        if (!this.isEnabled()) {
            bl = false;
        }
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String command() {
        return this.command;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public Target target() {
        return this.target;
    }

    public void processEvent(Event event) {
        this.sendCommand();
    }

    public void sendCommand() {
        if (this.target != null) {
            this.target.performCommand(this.command, this);
        }
    }

    private boolean canUseTabFormatter() {
        return false;
    }

    public void setTitle(String string) {
        String string2 = string;
        this.title = string;
        if (this.commandKey() != '\u0000') {
            if (JDK11AirLock.setMenuShortcut(this, this.commandKey())) {
                string2 = string;
            } else if (this.canUseTabFormatter()) {
                string2 = string + "\tCtrl+" + this.commandKey();
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                FontMetrics fontMetrics = this.font().fontMetrics();
                int n = this.supermenu() != null ? this.supermenu().minItemWidth() : this.minWidth();
                int n2 = fontMetrics.stringWidth(string);
                stringBuffer.append(string);
                int n3 = (n - n2) / fontMetrics.stringWidth(" ");
                int n4 = 0;
                while (n4 < n3) {
                    stringBuffer.append(' ');
                    ++n4;
                }
                string2 = stringBuffer.toString() + "  Ctrl+" + this.commandKey();
            }
        }
        this.foundationMenuItem.setLabel(string2);
    }

    public String title() {
        return this.title;
    }

    public int minHeight() {
        int n = 0;
        if (this.font() != null) {
            n = this.font().fontMetrics().stringHeight();
        }
        return n;
    }

    public int minWidth() {
        int n = 0;
        if (this.image != null) {
            n = this.image.width();
        }
        if (this.selectedImage != null && this.selectedImage.width() > n) {
            n = this.selectedImage.width();
        }
        if (this.font() != null) {
            n += this.font().fontMetrics().stringWidth(this.title);
        }
        if (n > 0) {
            n += 11;
        }
        return n += this.commandKeyWidth();
    }

    int commandKeyWidth() {
        int n = 0;
        if (this.font() != null && this.commandKey() != '\u0000') {
            n = this.font().fontMetrics().stringWidth("Ctrl+W");
            n += 10;
        }
        return n;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.hasSubmenu()) {
            this.submenu.awtMenu().enable(bl);
        } else {
            this.foundationMenuItem.enable(bl);
        }
        this.requestDraw();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setFont(Font font) {
        this.font = font;
        java.awt.Font font2 = AWTCompatibility.awtFontForFont(this.font);
        this.foundationMenuItem.setFont(font2);
    }

    public Font font() {
        return this.font;
    }

    public void requestDraw() {
        if (this.supermenu() != null && this.supermenu().menuView != null) {
            this.supermenu().menuView.drawItemAt(this.supermenu().indexOfItem(this));
        }
    }

    protected void drawSeparator(Graphics graphics, Rect rect) {
        int n = rect.y + rect.height / 2;
        int n2 = rect.x + rect.width;
        graphics.setColor(Color.gray153);
        graphics.drawLine(rect.x, n - 1, n2, n - 1);
        graphics.setColor(Color.gray231);
        graphics.drawLine(rect.x, n, n2, n);
    }

    protected void drawBackground(Graphics graphics, Rect rect) {
        if (this.isSelected()) {
            graphics.setColor(this.selectedColor);
            graphics.fillRect(rect);
        }
    }

    protected void drawStringInRect(Graphics graphics, String string, Font font, Rect rect, int n) {
        int n2 = 0;
        if (this.isEnabled() && !this.isSelected()) {
            graphics.setColor(this.textColor);
        } else if (this.isEnabled() && this.isSelected()) {
            graphics.setColor(this.selectedTextColor);
        } else {
            graphics.setColor(this.disabledColor);
        }
        graphics.setFont(font);
        graphics.drawStringInRect(string, rect, n);
        if (this.commandKey() != '\u0000') {
            Font font2 = this.font();
            if (font2 != null) {
                n2 = font2.fontMetrics().stringWidth("Ctrl+W");
                n2 += 10;
            }
            Rect rect2 = new Rect(rect.x + rect.width - n2, rect.y, n2, rect.height);
            String string2 = "Ctrl+" + this.commandKey();
            graphics.drawStringInRect(string2, rect2, 0);
        }
    }

    public void drawInRect(Graphics graphics, Rect rect, boolean bl) {
        if (this.isSeparator()) {
            this.drawSeparator(graphics, rect);
            return;
        }
        this.drawBackground(graphics, rect);
        Image image = this.isSelected() ? this.selectedImage : this.image;
        int n = 0;
        int n2 = 0;
        if (this.image != null) {
            n2 = this.image.width();
            n = this.image.height();
        }
        if (this.selectedImage != null) {
            if (this.selectedImage.width() > n2) {
                n2 = this.selectedImage.width();
            }
            if (this.selectedImage.height() > n) {
                n = this.selectedImage.height();
            }
        }
        if (image != null) {
            image.drawAt(graphics, rect.x, rect.y + (rect.height - n) / 2);
        }
        if (this.title != null && this.title.length() > 0) {
            Rect rect2 = Rect.newRect(rect.x + 2 + n2, rect.y, rect.width - 2 - n2, rect.height);
            this.drawStringInRect(graphics, this.title, this.font(), rect2, 0);
            Rect.returnRect(rect2);
        }
        if (bl && this.hasSubmenu()) {
            image = Bitmap.bitmapNamed("netscape/application/ScrollRightArrow.gif");
            n2 = image.width();
            n = image.height();
            image.drawAt(graphics, rect.x + rect.width - n2, rect.y + (rect.height - n) / 2);
        }
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.MenuItem", 1);
        classInfo.addField(SUBMENU_KEY, (byte)18);
        classInfo.addField(SUPERMENU_KEY, (byte)18);
        classInfo.addField(COMMAND_KEY, (byte)16);
        classInfo.addField(TITLE_KEY, (byte)16);
        classInfo.addField(TARGET_KEY, (byte)18);
        classInfo.addField(COMMANDKEY_KEY, (byte)2);
        classInfo.addField(FONT_KEY, (byte)18);
        classInfo.addField(CHECKEDIMAGE_KEY, (byte)18);
        classInfo.addField(UNCHECKEDIMAGE_KEY, (byte)18);
        classInfo.addField(IMAGE_KEY, (byte)18);
        classInfo.addField(SELECTEDIMAGE_KEY, (byte)18);
        classInfo.addField(SELECTEDCOLOR_KEY, (byte)18);
        classInfo.addField(SELECTEDTEXTCOLOR_KEY, (byte)18);
        classInfo.addField(TEXTCOLOR_KEY, (byte)18);
        classInfo.addField(DISABLEDCOLOR_KEY, (byte)18);
        classInfo.addField(SEPARATOR_KEY, (byte)0);
        classInfo.addField(ENABLED_KEY, (byte)0);
        classInfo.addField(STATE_KEY, (byte)0);
        classInfo.addField(DATA_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(SUBMENU_KEY, this.submenu);
        encoder.encodeObject(SUPERMENU_KEY, this.supermenu);
        encoder.encodeString(COMMAND_KEY, this.command);
        encoder.encodeString(TITLE_KEY, this.title);
        encoder.encodeObject(TARGET_KEY, this.target);
        encoder.encodeChar(COMMANDKEY_KEY, this.commandKey);
        encoder.encodeObject(FONT_KEY, this.font);
        encoder.encodeObject(CHECKEDIMAGE_KEY, this.checkedImage);
        encoder.encodeObject(UNCHECKEDIMAGE_KEY, this.uncheckedImage);
        encoder.encodeObject(IMAGE_KEY, this.image);
        encoder.encodeObject(SELECTEDIMAGE_KEY, this.selectedImage);
        encoder.encodeObject(SELECTEDCOLOR_KEY, this.selectedColor);
        encoder.encodeObject(SELECTEDTEXTCOLOR_KEY, this.selectedTextColor);
        encoder.encodeObject(TEXTCOLOR_KEY, this.textColor);
        encoder.encodeObject(DISABLEDCOLOR_KEY, this.disabledColor);
        encoder.encodeBoolean(SEPARATOR_KEY, this.separator);
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
        encoder.encodeBoolean(STATE_KEY, this.state);
        encoder.encodeObject(DATA_KEY, this.data);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.submenu = (Menu)decoder.decodeObject(SUBMENU_KEY);
        this.supermenu = (Menu)decoder.decodeObject(SUPERMENU_KEY);
        this.command = decoder.decodeString(COMMAND_KEY);
        this.title = decoder.decodeString(TITLE_KEY);
        this.target = (Target)decoder.decodeObject(TARGET_KEY);
        this.commandKey = decoder.decodeChar(COMMANDKEY_KEY);
        this.font = (Font)decoder.decodeObject(FONT_KEY);
        this.checkedImage = (Image)decoder.decodeObject(CHECKEDIMAGE_KEY);
        this.uncheckedImage = (Image)decoder.decodeObject(UNCHECKEDIMAGE_KEY);
        this.image = (Image)decoder.decodeObject(IMAGE_KEY);
        this.selectedImage = (Image)decoder.decodeObject(SELECTEDIMAGE_KEY);
        this.selectedColor = (Color)decoder.decodeObject(SELECTEDCOLOR_KEY);
        this.selectedTextColor = (Color)decoder.decodeObject(SELECTEDTEXTCOLOR_KEY);
        this.textColor = (Color)decoder.decodeObject(TEXTCOLOR_KEY);
        this.disabledColor = (Color)decoder.decodeObject(DISABLEDCOLOR_KEY);
        this.separator = decoder.decodeBoolean(SEPARATOR_KEY);
        this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        this.state = decoder.decodeBoolean(STATE_KEY);
        this.data = decoder.decodeObject(DATA_KEY);
    }

    public void finishDecoding() throws CodingException {
    }
}

