/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla.finitedifferences;

import org.jquantlib.math.Array;
import org.jquantlib.methods.finitedifferences.NullCondition;
import org.jquantlib.pricingengines.VanillaOptionEngine;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDMultiPeriodEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class FDBermudianEngine
extends VanillaOptionEngine {
    private double extraTermInBermuda;
    private FDMultiPeriodEngine fdVanillaEngine;

    public FDBermudianEngine(GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints, boolean timeDependent) {
        this.fdVanillaEngine = new FDBermudianMPEngine(process, timeSteps, gridPoints, timeDependent);
    }

    @Override
    public void calculate() {
        this.fdVanillaEngine.setupArguments(this.arguments);
        this.fdVanillaEngine.calculate(this.results);
    }

    void initializeStepCondition() {
        this.fdVanillaEngine.stepCondition_ = new NullCondition<Array>();
    }

    protected void executeIntermediateStep(int step) {
        int size = this.fdVanillaEngine.intrinsicValues.size();
        for (int j = 0; j < size; ++j) {
            this.fdVanillaEngine.prices_.values().set(j, Math.max(this.fdVanillaEngine.prices_.value(j), this.fdVanillaEngine.intrinsicValues.value(j)));
        }
    }

    private static class FDBermudianMPEngine
    extends FDMultiPeriodEngine {
        public FDBermudianMPEngine(GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints, boolean timeDependent) {
            super(process, timeSteps, gridPoints, timeDependent);
        }

        @Override
        protected void executeIntermediateStep(int step) {
            int size = this.intrinsicValues.size();
            for (int j = 0; j < size; ++j) {
                this.prices_.values().set(j, Math.max(this.prices_.value(j), this.intrinsicValues.value(j)));
            }
        }
    }
}

