/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Hungary
extends DelegateCalendar {
    private static final Hungary SETTLEMENT_CALENDAR = new Hungary(Market.SETTLEMENT);

    private Hungary(Market market) {
        SettlementCalendar delegate;
        switch (market) {
            case SETTLEMENT: {
                delegate = new SettlementCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Hungary getCalendar(Market market) {
        switch (market) {
            case SETTLEMENT: {
                return SETTLEMENT_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class SettlementCalendar
    extends WesternCalendar {
        private SettlementCalendar() {
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || dd == em || dd == em + 49 || d == 1 && m == Month.JANUARY || d == 15 && m == Month.MARCH || d == 1 && m == Month.MAY || d == 20 && m == Month.AUGUST || d == 23 && m == Month.OCTOBER || d == 1 && m == Month.NOVEMBER || d == 25 && m == Month.DECEMBER) && (d != 26 || m != Month.DECEMBER);
        }

        @Override
        public String getName() {
            return "Hungary";
        }
    }

    public static enum Market {
        SETTLEMENT;

    }
}

