/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Switzerland
extends DelegateCalendar {
    private static final Switzerland SETTLEMENT_CALENDAR = new Switzerland(Market.Settlement);
    private static final Switzerland SWX_CALENDAR = new Switzerland(Market.SWX);

    private Switzerland(Market market) {
        WesternCalendar delegate;
        switch (market) {
            case Settlement: {
                delegate = new SwisSettlementCalendar();
                break;
            }
            case SWX: {
                delegate = new SWXStockExchangeCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Switzerland getCalendar(Market market) {
        switch (market) {
            case Settlement: {
                return SETTLEMENT_CALENDAR;
            }
            case SWX: {
                return SWX_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class SWXStockExchangeCalendar
    extends WesternCalendar {
        private SWXStockExchangeCalendar() {
        }

        @Override
        public String getName() {
            return "SWX stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || d == 2 && m == Month.JANUARY || dd == em - 3 || dd == em || d == 1 && m == Month.MAY || dd == em + 38 || dd == em + 49 || d == 1 && m == Month.AUGUST || d == 25 && m == Month.DECEMBER) && (d != 26 || m != Month.DECEMBER);
        }
    }

    private static final class SwisSettlementCalendar
    extends WesternCalendar {
        private SwisSettlementCalendar() {
        }

        @Override
        public String getName() {
            return "Swiss settlement";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || d == 2 && m == Month.JANUARY || dd == em - 3 || dd == em || dd == em + 38 || dd == em + 49 || d == 1 && m == Month.MAY || d == 1 && m == Month.AUGUST || d == 24 && m == Month.DECEMBER || d == 25 && m == Month.DECEMBER || d == 26 && m == Month.DECEMBER) && (d != 31 || m != Month.DECEMBER);
        }
    }

    public static enum Market {
        Settlement,
        SWX;

    }
}

