/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.integrals;

import org.jquantlib.math.UnaryFunctionDouble;

public class TabulatedGaussLegendre {
    private static final double[] x6 = new double[]{0.238619186083197, 0.661209386466265, 0.932469514203152};
    private static final double[] w6 = new double[]{0.467913934572691, 0.360761573048139, 0.17132449237917};
    private static final int n6 = 3;
    private static final double[] x7 = new double[]{0.0, 0.405845151377397, 0.741531185599394, 0.949107912342759};
    private static final double[] w7 = new double[]{0.417959183673469, 0.381830050505119, 0.279705391489277, 0.12948496616887};
    private static final int n7 = 4;
    private static final double[] x12 = new double[]{0.125233408511469, 0.36783149899818, 0.587317954286617, 0.769902674194305, 0.904117256370475, 0.981560634246719};
    private static final double[] w12 = new double[]{0.249147045813403, 0.233492536538355, 0.203167426723066, 0.160078328543346, 0.106939325995318, 0.047175336386512};
    private static final int n12 = 6;
    private static final double[] x20 = new double[]{0.076526521133497, 0.227785851141645, 0.37370608871542, 0.510867001950827, 0.636053680726515, 0.746331906460151, 0.839116971822219, 0.912234428251326, 0.963971927277914, 0.993128599185095};
    private static final double[] w20 = new double[]{0.152753387130726, 0.149172986472604, 0.142096109318382, 0.131688638449177, 0.118194531961518, 0.10193011981724, 0.083276741576704, 0.062672048334109, 0.040601429800387, 0.017614007139152};
    private static final int n20 = 10;
    private int order_;
    private double[] x_;
    private double[] w_;
    private int n_;

    public TabulatedGaussLegendre() {
        this.setOrder(20);
    }

    public TabulatedGaussLegendre(int order) {
        this.setOrder(order);
    }

    public double evaluate(UnaryFunctionDouble f) {
        int startIdx;
        double val;
        boolean isOrderOdd;
        boolean bl = isOrderOdd = (this.order_ & 1) != 0;
        if (this.w_ == null) {
            throw new ArithmeticException("Null weights");
        }
        if (this.x_ == null) {
            throw new ArithmeticException("Null abscissas");
        }
        if (isOrderOdd) {
            if (this.n_ <= 0) {
                throw new ArithmeticException("assume at least 1 point in quadrature");
            }
            val = this.w_[0] * f.evaluate(this.x_[0]);
            startIdx = 1;
        } else {
            val = 0.0;
            startIdx = 0;
        }
        for (int i = startIdx; i < this.n_; ++i) {
            double w = this.w_[i];
            double x = this.x_[i];
            val += w * f.evaluate(x);
            val += w * f.evaluate(-x);
        }
        return val;
    }

    public void setOrder(int order) {
        switch (order) {
            case 6: {
                this.order_ = order;
                this.x_ = x6;
                this.w_ = w6;
                this.n_ = 3;
                break;
            }
            case 7: {
                this.order_ = order;
                this.x_ = x7;
                this.w_ = w7;
                this.n_ = 4;
                break;
            }
            case 12: {
                this.order_ = order;
                this.x_ = x12;
                this.w_ = w12;
                this.n_ = 6;
                break;
            }
            case 20: {
                this.order_ = order;
                this.x_ = x20;
                this.w_ = w20;
                this.n_ = 10;
                break;
            }
            default: {
                throw new ArithmeticException("order " + order + " not supported");
            }
        }
    }
}

