/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Poland
extends DelegateCalendar {
    private static final Poland SETTLEMENT_CALENDAR = new Poland(Market.Settlement);
    private static final Poland WSE_CALENDAR = new Poland(Market.WSE);

    private Poland(Market market) {
        WesternCalendar delegate;
        switch (market) {
            case Settlement: {
                delegate = new PolandSettlementCalendar();
                break;
            }
            case WSE: {
                delegate = new PolandWSECalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Poland getCalendar(Market market) {
        switch (market) {
            case Settlement: {
                return SETTLEMENT_CALENDAR;
            }
            case WSE: {
                return WSE_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class PolandWSECalendar
    extends WesternCalendar {
        private PolandWSECalendar() {
        }

        @Override
        public String getName() {
            return "Warsaw Stock Exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || dd == em || dd == em + 59 || d == 1 && m == Month.JANUARY || d == 1 && m == Month.MAY || d == 3 && m == Month.MAY || d == 15 && m == Month.AUGUST || d == 1 && m == Month.NOVEMBER || d == 11 && m == Month.NOVEMBER || d == 25 && m == Month.DECEMBER || d == 26 && m == Month.DECEMBER || dd == em - 3 || d == 24 && m == Month.DECEMBER) && (d != 2 || m != Month.JANUARY || !w.equals((Object)Weekday.FRIDAY));
        }
    }

    private static final class PolandSettlementCalendar
    extends WesternCalendar {
        private PolandSettlementCalendar() {
        }

        @Override
        public String getName() {
            return "Poland settlement";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || dd == em || dd == em + 59 || d == 1 && m == Month.JANUARY || d == 1 && m == Month.MAY || d == 3 && m == Month.MAY || d == 15 && m == Month.AUGUST || d == 1 && m == Month.NOVEMBER || d == 11 && m == Month.NOVEMBER || d == 25 && m == Month.DECEMBER) && (d != 26 || m != Month.DECEMBER);
        }
    }

    public static enum Market {
        Settlement,
        WSE;

    }
}

