/*
 * Decompiled with CFR 0.152.
 */
package net.jini.url.httpmd;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import net.jini.security.Security;
import net.jini.url.httpmd.Handler;

public class HttpmdUtil {
    private static final Handler handler = new Handler();

    private HttpmdUtil() {
    }

    public static String computeDigest(URL url, String algorithm) throws IOException, NoSuchAlgorithmException {
        return HttpmdUtil.computeDigest(url.openStream(), algorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String computeDigest(InputStream in, String algorithm) throws IOException, NoSuchAlgorithmException {
        String string;
        try {
            int n;
            if (!(in instanceof BufferedInputStream)) {
                in = new BufferedInputStream(in, 2048);
            }
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] buf = new byte[2048];
            while ((n = in.read(buf)) >= 0) {
                md.update(buf, 0, n);
            }
            string = HttpmdUtil.digestString(md.digest());
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                in.close();
            }
            catch (IOException e) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return string;
    }

    public static String computeDigestCodebase(String sourceDirectory, String codebase) throws IOException, MalformedURLException, NullPointerException {
        boolean isURL;
        try {
            new URL(sourceDirectory);
            isURL = true;
        }
        catch (MalformedURLException e) {
            isURL = false;
        }
        if (sourceDirectory.endsWith(isURL ? "/" : File.separator)) {
            sourceDirectory = sourceDirectory.substring(0, sourceDirectory.length() - 1);
        }
        StringTokenizer specs = new StringTokenizer(codebase);
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        while (specs.hasMoreTokens()) {
            String digest;
            InputStream in;
            String relSource;
            URI relSourceURI;
            URL url;
            final String spec = specs.nextToken();
            if (!"httpmd:".regionMatches(true, 0, spec, 0, 7)) {
                throw new IllegalArgumentException("Codebase URL does not specify HTTPMD protocol: " + spec);
            }
            try {
                url = (URL)Security.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException {
                        return new URL(null, spec, handler);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (MalformedURLException)e.getCause();
            }
            String path = url.getPath();
            int paramIndex = path.lastIndexOf(59);
            int equalsIndex = path.indexOf(61, paramIndex);
            int commentIndex = path.indexOf(44, equalsIndex);
            String algorithm = path.substring(paramIndex + 1, equalsIndex);
            try {
                relSourceURI = new URI("file:" + (path.startsWith("/") ? "" : "/") + path.substring(0, path.indexOf(59)));
            }
            catch (URISyntaxException e) {
                throw new MalformedURLException("Problem with codebase URL " + spec + ": " + e.getMessage());
            }
            if (isURL) {
                relSource = relSourceURI.getRawPath();
                in = new URL(sourceDirectory + relSource).openStream();
            } else {
                relSource = relSourceURI.getPath();
                if ('/' != File.separatorChar) {
                    relSource = relSource.replace('/', File.separatorChar);
                }
                in = new FileInputStream(sourceDirectory + relSource);
            }
            try {
                digest = HttpmdUtil.computeDigest(in, algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Shouldn't happen: " + e);
            }
            URL result = new URL(url, path.substring(0, equalsIndex + 1) + digest + (commentIndex < 0 ? "" : path.substring(commentIndex)) + (url.getQuery() == null ? "" : '?' + url.getQuery()) + (url.getRef() == null ? "" : '#' + url.getRef()));
            if (!first) {
                sb.append(' ');
            } else {
                first = false;
            }
            sb.append(result);
        }
        return sb.toString();
    }

    static String digestString(byte[] digest) {
        StringBuffer sb = new StringBuffer(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            sb.append(Character.forDigit(b >> 4 & 0xF, 16));
            sb.append(Character.forDigit(b & 0xF, 16));
        }
        return sb.toString();
    }

    static byte[] stringDigest(String s) throws NumberFormatException {
        byte[] result = new byte[(s.length() + 1) / 2];
        int rpos = result.length;
        int last = -1;
        int spos = s.length();
        while (--spos >= 0) {
            int digit = Character.digit(s.charAt(spos), 16);
            if (digit < 0) {
                throw new NumberFormatException("Illegal hex digit: '" + s.charAt(spos) + "'");
            }
            if (last < 0) {
                last = digit;
                continue;
            }
            result[--rpos] = (byte)(last + (digit << 4));
            last = -1;
        }
        if (last >= 0) {
            result[--rpos] = (byte)last;
        }
        return result;
    }

    static boolean commentChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || "-_.~*'():@&=+$,".indexOf(c) >= 0;
    }
}

