/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.math.Factorial;
import org.jquantlib.math.UnaryFunctionInteger;

public class PoissonDistribution
implements UnaryFunctionInteger {
    private double mu;
    private double logMu;

    public PoissonDistribution(double mu) {
        this.mu = mu;
        if (this.mu < 0.0) {
            throw new ArithmeticException("mu must be non negative (" + this.mu + " not allowed)");
        }
        if (this.mu != 0.0) {
            this.logMu = Math.log(this.mu);
        }
    }

    @Override
    public double evaluate(int k) {
        if (this.mu == 0.0) {
            if (k == 0) {
                return 1.0;
            }
            return 0.0;
        }
        Factorial fact = new Factorial();
        double logFactorial = fact.ln(k);
        return Math.exp((double)k * Math.log(this.mu) - logFactorial - this.mu);
    }
}

