/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public abstract class CumulativeProtocolDecoder
extends ProtocolDecoderAdapter {
    private static final String BUFFER = CumulativeProtocolDecoder.class.getName() + ".Buffer";

    protected CumulativeProtocolDecoder() {
    }

    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        ByteBuffer buf = (ByteBuffer)session.getAttribute(BUFFER);
        if (buf != null) {
            buf.put(in);
            buf.flip();
        } else {
            buf = in;
        }
        do {
            int oldPos = buf.position();
            boolean decoded = this.doDecode(session, buf, out);
            if (!decoded) break;
            if (buf.position() != oldPos) continue;
            throw new IllegalStateException("doDecode() can't return true when buffer is not consumed.");
        } while (buf.hasRemaining());
        if (buf.hasRemaining()) {
            this.storeRemainingInSession(buf, session);
        } else {
            this.removeSessionBuffer(session);
        }
    }

    protected abstract boolean doDecode(IoSession var1, ByteBuffer var2, ProtocolDecoderOutput var3) throws Exception;

    public void dispose(IoSession session) throws Exception {
        this.removeSessionBuffer(session);
    }

    private void removeSessionBuffer(IoSession session) {
        ByteBuffer buf = (ByteBuffer)session.getAttribute(BUFFER);
        if (buf != null) {
            buf.release();
            session.removeAttribute(BUFFER);
        }
    }

    private void storeRemainingInSession(ByteBuffer buf, IoSession session) {
        ByteBuffer remainingBuf = ByteBuffer.allocate(buf.remaining());
        remainingBuf.setAutoExpand(true);
        remainingBuf.put(buf);
        session.setAttribute(BUFFER, remainingBuf);
    }
}

