/*
 * Decompiled with CFR 0.152.
 */
package com.infor.core.pool;

import com.infor.core.pool.IRecyclable;
import com.infor.core.pool.IRecycleBin;
import com.infor.core.pool.RecycleBinIsEmptyException;
import java.util.EmptyStackException;
import java.util.Stack;

public class LIFO
implements IRecycleBin {
    protected Stack<IRecyclable> pool = new Stack();
    private volatile boolean isDestroyed = false;

    public void destroy() {
        this.isDestroyed = true;
        while (!this.pool.empty()) {
            IRecyclable r = this.pool.pop();
            r.destroy();
        }
        this.pool = null;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public IRecyclable getRecyclable() {
        IRecyclable r;
        if (this.isDestroyed) {
            throw new RecycleBinIsEmptyException("LIFO: is destroyed.");
        }
        try {
            r = this.pool.pop();
        }
        catch (EmptyStackException esx) {
            throw new RecycleBinIsEmptyException();
        }
        return r;
    }

    public int getSize() {
        return this.isDestroyed ? 0 : this.pool.size();
    }

    public void recycle(IRecyclable obj) {
        if (this.isDestroyed) {
            obj.destroy();
        } else {
            obj.clean();
            this.pool.push(obj);
        }
    }
}

