package aQute.lib.aim;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 * @author Peter Kriens
 */
public class AIM extends Thread {
	static int				idcount;

	long					lastLogin	= 0;
	String					user;
	boolean					restart		= false;
	String					password;
	int						seqNo		= (int) System.currentTimeMillis();
	Socket					connection;
	DataInputStream			in;
	DataOutputStream		out;
	boolean					active		= true;
	Hashtable				buddies		= new Hashtable();
	boolean					connected;
	int						id;
	int						watchdog;

	public static final int	SIGNON		= 1;
	public static final int	DATA		= 2;
	public static final int	ERROR		= 3;
	public static final int	SIGNOFF		= 4;
	public static final int	KEEPALIVE	= 5;

	boolean					online;
	static final int		MAX_SEQ		= 65535;
	static final String		HOST		= "toc.oscar.aol.com";
	static final int		PORT		= 9898;

	public AIM(String user, String password) {
		this.user = user;
		this.password = password;
		synchronized (this) {
			id = idcount++;
		}
	}

	// Client connects to TOC
	// Client sends "FLAPON\r\n\r\n"
	// TOC sends Client FLAP SIGNON
	// Client sends TOC FLAP SIGNON
	// Client sends TOC "toc_signon" message
	// if login fails TOC drops client's connection
	// else TOC sends client SIGN_ON reply
	// if Client doesn't support version it drops the connection
	//
	// [BEGIN OPTIONAL]
	// * TOC sends Client CONFIG
	// * Client sends TOC permit/deny stuff
	// * Client sends TOC toc_add_buddy message
	// [END OPTIONAL]
	//
	// Client sends TOC toc_init_done message

	public void run() {
		while (active)
			try {
				restart = false;
				long passed = System.currentTimeMillis() - lastLogin;
				if (passed < 30000)
					try {
						log(id + ": Delaying new login");
						Thread.sleep(30000 - passed);
					}
					catch (InterruptedException e) {
					}
				lastLogin = System.currentTimeMillis();

				connection = new Socket(HOST, PORT);
				connection.setSoTimeout(40000);
				in = new DataInputStream(connection.getInputStream());
				out = new DataOutputStream(new BufferedOutputStream(connection
						.getOutputStream()));

				out.writeBytes("FLAPON\r\n\r\n");
				out.flush();

				String msg = receive();

				// TOC SIGNON FRAME TYPE
				// ---------------------
				// Sequence Number contains the initial sequence number used in
				// each direction.
				// Data Length contains the payload length, with the payload
				// described
				// below. The payload area is NOT null terminated.
				//
				// Host To Client:
				// 4 byte FLAP version (1)
				//
				// Client To Host:
				// 4 byte FLAP version (1)
				// 2 byte TLV Tag (1)
				// 2 byte Normalized User Name Length
				// N byte Normalized User Name (NOT null terminated)

				byte[] payload = new byte[user.length() + 8];
				payload[3] = 1; // FLAP version
				payload[5] = 1; // TLV flag (?)
				payload[7] = (byte) user.length();
				System.arraycopy(user.getBytes(), 0, payload, 8, user.length());
				transmit(SIGNON, payload);

				// We have done the flap sign thingy now

				transmit("toc_signon login.oscar.aol.com 5159 " + user + " "
						+ roast(password) + " english marvin");

				online = true;

				msg = receive();

				if (msg.startsWith("ERROR"))
					throw new IOException("Signon error " + msg);

				connection.setSoTimeout(5000);
				while (active) {
					msg = receive();
					process(msg);
					if (msg.startsWith("CONFIG"))
						break;
				}
				init();
				transmit("toc_init_done");

				connection.setSoTimeout(15000);

				while (active && !restart)
					try {
						tick();
						process(receive());
					}
					catch (InterruptedIOException ie) {
						watchdog++;
						if (watchdog > 30) {
							watchdog = 0;
							transmit("toc_set_info " + escape("mobile"));
						}
					}
					catch (IOException ioe) {
						throw ioe;
					}
					catch (Exception e) {
						e.printStackTrace();
					}
			}
			catch (IOException e) {
				e.printStackTrace();
			}
			finally {
				for (Enumeration e = getBuddies(); e.hasMoreElements();) {
					Buddy b = (Buddy) e.nextElement();
					b.removed();
				}
				closed();
				connection = null;
			}

	}

	protected void closed() {
	}

	protected void setContinue(boolean cont) {
		active = cont;
	}

	public void close() {
		active = false;
		online = false;
		try {
			connection.close();
		}
		catch (Exception e) {
		}
	}

	public void restart() {
		restart = true;
		interrupt();
	}

	protected void tick() {
	}

	protected void init() throws IOException {
	}

	/**
	 * FLAP Header (6 bytes) ----------- Offset Size Type 0 1 ASTERISK (literal
	 * ASCII '*') 1 1 Frame Type 2 2 Sequence Number 4 2 Data Length 5 ..
	 * payload
	 * 
	 * Valid Frame Type Values ----------------------- 1 SIGNON 2 DATA 3 ERROR
	 * (Not used by TOC) 4 SIGNOFF (Not used by TOC) 5 KEEP_ALIVE
	 */
	String receive() throws IOException {
		char asterisk = (char) in.readByte();
		int frameType = in.readByte();
		int sequence = in.readShort();
		int length = in.readShort();
		byte data[] = new byte[length];
		in.readFully(data);
		String s = new String(data);
		log("Rx " + asterisk + " " + " " + frameType + " " + sequence + " " + s);
		return s;
	}

	public void transmit(String toBeSent) throws IOException {
		transmit(2, (toBeSent + "\0").getBytes());
	}

	public void transmit(int frameType, byte toBeSent[]) throws IOException {
		log("Tx " + readable(toBeSent));
		out.writeByte('*');
		out.writeByte(frameType);
		out.writeShort(seqNo++);
		out.writeShort(toBeSent.length);
		out.write(toBeSent);
		out.flush();
	}

	String readable(byte[] buffer) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < buffer.length; i++) {
			char c = (char) buffer[i];
			if (c >= 32 && c < 0x7F)
				sb.append(c);
			else {
				sb.append("\\");
				sb.append((int) c);
			}
		}
		return sb.toString();
	}

	public void process(String msg) {
		StringTokenizer st = new StringTokenizer(msg, ":");
		String cmd = st.nextToken();

		if (cmd.equals("ERROR"))
			error(st);
		else if (cmd.equals("NICK"))
			nick(st);
		else if (cmd.equals("CONFIG"))
			config(st);
		else if (cmd.equals("IM_IN"))
			imIn(st);
		else if (cmd.equals("UPDATE_BUDDY"))
			updateBuddy(st);
		else if (cmd.equals("EVILED"))
			eviled(st);
		else if (cmd.equals("CHAT_JOIN"))
			chatJoin(st);
		else if (cmd.equals("CHAT_UPDATE_BUDDY"))
			chatUpdateBuddy(st);
		else if (cmd.equals("CHAT_INVITE"))
			chatInvite(st);
		else if (cmd.equals("CHAT_LEFT"))
			chatLeft(st);
		else if (cmd.equals("PAUSE"))
			pause(st);
		else if (cmd.equals("GOTO_URL"))
			gotoURL(st);
		else
			log(msg + "????");
	}

	/**
	 * ERROR: <Error Code>:Var args To be documented *
	 */

	protected void error(StringTokenizer st) {
	}

	/**
	 * CONFIG: <config>A user's config. Config can be empty in which case the
	 * host was not able to retrieve it, or a config didn't exist for the user.
	 * See toc_set_config above for the format.
	 */
	protected void config(StringTokenizer st) {
	}

	/**
	 * NICK: <Nickname>Tells you your correct nickname (ie how it should be
	 * capitalized and spacing)
	 */
	protected void nick(StringTokenizer st) {

	}

	/**
	 * IM_IN: <Source User>: <Auto Response T/F?>: <Message>Receive an IM from
	 * some one. Everything after the third colon is the incoming message,
	 * including other colons.
	 */
	protected void imIn(StringTokenizer st) {
		String name = st.nextToken();
		String auto = st.nextToken();
		String msg = st.nextToken("\0").substring(1);
		imIn(name, auto.equals("T"), msg);
	}

	protected void imIn(String name, boolean auto, String msg) {
		Buddy buddy = getBuddy(name);
		buddy.imIn(auto, msg);
	}

	/**
	 * UPDATE_BUDDY: <Buddy User>: <Online? T/F>: <Evil Amount>: <Signon Time>:
	 * <IdleTime>: <UC>This one command handles arrival/depart/updates. Evil
	 * Amount is a percentage, Signon Time is UNIX epoc, idle time is in
	 * minutes, UC (User Class) is a two character string. uc[0]: ' ' - Ignore
	 * 'A' - On AOL uc[1] ' ' - Ignore 'A' - Oscar Admin 'U' - Oscar Unconfirmed
	 * 'O' - Oscar Normal
	 */
	protected void updateBuddy(StringTokenizer st) {
		String name = st.nextToken();
		String online = st.nextToken();
		st.nextToken();
		String signon = st.nextToken();
		String idle = st.nextToken();
		st.nextToken();

		Buddy buddy = getBuddy(name);
		buddy.setSince(new Date(Long.parseLong(signon)));
		buddy.setIdle(new Date(System.currentTimeMillis() - 60000
				* Integer.parseInt(idle)));
		buddy.setOnline(online.equals("T"));
	}

	protected Buddy getBuddy(String name) {
		Buddy buddy = (Buddy) buddies.get(name);
		if (buddy == null) {
			buddy = createBuddy(name);
			buddy.aim = this;
			buddies.put(name, buddy);
		}
		return buddy;
	}

	protected Buddy createBuddy(String name) {
		return new Buddy(this, name);
	}

	/**
	 * EVILED: <new evil>: <name of eviler, blank if anonymous> The user was
	 * just eviled.
	 */
	protected void eviled(StringTokenizer st) {
	}

	/**
	 * CHAT_JOIN: <Chat Room Id>: <Chat Room Name> We were able to join this
	 * chat room. The Chat Room Id is internal to TOC.
	 */
	protected void chatJoin(StringTokenizer st) {
	}

	/**
	 * CHAT_IN: <Chat Room Id>: <Source User>: <Whisper? T/F>: <Message>A chat
	 * message was sent in a chat room.
	 */
	protected void chatIn(StringTokenizer st) {
	}

	/**
	 * CHAT_UPDATE_BUDDY: <Chat Room Id>: <Inside? T/F>: <User 1>: <User 2>...
	 * This one command handles arrival/departs from a chat room. The very first
	 * message of this type for each chat room contains the users already in the
	 * room.
	 */
	protected void chatUpdateBuddy(StringTokenizer st) {
	}

	/**
	 * CHAT_INVITE: <Chat Room Name>: <Chat Room Id>: <Invite Sender>: <Message>
	 * We are being invited to a chat room.
	 */
	protected void chatInvite(StringTokenizer st) {
	}

	/**
	 * CHAT_LEFT: <Chat Room Id> Tells tic connection to chat room has been
	 * dropped
	 */
	protected void chatLeft(StringTokenizer st) {
	}

	/**
	 * GOTO_URL: <Window Name>: <Url>Goto a URL. Window Name is the suggested
	 * internal name of the window to use. (Java supports this.)
	 */
	protected void gotoURL(StringTokenizer st) {
	}

	/**
	 * PAUSE Tells TIC to pause so we can do migration
	 */
	protected void pause(StringTokenizer st) {
	}

	/**
	 * toc_add_buddy <Buddy User 1> [ <Buddy User2> [ <Buddy User 3> [...]]] Add
	 * buddies to your buddy list. This does not change your saved config.
	 */

	public void addBuddy(Buddy buddy) throws IOException {
		buddies.put(buddy.getName(), buddy);
		transmit("toc_add_buddy " + buddy.getName());
	}

	public void removeBuddy(String name) throws IOException {
		Buddy buddy = getBuddy(name);
		buddies.remove(name);
		buddy.removed();
		transmit("toc_remove_buddy ");
	}

	public Enumeration getBuddies() {
		return buddies.elements();
	}

	/**
	 * Sends a message to a designated recipient.
	 * 
	 * @param to the recipient
	 * @param message the message to send
	 */
	public void send(String to, String message) throws IOException {
		String work = "toc_send_im " + to + " \"" + escape(message) + "\"";

		transmit(work);
	}

	/**
	 * Escapes a string according to the requirements of AIM.
	 * 
	 * @param string the string to escape
	 * 
	 * @return the escaped string
	 */
	StringBuffer escape(String text) {
		StringBuffer work = new StringBuffer();

		for (int i = 0; i < text.length(); i++) {
			char c = text.charAt(i);
			switch (c) {
				case '$' :
				case '{' :
				case '}' :
				case '[' :
				case ']' :
				case '(' :
				case ')' :
				case '\"' :
				case '\\' :
					work.append("\\");
					break;
				default :
					break;
			}
			work.append(c);
		}
		return work;
	}

	public static String roast(String password) {
		String append = null;
		StringBuffer result = new StringBuffer("0x");

		int passLength = password.length();

		for (int index = 0; index < passLength; index++) {
			append = Long.toHexString(password.charAt(index)
					^ "Tic/Toc".charAt(index % 7));
			if (append.length() < 2) {
				result.append("0");
			}
			result.append(append);
		}
		return result.toString();
	}

	/**
	 * Removes spaces from a string.
	 * 
	 * @param in the string from which to remove spaces
	 * 
	 * @return the string without spaces
	 */
	public static String normalize(String in) {
		StringBuffer out = new StringBuffer(in);
		int space;
		while (((space = out.toString().indexOf(" ")) >= 0) && out.length() > 0)
			out.delete(space, space + 1);
		return out.toString();
	}

	public static String toText(String in) {
		StringBuffer sb = new StringBuffer();
		boolean outer = true;
		for (int i = 0; i < in.length(); i++) {
			char c = in.charAt(i);
			switch (c) {
				case '<' :
					outer = false;
					break;
				case '>' :
					outer = true;
					break;
				default :
					if (outer)
						sb.append(c);
			}
		}
		return sb.toString();
	}

	public static String toHtml(String in) {
		StringBuffer sb = new StringBuffer();
		sb.append("<html><body><pre>");
		for (int i = 0; i < in.length(); i++) {
			char c = in.charAt(i);
			switch (c) {
				case '<' :
					sb.append("&lt;");
					break;
				case '>' :
					sb.append("&gt;");
					break;
				case '&' :
					sb.append("&amp;");
					break;
				default :
					sb.append(c);
			}
		}
		sb.append("</pre></body></html>");
		return sb.toString();
	}

	public boolean isOnline() {
		return online;
	}

	/**
	 * Returns the user.
	 * 
	 * @return String
	 */
	public String getUser() {
		return user;
	}

	/**
	 * Sets the user.
	 * 
	 * @param user The user to set
	 */
	public void setUser(String user) {
		this.user = user;
	}

	public void log(String msg, Throwable te) {
		System.out.println(id + ": " + msg);
		if (te != null) {
			te.printStackTrace();
		}
	}

	public void log(String msg) {
		log(msg, null);
	}

	public static void main(String args[] ) {
		AIM	aim = new AIM("pkriens","HUIOJJ");
		aim.run();
	}
}