package aQute.test;

import java.io.*;
import java.util.*;

import junit.framework.*;
import aQute.lib.options.*;

public class TestOptions extends TestCase implements OptionTarget  {
	int 	anInt;
	boolean aBoolean;
	String	aString;
	File	aFile;
	long	aLong;
	List arguments = new ArrayList();
	Properties properties = new Properties();
	boolean found = false;
	String	[] aStringArray;
	List list = new ArrayList();

	public void addList(String s) throws Exception {
		list.add(s);
	}

	public void testList() throws Exception {
		Options.arguments(this, new String[] {"-list", "1", "-list", "2", "-list", "3"}, 0 );				
		assertEquals(3, list.size());
		assertTrue( list.contains("1"));
		assertTrue( list.contains("3"));
		assertTrue( list.contains("2"));
	}
	
	public void testMultiple() throws Exception {
		found = false;
		Options.arguments(this, new String[] {"-multiple", "maven", "TRUE"}, 0 );		
		assertTrue(found);
	}
	
	public void setMultiple(String repo, boolean maven ) {
		assertTrue(maven);
		assertEquals("maven",repo);
		found = true;
	}
	
	
	
	public void testSimple() throws Exception {
		Options.arguments(this, new String[] {"-anInt", "3", "-aBoolean", "true", "-aFile", "src", "-aLong","3", "a", "b", "c=4", "-aStringArray", "x,y,z"}, 0 );
		assertEquals(3, anInt );
		assertEquals(true, aBoolean );
		assertEquals("src", aFile.toString() );
		assertEquals(3, aLong );
		assertEquals(3, anInt );
		assertTrue(arguments.contains("a"));
		assertTrue(arguments.contains("b"));
		assertEquals("4", properties.get("c"));
	}

	public void setAnInt(int anInt) {
		this.anInt = anInt;
	}

	public void setABoolean(boolean boolean1) {
		aBoolean = boolean1;
	}
	public void setAStringArray(String[] stringArray) {
		aStringArray = stringArray;
	}

	public void setAString(String string) {
		aString = string;
	}

	public void setAFile(File file) {
		aFile = file;
	}

	public void setALong(long long1) {
		aLong = long1;
	}

	public void addDefault(String s) {
		arguments.add(s);
	}

	public void setProperty(String key, String value) {
		properties.put(key, value);
	}
}
