/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.Coords;
import megamek.common.IBoard;
import megamek.common.Targetable;

public class MinefieldTarget
implements Targetable {
    private static final long serialVersionUID = 420672189241204590L;
    private Coords m_coords;
    private int m_elev;

    public MinefieldTarget(Coords coords, IBoard iBoard) {
        this.m_coords = coords;
        this.m_elev = iBoard.getHex(this.m_coords).getElevation();
    }

    public int getTargetType() {
        return 5;
    }

    public int getTargetId() {
        return MinefieldTarget.coordsToId(this.m_coords);
    }

    public Coords getPosition() {
        return this.m_coords;
    }

    public int absHeight() {
        return this.getHeight() + this.getElevation();
    }

    public int getHeight() {
        return 0;
    }

    public int getElevation() {
        return this.m_elev;
    }

    public boolean isImmobile() {
        return true;
    }

    public String getDisplayName() {
        return "Minefield: " + this.m_coords.getBoardNum() + " (Clear)";
    }

    public static int coordsToId(Coords coords) {
        return coords.y * 100000 + coords.x;
    }

    public static Coords idToCoords(int n) {
        int n2 = n / 100000;
        return new Coords(n - n2 * 100000, n2);
    }

    public int sideTable(Coords coords) {
        return 0;
    }

    public boolean isOffBoard() {
        return false;
    }
}

