/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.IGame;
import megamek.common.Mounted;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.PrototypeUltraWeaponHandler;
import megamek.common.weapons.UACWeapon;
import megamek.server.Server;

public class ISUAC5Prototype
extends UACWeapon {
    private static final long serialVersionUID = -2740269177146528640L;

    public ISUAC5Prototype() {
        this.techLevel = 7;
        this.name = "Ultra AC/5 Prototype";
        this.setInternalName("ISUltraAC5Prototype");
        this.addLookupName("IS Ultra AC/5 Prototype");
        this.flags |= 0x200000L;
        this.heat = 1;
        this.damage = 5;
        this.rackSize = 5;
        this.minimumRange = 2;
        this.shortRange = 6;
        this.mediumRange = 13;
        this.longRange = 20;
        this.extremeRange = 26;
        this.tonnage = 9.0f;
        this.criticals = 6;
        this.bv = 112.0;
        this.cost = 200000.0;
        this.explosionDamage = this.damage;
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        Mounted mounted = iGame.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId());
        if (mounted.curMode().equals("Ultra")) {
            return new PrototypeUltraWeaponHandler(toHitData, weaponAttackAction, iGame, server);
        }
        return super.getCorrectHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

