################################################################################
#
#    (C) Copyright IBM Corp. 2006 All Rights Reserved.
#
#    The source code for this program is not published or
#    otherwise divested of its trade secrets, irrespective of
#    what has been deposited with the U.S. Copyright Office.
#
################################################################################

function usage
{
  if [[ -n ${flag_debug} ]]
  then
    set -x
  fi

  echo "Usage: r_FastBackShell.sh -i [IP Address] -c [FastBackShell Command] "
  echo "                          -v -h -i -f [path/configFileName] -w [path] -U [User name] "
  echo ""
  echo "  -i    [Required] IP Address of FastBackShell installation. "
  echo "  -c    [Required] Fastback Shell command and options. "
  echo "           example: -c -u admin -p admin123 -d xpress-restore mount dump -full " 
  echo "  -h    [Optional] Display this help. "
  echo "  -v    [Optional] Verbose. "
  echo "  -f    [Optional] Path and filename of config file. If not set the default config file is used. "
  echo "  -s    [Optional] Verify SSH keys are setup and a known host entry exists. "
  echo "  -w    [Optional] FastBackShell path. Default is \"/c/Program Files/Tivoli/TSM/FastBack/shell\". "
  echo "  -U	[Optional] Windows server User. Default is \"Administrator\". "
  echo ""
}

config_commandFile=`whence $0`
config_configFile=`dirname ${config_commandFile}`/configFile

. `dirname ${config_commandFile}`/commonFunctions

loadConfigFile

while getopts dhvsc:i:f:w:U: c 2> /dev/null
do
  case $c in
    c) config_FBSCmd=${OPTARG};;
    i) config_FBSIPAddr=${OPTARG};;
    d) set -x
       flag_debug=true;;
    h) usage
       exit;;
    v) flag_verbose=true;;
    s) flag_verifySSH=true;;
    f) config_configFile=${OPTARG}
       loadConfigFile;;
    w) config_FBSDirectory=${OPTARG};;
    U) config_FBSWindowsUser=${OPTARG};;
    *) usage
       exit_print "Wrong Usage" 1;;
  esac
done

if [[ -z ${config_FBSWindowsUser} ]]
then
  config_FBSWindowsUser=Administrator
fi

if [[ -z ${config_FBSIPAddr} ]]
then
  exit_print " You must provide a IP address of the FastBackShell Windows server." 20
fi

verbose_print "Checking FastBack Server Dependancies"
checkFastBackServerDependancies

if [[ -z ${config_FBSDirectory} ]]
then
  getFastBackShellDir > /dev/null
  config_FBSDirectory=`getFastBackShellDir`
fi

for i in `echo ${configVariableNameList}`
do
  export $i
done

verifySSH

verbose_print "Verify FastBackShell is installed at the location we expect: ${config_FBSDirectory}"
if ! executeRemoteCommand "cd \"${config_FBSDirectory}\"" false
then
  exit_print " Directory does not exist on FastBack Windows server: ${config_FBSDirectory}" 26
fi

verbose_print "Execute the Command: ${config_FBSCmd}"
executeRemoteCommand "cd \"${config_FBSDirectory}\";./FastBackShell.exe ${config_FBSCmd}"
returnCode=$?

if [[ ! ${returnCode} = 0 ]]
then
  if [[ -n ${flag_verbose} ]]
  then
    echo "" 1>&2
    echo " ERROR-${returnCode}- Command Failed: FastBackShell.exe ${config_FBSCmd}" 1>&2
  fi

  # Error Code 40 is the only RC executeRemoteCommand can return that is generated by the script.
  # All other non 0 values are from the FastbackServer and we dont have a list of good vs bad codes
  # So we cover all of these with the common RC 50.
  if [[ ! ${returnCode} = 40 ]]
  then
    exit_print " FastBackShell Command returned non 0 return code. RC: ${returnCode}" 50
  fi
fi

exit ${returnCode}

