echo off
SETLOCAL
echo .

echo "*************************************************"
echo "* Tivoli Storage Manager for virtual Environments"
echo "* DeleteACMFiles.bat log"
echo "* Current date and time:  %DATE% %TIME%"
echo "*************************************************"
echo .

echo whoami
whoami


echo current dir content:
dir
echo .

echo tasklist
tasklist
echo .

REM taskkill ERRORLEVEL 0 indicates the process was not running
if exist DummyBAProxy.exe (
   taskkill /IM DummyBAProxy.exe /T /F
   if %ERRORLEVEL% EQU 0 (
      echo Successfully stopped DummyBAProxy.exe 
   ) ELSE ( 
      echo failed to stop DummyBAProxy.exe.  Errorlevel: %ERRORLEVEL%
   )
   echo .
)

if exist ProxyBACLient.exe (
   taskkill /IM ProxyBACLient.exe /T /F
   if %ERRORLEVEL% EQU 0 (
      echo Successfully stopped ProxyBACLient.exe 
   ) ELSE ( 
      echo failed to stop ProxyBACLient.exe Errorlevel: %ERRORLEVEL%
   )
   echo .
)

if exist ProxyBACLient.exe (
   taskkill /IM ProxyBAServer.exe /T /F
   if %ERRORLEVEL% EQU 0 (
      echo Successfully stopped ProxyBACLient.exe 
   ) ELSE ( 
      echo failed to stop ProxyBACLient.exe Errorlevel: %ERRORLEVEL%
   )
   echo .
)

if exist CheckEnv.exe (
   taskkill /IM CheckEnv.exe /T /F
   if %ERRORLEVEL% EQU 0 (
      echo Successfully stopped CheckEnv.exe 
   ) ELSE ( 
      echo failed to stop CheckEnv.exe Errorlevel: %ERRORLEVEL%
   )
   echo .
)

if exist ProxyBAServer.exe (
   ProxyBAServer.exe /UnRegServer
   if %ERRORLEVEL% EQU 0 (
      echo Successfully unregistered the ProxyBAServer
   ) ELSE ( 
      echo failed to unregister ProxyBAServer.  Errorlevel: %ERRORLEVEL%
   )
echo .
)

if exist register_app.vbs (
   cscript register_app.vbs -unregister XR_VSS
   if %ERRORLEVEL% EQU 0 (
      echo register_app.vbs completed successfully
   ) ELSE ( 
      echo register_app.vbs failed.  Errorlevel: %ERRORLEVEL%
   )
   echo .
)

if "%1"  == "VMBACKUP_SAVE_GUEST" (
   echo VMBACKUP_SAVE_GUEST set.  Skipping delete of files
) ELSE (
   echo "Deleting files..."
   del /F TsmMSSqlLogTruncation.bat
   del /F register_app.vbs
   del /F TsmVmwareDpVSS.dll
   del /F DummyBAProxy.exe
   del /F ProxyBACLient.exe
   del /F ProxyBAServer.exe
   del /F CheckEnv.exe
   del /F .\Manifest\*.xml
)
echo .




echo Registry clean up:  TSM_VM_SNAP_STAT
REM IT17724 - if previous backup was on a pre-IT15333 level and unexpectedly failed
REG DELETE HKEY_CURRENT_USER\Environment /v TSM_VM_SNAP_STATE /f
if %ERRORLEVEL% EQU 0 (
   echo Reg delete TSM_VM_SNAP_STATE successful (local)
) ELSE ( 
   echo Reg delete TSM_VM_SNAP_STATE failed (local).  Errorlevel: %ERRORLEVEL%
)
echo .
REM IT15333 - using system env vars instead of user due to vmtools defect
REG DELETE "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v TSM_VM_SNAP_STATE /f
if %ERRORLEVEL% EQU 0 (
   echo Reg delete TSM_VM_SNAP_STATE successful (system)
) ELSE ( 
   echo Reg delete TSM_VM_SNAP_STATE failed (system).  Errorlevel: %ERRORLEVEL%
)
echo .



echo Registry clean up:  TSM_VM_SQL_LOG_TRUNC_STAT 
REM IT17724 - if previous backup was on a pre-IT15333 level and unexpectedly failed
REG DELETE HKEY_CURRENT_USER\Environment /v TSM_VM_SQL_LOG_TRUNC_STAT /f
if %ERRORLEVEL% EQU 0 (
   echo Reg delete TSM_VM_SQL_LOG_TRUNC_STAT successful (local)
) ELSE ( 
   echo Reg delete TSM_VM_SQL_LOG_TRUNC_STAT failed (local).  Errorlevel: %ERRORLEVEL%
)
echo .
REM IT15333 - using system env vars instead of user due to vmtools defect
REG DELETE "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v TSM_VM_SQL_LOG_TRUNC_STAT /f
if %ERRORLEVEL% EQU 0 (
   echo Reg delete TSM_VM_SQL_LOG_TRUNC_STAT successful (system)
) ELSE ( 
   echo Reg delete TSM_VM_SQL_LOG_TRUNC_STAT failed (system).  Errorlevel: %ERRORLEVEL%
)
echo .

echo Registry clean up:  TSM_VM_LOG 
REG DELETE HKEY_LOCAL_MACHINE\SOFTWARE /v TSM_VM_LOG /f
if %ERRORLEVEL% EQU 0 (
   echo Reg delete TSM_VM_LOG successful
) ELSE ( 
   echo Reg delete TSM_VM_LOG failed.  Errorlevel: %ERRORLEVEL%
)
echo .

echo Validating COM+ class ID removal
SET RegName="HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\COM3\SelfReg\CLSID\{FFDDE664-2E31-4D97-BDB6-FD9E6A318920}"
Reg query %RegName%
if %ERRORLEVEL% EQU 0 (
   REG DELETE %RegName% /f
   Reg query %RegName%
if %ERRORLEVEL% EQU 1 (echo failed to delete %RegName%)
) else ( 
   echo COM+ registry doesn't exist
)
echo .

echo Validating VSS Provider removal from control set 001
SET RegName="HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\services\VSS\Providers\{5409e1e7-826d-4ab6-9836-af4ffddeb678}"
Reg query %RegName%
if %ERRORLEVEL% EQU 0 (
   REG DELETE %RegName% /f 
   Reg query %RegName%
if %ERRORLEVEL% EQU 1 (echo failed to delete %RegName%)
) else ( 
   echo ControlSet001 Provider registry doesn't exist
)
echo .

echo Validating VSS SW Provider removal from control set 001
SET RegName="HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\services\VSS\Diag\SwProvider_{5409e1e7-826d-4ab6-9836-af4ffddeb678}"
Reg query %RegName%
if %ERRORLEVEL% EQU 0 (
   REG DELETE %RegName% /f 
   Reg query %RegName%
if %ERRORLEVEL% EQU 1 (echo failed to delete %RegName%)
) else ( 
   echo ControlSet001 SWProvider registry doesn't exist
)
echo .

echo Validating VSS Provider removal from current control set
SET RegName="HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\VSS\Diag\SwProvider_{5409e1e7-826d-4ab6-9836-af4ffddeb678}"
Reg query %RegName%
if %ERRORLEVEL% EQU 0 (
   REG DELETE %RegName% /f 
   Reg query %RegName%
if %ERRORLEVEL% EQU 1 (echo failed to delete %RegName%)
) else ( 
   echo ControlSet SWProvider registry doesn't exist
)
echo .

echo Validating VSS Provider removal from current control set
SET RegName="HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\VSS\Providers\{5409e1e7-826d-4ab6-9836-af4ffddeb678}"
Reg query %RegName%
if %ERRORLEVEL% EQU 0 (
   REG DELETE %RegName% /f 
   Reg query %RegName%
if %ERRORLEVEL% EQU 1 (echo failed to delete %RegName%)
)else ( 
   echo ControlSet Provider registry doesn't exist
)
echo .


net stop vss
echo .

net start vss
echo .

echo tasklist at end
tasklist
echo .

echo End: %DATE% %TIME%

ENDLOCAL
echo .
