/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.StrMatcher;
import org.apache.commons.text.StrTokenizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated
public class StrTokenizerTest {
    private static final String CSV_SIMPLE_FIXTURE = "A,b,c";
    private static final String TSV_SIMPLE_FIXTURE = "A\tb\tc";

    private void checkClone(StrTokenizer tokenizer) {
        Assertions.assertNotSame((Object)StrTokenizer.getCSVInstance(), (Object)tokenizer);
        Assertions.assertNotSame((Object)StrTokenizer.getTSVInstance(), (Object)tokenizer);
    }

    @Test
    public void test1() {
        String input = "a;b;c;\"d;\"\"e\";f; ; ;  ";
        StrTokenizer tok = new StrTokenizer("a;b;c;\"d;\"\"e\";f; ; ;  ");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f", "", "", ""};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void test2() {
        String input = "a;b;c ;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer("a;b;c ;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c ", "d;\"e", "f", " ", " ", ""};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void test3() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", " c", "d;\"e", "f", " ", " ", ""};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void test4() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(true);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f"};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void test5() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f", null, null, null};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void test6() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", " c", "d;\"e", "f", null, null, null};
        int nextCount = 0;
        while (tok.hasNext()) {
            tok.next();
            ++nextCount;
        }
        int prevCount = 0;
        while (tok.hasPrevious()) {
            tok.previous();
            ++prevCount;
        }
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        Assertions.assertEquals((int)nextCount, (int)expected.length, (String)"could not cycle through entire token list using the 'hasNext' and 'next' methods");
        Assertions.assertEquals((int)prevCount, (int)expected.length, (String)"could not cycle through entire token list using the 'hasPrevious' and 'previous' methods");
    }

    @Test
    public void test7() {
        String input = "a   b c \"d e\" f ";
        StrTokenizer tok = new StrTokenizer("a   b c \"d e\" f ");
        tok.setDelimiterMatcher(StrMatcher.spaceMatcher());
        tok.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        tok.setIgnoredMatcher(StrMatcher.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "", "", "b", "c", "d e", "f", ""};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void test8() {
        String input = "a   b c \"d e\" f ";
        StrTokenizer tok = new StrTokenizer("a   b c \"d e\" f ");
        tok.setDelimiterMatcher(StrMatcher.spaceMatcher());
        tok.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        tok.setIgnoredMatcher(StrMatcher.noneMatcher());
        tok.setIgnoreEmptyTokens(true);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d e", "f"};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void testBasic1() {
        String input = "a  b c";
        StrTokenizer tok = new StrTokenizer("a  b c");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic2() {
        String input = "a \nb\fc";
        StrTokenizer tok = new StrTokenizer("a \nb\fc");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic3() {
        String input = "a \nb\u0001\fc";
        StrTokenizer tok = new StrTokenizer("a \nb\u0001\fc");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b\u0001", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic4() {
        String input = "a \"b\" c";
        StrTokenizer tok = new StrTokenizer("a \"b\" c");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"\"b\"", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic5() {
        String input = "a:b':c";
        StrTokenizer tok = new StrTokenizer("a:b':c", ':', '\'');
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b'", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicDelim1() {
        String input = "a:b:c";
        StrTokenizer tok = new StrTokenizer("a:b:c", ':');
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicDelim2() {
        String input = "a:b:c";
        StrTokenizer tok = new StrTokenizer("a:b:c", ',');
        Assertions.assertEquals((Object)"a:b:c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicEmpty1() {
        String input = "a  b c";
        StrTokenizer tok = new StrTokenizer("a  b c");
        tok.setIgnoreEmptyTokens(false);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicEmpty2() {
        String input = "a  b c";
        StrTokenizer tok = new StrTokenizer("a  b c");
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed1() {
        String input = "a: bIGNOREc : ";
        StrTokenizer tok = new StrTokenizer("a: bIGNOREc : ", ':');
        tok.setIgnoredMatcher(StrMatcher.stringMatcher((String)"IGNORE"));
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"bc", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed2() {
        String input = "IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ";
        StrTokenizer tok = new StrTokenizer("IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ", ':');
        tok.setIgnoredMatcher(StrMatcher.stringMatcher((String)"IGNORE"));
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"bc", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed3() {
        String input = "IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ";
        StrTokenizer tok = new StrTokenizer("IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ", ':');
        tok.setIgnoredMatcher(StrMatcher.stringMatcher((String)"IGNORE"));
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"  bc  ", (Object)tok.next());
        Assertions.assertEquals((Object)"  ", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed4() {
        String input = "IGNOREaIGNORE: IGNORE 'bIGNOREc'IGNORE'd' IGNORE : IGNORE ";
        StrTokenizer tok = new StrTokenizer("IGNOREaIGNORE: IGNORE 'bIGNOREc'IGNORE'd' IGNORE : IGNORE ", ':', '\'');
        tok.setIgnoredMatcher(StrMatcher.stringMatcher((String)"IGNORE"));
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"bIGNOREcd", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted1() {
        String input = "a 'b' c";
        StrTokenizer tok = new StrTokenizer("a 'b' c", ' ', '\'');
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted2() {
        String input = "a:'b':";
        StrTokenizer tok = new StrTokenizer("a:'b':", ':', '\'');
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted3() {
        String input = "a:'b''c'";
        StrTokenizer tok = new StrTokenizer("a:'b''c'", ':', '\'');
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b'c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted4() {
        String input = "a: 'b' 'c' :d";
        StrTokenizer tok = new StrTokenizer("a: 'b' 'c' :d", ':', '\'');
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b c", (Object)tok.next());
        Assertions.assertEquals((Object)"d", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted5() {
        String input = "a: 'b'x'c' :d";
        StrTokenizer tok = new StrTokenizer("a: 'b'x'c' :d", ':', '\'');
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"bxc", (Object)tok.next());
        Assertions.assertEquals((Object)"d", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted6() {
        String input = "a:'b'\"c':d";
        StrTokenizer tok = new StrTokenizer("a:'b'\"c':d", ':');
        tok.setQuoteMatcher(StrMatcher.quoteMatcher());
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b\"c:d", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted7() {
        String input = "a:\"There's a reason here\":b";
        StrTokenizer tok = new StrTokenizer("a:\"There's a reason here\":b", ':');
        tok.setQuoteMatcher(StrMatcher.quoteMatcher());
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"There's a reason here", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuotedTrimmed1() {
        String input = "a: 'b' :";
        StrTokenizer tok = new StrTokenizer("a: 'b' :", ':', '\'');
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicTrimmed1() {
        String input = "a: b :  ";
        StrTokenizer tok = new StrTokenizer("a: b :  ", ':');
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicTrimmed2() {
        String input = "a:  b  :";
        StrTokenizer tok = new StrTokenizer("a:  b  :", ':');
        tok.setTrimmerMatcher(StrMatcher.stringMatcher((String)"  "));
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testChaining() {
        StrTokenizer tok = new StrTokenizer();
        Assertions.assertEquals((Object)tok, (Object)tok.reset());
        Assertions.assertEquals((Object)tok, (Object)tok.reset(""));
        Assertions.assertEquals((Object)tok, (Object)tok.reset(ArrayUtils.EMPTY_CHAR_ARRAY));
        Assertions.assertEquals((Object)tok, (Object)tok.setDelimiterChar(' '));
        Assertions.assertEquals((Object)tok, (Object)tok.setDelimiterString(" "));
        Assertions.assertEquals((Object)tok, (Object)tok.setDelimiterMatcher(null));
        Assertions.assertEquals((Object)tok, (Object)tok.setQuoteChar(' '));
        Assertions.assertEquals((Object)tok, (Object)tok.setQuoteMatcher(null));
        Assertions.assertEquals((Object)tok, (Object)tok.setIgnoredChar(' '));
        Assertions.assertEquals((Object)tok, (Object)tok.setIgnoredMatcher(null));
        Assertions.assertEquals((Object)tok, (Object)tok.setTrimmerMatcher(null));
        Assertions.assertEquals((Object)tok, (Object)tok.setEmptyTokenAsNull(false));
        Assertions.assertEquals((Object)tok, (Object)tok.setIgnoreEmptyTokens(false));
    }

    @Test
    public void testCloneNotSupportedException() {
        Object notCloned = new StrTokenizer(){

            Object cloneReset() throws CloneNotSupportedException {
                throw new CloneNotSupportedException("test");
            }
        }.clone();
        Assertions.assertNull((Object)notCloned);
    }

    @Test
    public void testCloneNull() {
        StrTokenizer tokenizer = new StrTokenizer((char[])null);
        Assertions.assertNull((Object)tokenizer.nextToken());
        tokenizer.reset();
        Assertions.assertNull((Object)tokenizer.nextToken());
        StrTokenizer clonedTokenizer = (StrTokenizer)tokenizer.clone();
        tokenizer.reset();
        Assertions.assertNull((Object)tokenizer.nextToken());
        Assertions.assertNull((Object)clonedTokenizer.nextToken());
    }

    @Test
    public void testCloneReset() {
        char[] input = new char[]{'a'};
        StrTokenizer tokenizer = new StrTokenizer(input);
        Assertions.assertEquals((Object)"a", (Object)tokenizer.nextToken());
        tokenizer.reset(input);
        Assertions.assertEquals((Object)"a", (Object)tokenizer.nextToken());
        StrTokenizer clonedTokenizer = (StrTokenizer)tokenizer.clone();
        input[0] = 98;
        tokenizer.reset(input);
        Assertions.assertEquals((Object)"b", (Object)tokenizer.nextToken());
        Assertions.assertEquals((Object)"a", (Object)clonedTokenizer.nextToken());
    }

    @Test
    public void testConstructor_charArray() {
        StrTokenizer tok = new StrTokenizer("a b".toCharArray());
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer(ArrayUtils.EMPTY_CHAR_ARRAY);
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer((char[])null);
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_charArray_char() {
        StrTokenizer tok = new StrTokenizer("a b".toCharArray(), ' ');
        Assertions.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer(ArrayUtils.EMPTY_CHAR_ARRAY, ' ');
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer((char[])null, ' ');
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_charArray_char_char() {
        StrTokenizer tok = new StrTokenizer("a b".toCharArray(), ' ', '\"');
        Assertions.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assertions.assertEquals((int)1, (int)tok.getQuoteMatcher().isMatch("\"".toCharArray(), 0, 0, 1));
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer(ArrayUtils.EMPTY_CHAR_ARRAY, ' ', '\"');
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer((char[])null, ' ', '\"');
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_String() {
        StrTokenizer tok = new StrTokenizer("a b");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer("");
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer((String)null);
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_String_char() {
        StrTokenizer tok = new StrTokenizer("a b", ' ');
        Assertions.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer("", ' ');
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer((String)null, ' ');
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_String_char_char() {
        StrTokenizer tok = new StrTokenizer("a b", ' ', '\"');
        Assertions.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assertions.assertEquals((int)1, (int)tok.getQuoteMatcher().isMatch("\"".toCharArray(), 0, 0, 1));
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer("", ' ', '\"');
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer((String)null, ' ', '\"');
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    private void testCSV(String data) {
        this.testXSVAbc(StrTokenizer.getCSVInstance((String)data));
        this.testXSVAbc(StrTokenizer.getCSVInstance((char[])data.toCharArray()));
    }

    @Test
    public void testCSVEmpty() {
        this.testEmpty(StrTokenizer.getCSVInstance());
        this.testEmpty(StrTokenizer.getCSVInstance((String)""));
    }

    @Test
    public void testCSVSimple() {
        this.testCSV(CSV_SIMPLE_FIXTURE);
    }

    @Test
    public void testCSVSimpleNeedsTrim() {
        this.testCSV("   A,b,c");
        this.testCSV("   \n\t  A,b,c");
        this.testCSV("   \n  A,b,c\n\n\r");
    }

    @Test
    public void testDelimMatcher() {
        String input = "a/b\\c";
        StrMatcher delimMatcher = StrMatcher.charSetMatcher((char[])new char[]{'/', '\\'});
        StrTokenizer tok = new StrTokenizer("a/b\\c", delimMatcher);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testDelimMatcherQuoteMatcher() {
        String input = "`a`;`b`;`c`";
        StrMatcher delimMatcher = StrMatcher.charSetMatcher((char[])new char[]{';'});
        StrMatcher quoteMatcher = StrMatcher.charSetMatcher((char[])new char[]{'`'});
        StrTokenizer tok = new StrTokenizer("`a`;`b`;`c`", delimMatcher, quoteMatcher);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testDelimString() {
        String input = "a##b##c";
        StrTokenizer tok = new StrTokenizer("a##b##c", "##");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    void testEmpty(StrTokenizer tokenizer) {
        this.checkClone(tokenizer);
        Assertions.assertFalse((boolean)tokenizer.hasNext());
        Assertions.assertFalse((boolean)tokenizer.hasPrevious());
        Assertions.assertNull((Object)tokenizer.nextToken());
        Assertions.assertEquals((int)0, (int)tokenizer.size());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((StrTokenizer)tokenizer).next());
    }

    @Test
    public void testGetContent() {
        String input = "a   b c \"d e\" f ";
        StrTokenizer tok = new StrTokenizer("a   b c \"d e\" f ");
        Assertions.assertEquals((Object)"a   b c \"d e\" f ", (Object)tok.getContent());
        tok = new StrTokenizer("a   b c \"d e\" f ".toCharArray());
        Assertions.assertEquals((Object)"a   b c \"d e\" f ", (Object)tok.getContent());
        tok = new StrTokenizer();
        Assertions.assertNull((Object)tok.getContent());
    }

    @Test
    public void testIteration() {
        StrTokenizer tkn = new StrTokenizer("a b c");
        Assertions.assertFalse((boolean)tkn.hasPrevious());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((StrTokenizer)tkn).previous());
        Assertions.assertTrue((boolean)tkn.hasNext());
        Assertions.assertEquals((Object)"a", (Object)tkn.next());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((StrTokenizer)tkn).remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> tkn.set("x"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> tkn.add("y"));
        Assertions.assertTrue((boolean)tkn.hasPrevious());
        Assertions.assertTrue((boolean)tkn.hasNext());
        Assertions.assertEquals((Object)"b", (Object)tkn.next());
        Assertions.assertTrue((boolean)tkn.hasPrevious());
        Assertions.assertTrue((boolean)tkn.hasNext());
        Assertions.assertEquals((Object)"c", (Object)tkn.next());
        Assertions.assertTrue((boolean)tkn.hasPrevious());
        Assertions.assertFalse((boolean)tkn.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((StrTokenizer)tkn).next());
        Assertions.assertTrue((boolean)tkn.hasPrevious());
        Assertions.assertFalse((boolean)tkn.hasNext());
    }

    @Test
    public void testListArray() {
        String input = "a  b c";
        StrTokenizer tok = new StrTokenizer("a  b c");
        String[] array = tok.getTokenArray();
        List list = tok.getTokenList();
        Assertions.assertEquals(Arrays.asList(array), (Object)list);
        Assertions.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testPreviousTokenAndSetEmptyTokenAsNull() {
        StrTokenizer strTokenizer = StrTokenizer.getTSVInstance((String)" \t\n\r\f");
        strTokenizer.setEmptyTokenAsNull(true);
        Assertions.assertNull((Object)strTokenizer.previousToken());
    }

    @Test
    public void testReset() {
        StrTokenizer tok = new StrTokenizer("a b c");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok.reset();
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testReset_charArray() {
        StrTokenizer tok = new StrTokenizer("x x x");
        char[] array = new char[]{'a', 'b', 'c'};
        tok.reset(array);
        Assertions.assertEquals((Object)"abc", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok.reset((char[])null);
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testReset_String() {
        StrTokenizer tok = new StrTokenizer("x x x");
        tok.reset("d e");
        Assertions.assertEquals((Object)"d", (Object)tok.next());
        Assertions.assertEquals((Object)"e", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok.reset((String)null);
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testStringTokenizerQuoteMatcher() {
        char[] chars = new char[]{'\'', 'a', 'c', '\'', 'd'};
        StrTokenizer tokens = new StrTokenizer(chars, StrMatcher.commaMatcher(), StrMatcher.quoteMatcher());
        Assertions.assertEquals((Object)"acd", (Object)tokens.next());
    }

    @Test
    public void testStringTokenizerStringMatcher() {
        char[] chars = new char[]{'a', 'b', 'c', 'd'};
        StrTokenizer tokens = new StrTokenizer(chars, "bc");
        Assertions.assertEquals((Object)"a", (Object)tokens.next());
        Assertions.assertEquals((Object)"d", (Object)tokens.next());
    }

    @Test
    public void testStringTokenizerStrMatcher() {
        char[] chars = new char[]{'a', ',', 'c'};
        StrTokenizer tokens = new StrTokenizer(chars, StrMatcher.commaMatcher());
        Assertions.assertEquals((Object)"a", (Object)tokens.next());
        Assertions.assertEquals((Object)"c", (Object)tokens.next());
    }

    @Test
    public void testTokenizeSubclassInputChange() {
        StrTokenizer tkn = new StrTokenizer("a b c d e"){

            protected List<String> tokenize(char[] chars, int offset, int count) {
                return super.tokenize("w x y z".toCharArray(), 2, 5);
            }
        };
        Assertions.assertEquals((Object)"x", (Object)tkn.next());
        Assertions.assertEquals((Object)"y", (Object)tkn.next());
    }

    @Test
    public void testTokenizeSubclassOutputChange() {
        StrTokenizer tkn = new StrTokenizer("a b c"){

            protected List<String> tokenize(char[] chars, int offset, int count) {
                List list = super.tokenize(chars, offset, count);
                Collections.reverse(list);
                return list;
            }
        };
        Assertions.assertEquals((Object)"c", (Object)tkn.next());
        Assertions.assertEquals((Object)"b", (Object)tkn.next());
        Assertions.assertEquals((Object)"a", (Object)tkn.next());
    }

    @Test
    public void testToString() {
        StrTokenizer tkn = new StrTokenizer("a b c d e");
        Assertions.assertEquals((Object)"StrTokenizer[not tokenized yet]", (Object)tkn.toString());
        tkn.next();
        Assertions.assertEquals((Object)"StrTokenizer[a, b, c, d, e]", (Object)tkn.toString());
    }

    @Test
    public void testTSV() {
        this.testXSVAbc(StrTokenizer.getTSVInstance((String)TSV_SIMPLE_FIXTURE));
        this.testXSVAbc(StrTokenizer.getTSVInstance((char[])TSV_SIMPLE_FIXTURE.toCharArray()));
    }

    @Test
    public void testTSVEmpty() {
        this.testEmpty(StrTokenizer.getTSVInstance());
        this.testEmpty(StrTokenizer.getTSVInstance((String)""));
    }

    void testXSVAbc(StrTokenizer tokenizer) {
        this.checkClone(tokenizer);
        Assertions.assertEquals((int)-1, (int)tokenizer.previousIndex());
        Assertions.assertEquals((int)0, (int)tokenizer.nextIndex());
        Assertions.assertNull((Object)tokenizer.previousToken());
        Assertions.assertEquals((Object)"A", (Object)tokenizer.nextToken());
        Assertions.assertEquals((int)1, (int)tokenizer.nextIndex());
        Assertions.assertEquals((Object)"b", (Object)tokenizer.nextToken());
        Assertions.assertEquals((int)2, (int)tokenizer.nextIndex());
        Assertions.assertEquals((Object)"c", (Object)tokenizer.nextToken());
        Assertions.assertEquals((int)3, (int)tokenizer.nextIndex());
        Assertions.assertNull((Object)tokenizer.nextToken());
        Assertions.assertEquals((int)3, (int)tokenizer.nextIndex());
        Assertions.assertEquals((Object)"c", (Object)tokenizer.previousToken());
        Assertions.assertEquals((int)2, (int)tokenizer.nextIndex());
        Assertions.assertEquals((Object)"b", (Object)tokenizer.previousToken());
        Assertions.assertEquals((int)1, (int)tokenizer.nextIndex());
        Assertions.assertEquals((Object)"A", (Object)tokenizer.previousToken());
        Assertions.assertEquals((int)0, (int)tokenizer.nextIndex());
        Assertions.assertNull((Object)tokenizer.previousToken());
        Assertions.assertEquals((int)0, (int)tokenizer.nextIndex());
        Assertions.assertEquals((int)-1, (int)tokenizer.previousIndex());
        Assertions.assertEquals((int)3, (int)tokenizer.size());
    }
}

